/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.util.NlTreeDumper;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import icons.StudioIcons;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateLayoutTestSkeletonAction
extends AnAction {
    private static final Pattern XML_PROLOG = Pattern.compile("^<\\?xml version.*$");

    public GenerateLayoutTestSkeletonAction() {
        super("Generate LayoutTest Skeleton");
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(0);
        }
        event.getPresentation().setEnabled(GenerateLayoutTestSkeletonAction.getModel(event.getProject()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NlModel model2;
        if (event == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(1);
        }
        if ((model2 = GenerateLayoutTestSkeletonAction.getModel(event.getProject())) == null) {
            return;
        }
        int option = Messages.showDialog((Project)model2.getProject(), (String)"Generate LayoutTest skeleton with the current layout components.", (String)"Generate LayoutTest Skeleton", (String[])new String[]{"Copy to Clipboard", "Cancel"}, (int)0, (Icon)StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT);
        if (option == 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateLayoutTestSkeletonAction.generateModelFixture(model2)));
        }
    }

    @Nullable
    private static NlModel getModel(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        DesignSurface surface2 = GenerateLayoutTestSkeletonAction.getSurface(project);
        if (surface2 == null) {
            return null;
        }
        SceneView screenView = surface2.getFocusedSceneView();
        if (screenView == null) {
            return null;
        }
        return screenView.getModel();
    }

    @Nullable
    private static DesignSurface getSurface(@NotNull Project project) {
        FileEditor[] editors;
        if (project == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(2);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        Editor editor2 = fileEditorManager.getSelectedTextEditor();
        if (editor2 == null) {
            return null;
        }
        NlPreviewManager previewManager = NlPreviewManager.getInstance(project);
        if (previewManager.isWindowVisible()) {
            return previewManager.getPreviewForm().getSurface();
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
        if (file == null) {
            return null;
        }
        for (FileEditor fileEditor : fileEditorManager.getEditors(file.getVirtualFile())) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        return null;
    }

    @NotNull
    private static String generateModelFixture(@NotNull NlModel model2) {
        if (model2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(3);
        }
        ImmutableList<NlComponent> components = model2.getComponents();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("import com.android.tools.idea.uibuilder.LayoutTestCase;\n").append("import com.android.tools.idea.uibuilder.fixtures.ModelBuilder;\n").append("import com.android.tools.idea.uibuilder.model.NlModel;\n").append("import com.android.tools.idea.uibuilder.util.NlTreeDumper;\n").append("import org.jetbrains.annotations.NotNull;\n").append("\n").append("import static com.android.SdkConstants.*;\n").append("\n").append("public class NewTest extends LayoutTestCase {\n").append("\n").append("  // TODO: Rename this test method\n").append("  public void testRenameThis() {\n").append("    NlModel model = createModel();\n").append("  }\n").append("\n").append("  @NotNull\n").append("  private NlModel createModel() {\n").append("    ModelBuilder builder = model(\"").append(model2.getFile().getName()).append("\",\n");
        for (NlComponent component3 : components) {
            GenerateLayoutTestSkeletonAction.appendComponent(component3, "\"    ModelBuilder builder = model(".length(), builder2);
        }
        builder2.append(");\n");
        builder2.append("    NlModel model = builder.build();\n").append("    format(model.getFile());\n").append("    assertEquals(").append(components.size()).append(", model.getComponents().size());\n");
        GenerateLayoutTestSkeletonAction.appendTreeComparison(components, builder2);
        GenerateLayoutTestSkeletonAction.appendXmlComparison(model2, builder2);
        builder2.append("\n").append("    return model;\n").append("  }\n").append("}\n");
        String string = builder2.toString();
        if (string == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void appendComponent(@NotNull NlComponent component3, int indent, @NotNull StringBuilder builder2) {
        if (component3 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(5);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(6);
        }
        builder2.append(StringUtil.repeat((String)" ", (int)indent)).append("component(").append(GenerateLayoutTestSkeletonAction.getTagSymbol(component3.getTagName())).append(")\n").append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(GenerateLayoutTestSkeletonAction.makeBounds(component3)).append("\n");
        for (AttributeSnapshot attribute : component3.getAttributes()) {
            GenerateLayoutTestSkeletonAction.appendAttribute(attribute, indent + 4, builder2);
        }
        if (component3.getChildCount() > 0) {
            builder2.append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(".children(\n");
            for (NlComponent child : component3.getChildren()) {
                GenerateLayoutTestSkeletonAction.appendComponent(child, indent + 4, builder2);
                builder2.replace(builder2.length() - 1, builder2.length(), ",\n\n");
            }
            builder2.replace(builder2.length() - 3, builder2.length(), ")\n");
        }
    }

    private static void appendAttribute(@NotNull AttributeSnapshot attribute, int indent, @NotNull StringBuilder builder2) {
        if (attribute == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(7);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(8);
        }
        if (GenerateLayoutTestSkeletonAction.implicitAttribute(attribute)) {
            return;
        }
        assert (attribute.value != null);
        if ("android".equals(attribute.prefix)) {
            switch (attribute.name) {
                case "id": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".id", attribute.value, builder2);
                    return;
                }
                case "text": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".text", attribute.value, builder2);
                    return;
                }
                case "layout_height": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "height", builder2);
                    return;
                }
                case "layout_width": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "width", builder2);
                    return;
                }
            }
        }
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".withAttribute", attribute.prefix, attribute.name, attribute.value, builder2);
    }

    private static void appendHeightOrWidth(int indent, @NotNull String value2, @NotNull String orientation, @NotNull StringBuilder builder2) {
        if (value2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(9);
        }
        if (orientation == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(10);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(11);
        }
        switch (value2) {
            case "wrap_content": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".wrapContent" + StringUtil.capitalize((String)orientation), builder2);
                break;
            }
            case "match_parent": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".matchParent" + StringUtil.capitalize((String)orientation), builder2);
                break;
            }
            default: {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, "." + orientation, value2, builder2);
            }
        }
    }

    private static void appendAttribute(int indent, @NotNull String with2, @NotNull StringBuilder builder2) {
        if (with2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(12);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(13);
        }
        builder2.append(StringUtil.repeat((String)" ", (int)indent)).append(with2).append("()\n");
    }

    private static void appendAttribute(int indent, @NotNull String with2, @Nullable String value2, @NotNull StringBuilder builder2) {
        if (with2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(14);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(15);
        }
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, with2, null, null, value2, builder2);
    }

    private static void appendAttribute(int indent, @NotNull String with2, @Nullable String prefix, @Nullable String name, @Nullable String value2, @NotNull StringBuilder builder2) {
        if (with2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(16);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(17);
        }
        if (value2 == null) {
            return;
        }
        builder2.append(StringUtil.repeat((String)" ", (int)indent)).append(with2).append("(\"");
        if (prefix != null) {
            builder2.append(prefix).append(":");
        }
        if (name != null) {
            builder2.append(name).append("\", \"");
        }
        builder2.append(value2).append("\")\n");
    }

    private static boolean implicitAttribute(@NotNull AttributeSnapshot attribute) {
        if (attribute == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(18);
        }
        if ("xmlns".equals(attribute.prefix)) {
            return true;
        }
        return attribute.value == null;
    }

    @NotNull
    private static String makeBounds(@NotNull NlComponent component3) {
        if (component3 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(19);
        }
        Rectangle bounds = GenerateLayoutTestSkeletonAction.getBounds(component3);
        String string = String.format(".withBounds(%d, %d, %d, %d)", bounds.x, bounds.y, bounds.width, bounds.height);
        if (string == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static Rectangle getBounds(@NotNull NlComponent component3) {
        NlComponent parent;
        if (component3 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(21);
        }
        Rectangle parentBounds = (parent = component3.getParent()) != null ? GenerateLayoutTestSkeletonAction.getBounds(parent) : new Rectangle(0, 0, 1000, 1000);
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component3);
        if (viewInfo == null) {
            return new Rectangle(parentBounds.x, parentBounds.y, 100, 100);
        }
        return new Rectangle(viewInfo.getLeft() + parentBounds.x, viewInfo.getTop() + parentBounds.y, viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
    }

    @NotNull
    private static String getTagSymbol(@NotNull String tagName) {
        if (tagName == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(22);
        }
        tagName = tagName.substring(1 + tagName.lastIndexOf(46));
        String string = StringUtil.toUpperCase((String)TemplateUtils.camelCaseToUnderlines(tagName));
        if (string == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static void appendTreeComparison(@NotNull List<NlComponent> components, @NotNull StringBuilder builder2) {
        if (components == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(24);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(25);
        }
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(NlTreeDumper.dumpTree(components), "NlTreeDumper.dumpTree(model.getComponents())", builder2, (List<Pattern>)ImmutableList.of(), false);
    }

    private static void appendXmlComparison(@NotNull NlModel model2, @NotNull StringBuilder builder2) {
        if (model2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(26);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(27);
        }
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(model2.getFile().getText(), "model.getFile().getText()", builder2, (List<Pattern>)ImmutableList.of((Object)XML_PROLOG), true);
    }

    private static void appendMultilineAssert(@NotNull String expectedMultilineResult, @NotNull String subject, @NotNull StringBuilder builder2, @NotNull List<Pattern> lineFilters, boolean addNewlineToLastLine) {
        if (expectedMultilineResult == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(28);
        }
        if (subject == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(29);
        }
        if (builder2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(30);
        }
        if (lineFilters == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(31);
        }
        String assertEquals = "    assertEquals(";
        builder2.append(assertEquals);
        String lastLine = "";
        int indent = 0;
        for (String line : Splitter.on((String)"\n").split((CharSequence)expectedMultilineResult)) {
            if (GenerateLayoutTestSkeletonAction.matches(line, lineFilters)) continue;
            builder2.append(StringUtil.repeat((String)" ", (int)indent));
            builder2.append("\"").append(line.replace("\"", "\\\"")).append("\\n\" +\n");
            indent = assertEquals.length();
            lastLine = line;
        }
        if (indent > 0) {
            builder2.setLength(builder2.length() - 6);
            if (lastLine.isEmpty()) {
                builder2.setLength(builder2.length() - 1 - indent - 6);
            }
            if (addNewlineToLastLine) {
                builder2.append("\\n");
            }
            builder2.append("\",\n");
        } else {
            builder2.append("\"\",\n");
        }
        builder2.append(StringUtil.repeat((String)" ", (int)assertEquals.length()));
        builder2.append(subject).append(");\n");
    }

    private static boolean matches(@NotNull String line, @NotNull List<Pattern> lineFilters) {
        if (line == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(32);
        }
        if (lineFilters == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(33);
        }
        for (Pattern pattern : lineFilters) {
            if (!pattern.matcher(line).matches()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction";
                break;
            }
            case 5: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedMultilineResult";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFilters";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateModelFixture";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeBounds";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSurface";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateModelFixture";
                break;
            }
            case 4: 
            case 20: 
            case 23: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendComponent";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendAttribute";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendHeightOrWidth";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "implicitAttribute";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeBounds";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTagSymbol";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendTreeComparison";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendXmlComparison";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendMultilineAssert";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

