/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.analytics;

import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.analytics.CommonUsageTrackerImpl;
import com.android.tools.idea.common.analytics.CommonUsageTrackerKt;
import com.android.tools.idea.common.analytics.UsageTrackerUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidAttribute;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutFavoriteAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutPaletteEvent;
import com.google.wireless.android.sdk.stats.SearchOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlUsageTrackerImpl
implements NlUsageTracker {
    private static final Pattern STYLE_PATTERN = Pattern.compile("style=\"(.*)\"");
    private static final Pattern INPUT_STYLE_PATTERN = Pattern.compile("android:inputType=\"(.*)\"");
    private static final Pattern ORIENTATION_PATTERN = Pattern.compile("android:orientation=\"(.*)\"");
    private static final Map<String, LayoutPaletteEvent.ViewOption> PALETTE_VIEW_OPTION_MAP = ImmutableMap.builder().put((Object)"textPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD).put((Object)"numberPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD_NUMERIC).put((Object)"textEmailAddress", (Object)LayoutPaletteEvent.ViewOption.EMAIL).put((Object)"phone", (Object)LayoutPaletteEvent.ViewOption.PHONE).put((Object)"textPostalAddress", (Object)LayoutPaletteEvent.ViewOption.POSTAL_ADDRESS).put((Object)"textMultiLine", (Object)LayoutPaletteEvent.ViewOption.MULTILINE_TEXT).put((Object)"time", (Object)LayoutPaletteEvent.ViewOption.TIME_EDITOR).put((Object)"date", (Object)LayoutPaletteEvent.ViewOption.DATE_EDITOR).put((Object)"number", (Object)LayoutPaletteEvent.ViewOption.NUMBER).put((Object)"numberSigned", (Object)LayoutPaletteEvent.ViewOption.SIGNED_NUMBER).put((Object)"numberDecimal", (Object)LayoutPaletteEvent.ViewOption.DECIMAL_NUMBER).build();
    @NotNull
    private final CommonUsageTracker myCommonTracker;

    NlUsageTrackerImpl(@NotNull Executor executor, @Nullable DesignSurface surface2, @NotNull Consumer<AndroidStudioEvent.Builder> eventLogger) {
        if (executor == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(0);
        }
        if (eventLogger == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(1);
        }
        if (surface2 == null || surface2.getModel() == null) {
            this.myCommonTracker = new CommonUsageTrackerImpl(executor, surface2, eventLogger);
        } else {
            Consumer<AndroidStudioEvent.Builder> builder2 = delegatingBuilder -> {
                CommonUsageTrackerKt.setApplicationId(delegatingBuilder, surface2.getModel().getFacet());
                eventLogger.accept((AndroidStudioEvent.Builder)delegatingBuilder);
            };
            this.myCommonTracker = new CommonUsageTrackerImpl(executor, surface2, builder2);
        }
    }

    @Override
    public void logDropFromPalette(@NotNull String viewTagName, @NotNull String representation, @NotNull String selectedGroup, int filterMatches) {
        if (viewTagName == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(2);
        }
        if (representation == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(3);
        }
        if (selectedGroup == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(4);
        }
        LayoutPaletteEvent.Builder builder2 = LayoutPaletteEvent.newBuilder().setView(UsageTrackerUtil.convertTagName(viewTagName)).setViewOption(NlUsageTrackerImpl.convertViewOption(viewTagName, representation)).setSelectedGroup(NlUsageTrackerImpl.convertGroupName(selectedGroup)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches));
        this.myCommonTracker.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE, event -> event.setPaletteEvent(builder2));
    }

    @Override
    public void logPropertyChange(@NotNull NlProperty property2, @NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode, int filterMatches) {
        if (property2 == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(5);
        }
        if (propertiesMode == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(6);
        }
        LayoutAttributeChangeEvent.Builder builder2 = LayoutAttributeChangeEvent.newBuilder().setAttribute(UsageTrackerUtil.convertAttribute(property2)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches)).setViewType(NlUsageTrackerImpl.convertPropertiesMode(propertiesMode));
        for (NlComponent component3 : property2.getComponents()) {
            builder2.addView(UsageTrackerUtil.convertTagName(component3.getTagName()));
        }
        this.myCommonTracker.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE, event -> event.setAttributeChangeEvent(builder2));
    }

    @Override
    public void logPropertyChange(@NotNull NelePropertyItem property2, int filterMatches) {
        if (property2 == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(7);
        }
        LayoutAttributeChangeEvent.Builder builder2 = LayoutAttributeChangeEvent.newBuilder().setAttribute(NlUsageTrackerImpl.convertAttribute(property2)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches));
        for (NlComponent component3 : property2.getComponents()) {
            builder2.addView(UsageTrackerUtil.convertTagName(component3.getTagName()));
        }
        this.myCommonTracker.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE, event -> event.setAttributeChangeEvent(builder2));
    }

    @NotNull
    private static AndroidAttribute convertAttribute(@NotNull NelePropertyItem property2) {
        if (property2 == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(8);
        }
        AndroidFacet facet2 = property2.getModel().getFacet();
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property2.getNamespace());
        AndroidAttribute androidAttribute = AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property2.getName(), namespace, property2.getLibraryName(), facet2)).setAttributeNamespace(namespace).build();
        if (androidAttribute == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(9);
        }
        return androidAttribute;
    }

    @Override
    public void logFavoritesChange(@NotNull String addedPropertyName, @NotNull String removedPropertyName, @NotNull List<String> currentFavorites, @NotNull AndroidFacet facet2) {
        if (addedPropertyName == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(10);
        }
        if (removedPropertyName == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(11);
        }
        if (currentFavorites == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(12);
        }
        if (facet2 == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(13);
        }
        LayoutFavoriteAttributeChangeEvent.Builder builder2 = LayoutFavoriteAttributeChangeEvent.newBuilder();
        if (!addedPropertyName.isEmpty()) {
            builder2.setAdded(UsageTrackerUtil.convertAttribute(addedPropertyName, facet2));
        }
        if (!removedPropertyName.isEmpty()) {
            builder2.setRemoved(UsageTrackerUtil.convertAttribute(removedPropertyName, facet2));
        }
        for (String propertyName : currentFavorites) {
            builder2.addActive(UsageTrackerUtil.convertAttribute(propertyName, facet2));
        }
        this.myCommonTracker.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE, event -> event.setFavoriteChangeEvent(builder2));
    }

    @NotNull
    static LayoutPaletteEvent.ViewGroup convertGroupName(@NotNull String groupName) {
        if (groupName == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(14);
        }
        switch (groupName) {
            case "All": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.ALL_GROUPS;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(15);
                }
                return viewGroup;
            }
            case "All Results": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.ALL_RESULTS;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(16);
                }
                return viewGroup;
            }
            case "Common": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.COMMON;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(17);
                }
                return viewGroup;
            }
            case "Buttons": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.BUTTONS;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(18);
                }
                return viewGroup;
            }
            case "Widgets": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.WIDGETS;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(19);
                }
                return viewGroup;
            }
            case "Text": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.TEXT;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(20);
                }
                return viewGroup;
            }
            case "Layouts": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.LAYOUTS;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(21);
                }
                return viewGroup;
            }
            case "Containers": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.CONTAINERS;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(22);
                }
                return viewGroup;
            }
            case "Images": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.IMAGES;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(23);
                }
                return viewGroup;
            }
            case "Date": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.DATES;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(24);
                }
                return viewGroup;
            }
            case "Transitions": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.TRANSITIONS;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(25);
                }
                return viewGroup;
            }
            case "Advanced": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.ADVANCED;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(26);
                }
                return viewGroup;
            }
            case "Google": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.GOOGLE;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(27);
                }
                return viewGroup;
            }
            case "Design": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.DESIGN;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(28);
                }
                return viewGroup;
            }
            case "AppCompat": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.APP_COMPAT;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(29);
                }
                return viewGroup;
            }
            case "Legacy": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.LEGACY;
                if (viewGroup == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(30);
                }
                return viewGroup;
            }
        }
        LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.CUSTOM;
        if (viewGroup == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(31);
        }
        return viewGroup;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertViewOption(@NotNull String tagName, @NotNull String representation) {
        if (tagName == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(32);
        }
        if (representation == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(33);
        }
        switch (tagName) {
            case "ProgressBar": {
                return NlUsageTrackerImpl.convertProgressBarViewOption(representation);
            }
            case "SeekBar": {
                return NlUsageTrackerImpl.convertSeekBarViewOption(representation);
            }
            case "EditText": {
                return NlUsageTrackerImpl.convertEditTextViewOption(representation);
            }
            case "LinearLayout": {
                return NlUsageTrackerImpl.convertLinearLayoutViewOption(representation);
            }
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
        if (viewOption == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(34);
        }
        return viewOption;
    }

    @NotNull
    static LayoutAttributeChangeEvent.ViewType convertPropertiesMode(@NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode) {
        if (propertiesMode == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(35);
        }
        switch (propertiesMode) {
            case TABLE: {
                LayoutAttributeChangeEvent.ViewType viewType = LayoutAttributeChangeEvent.ViewType.PROPERTY_TABLE;
                if (viewType == null) {
                    NlUsageTrackerImpl.$$$reportNull$$$0(36);
                }
                return viewType;
            }
        }
        LayoutAttributeChangeEvent.ViewType viewType = LayoutAttributeChangeEvent.ViewType.INSPECTOR;
        if (viewType == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(37);
        }
        return viewType;
    }

    @NotNull
    static SearchOption convertFilterMatches(int matches) {
        if (matches < 1) {
            SearchOption searchOption = SearchOption.NONE;
            if (searchOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(38);
            }
            return searchOption;
        }
        if (matches > 1) {
            SearchOption searchOption = SearchOption.MULTIPLE_MATCHES;
            if (searchOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(39);
            }
            return searchOption;
        }
        SearchOption searchOption = SearchOption.SINGLE_MATCH;
        if (searchOption == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(40);
        }
        return searchOption;
    }

    @Nullable
    @VisibleForTesting
    static String getStyleValue(@NotNull String representation) {
        Matcher matcher;
        if (representation == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(41);
        }
        return (matcher = STYLE_PATTERN.matcher(representation)).find() ? matcher.group(1) : null;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertProgressBarViewOption(@NotNull String representation) {
        String styleValue;
        if (representation == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(42);
        }
        if ((styleValue = NlUsageTrackerImpl.getStyleValue(representation)) == null || styleValue.equals("?android:attr/progressBarStyle")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(43);
            }
            return viewOption;
        }
        if (styleValue.equals("?android:attr/progressBarStyleHorizontal")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.HORIZONTAL_PROGRESS_BAR;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(44);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(45);
        }
        return viewOption;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertSeekBarViewOption(@NotNull String representation) {
        String styleValue;
        if (representation == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(46);
        }
        if ((styleValue = NlUsageTrackerImpl.getStyleValue(representation)) == null) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(47);
            }
            return viewOption;
        }
        if (styleValue.equals("@style/Widget.AppCompat.SeekBar.Discrete")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.DISCRETE_SEEK_BAR;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(48);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(49);
        }
        return viewOption;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertEditTextViewOption(@NotNull String representation) {
        Matcher matcher;
        if (representation == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(50);
        }
        if (!(matcher = INPUT_STYLE_PATTERN.matcher(representation)).find()) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(51);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = PALETTE_VIEW_OPTION_MAP.get(matcher.group(1));
        LayoutPaletteEvent.ViewOption viewOption2 = viewOption != null ? viewOption : LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption2 == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(52);
        }
        return viewOption2;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertLinearLayoutViewOption(@NotNull String representation) {
        Matcher matcher;
        if (representation == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(53);
        }
        if (!(matcher = ORIENTATION_PATTERN.matcher(representation)).find()) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(54);
            }
            return viewOption;
        }
        String orientation = matcher.group(1);
        if (orientation.equals("horizontal")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(55);
            }
            return viewOption;
        }
        if (orientation.equals("vertical")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.VERTICAL_LINEAR_LAYOUT;
            if (viewOption == null) {
                NlUsageTrackerImpl.$$$reportNull$$$0(56);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption == null) {
            NlUsageTrackerImpl.$$$reportNull$$$0(57);
        }
        return viewOption;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLogger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewTagName";
                break;
            }
            case 3: 
            case 33: 
            case 41: 
            case 42: 
            case 46: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "representation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedGroup";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesMode";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedPropertyName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedPropertyName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFavorites";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttribute";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "convertGroupName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "convertViewOption";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPropertiesMode";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFilterMatches";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "convertProgressBarViewOption";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeekBarViewOption";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "convertEditTextViewOption";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLinearLayoutViewOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logDropFromPalette";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logPropertyChange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertAttribute";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logFavoritesChange";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupName";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "convertViewOption";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "convertPropertiesMode";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getStyleValue";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "convertProgressBarViewOption";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "convertSeekBarViewOption";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "convertEditTextViewOption";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "convertLinearLayoutViewOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

