/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.android.tools.idea.uibuilder.visual.VisualizationManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class NlPreviewManager
implements Disposable {
    private final MergingUpdateQueue myToolWindowUpdateQueue;
    private final Project myProject;
    private NlPreviewForm myToolWindowForm;
    private ToolWindow myToolWindow;
    private boolean myToolWindowReady;
    private boolean myToolWindowDisposed;
    @VisibleForTesting
    private int myUpdateCount;
    private boolean mySeenEditor;
    private JComponent myPendingShowComponent;
    private HierarchyListener myHierarchyListener;

    public NlPreviewManager(@NotNull Project project) {
        if (project == null) {
            NlPreviewManager.$$$reportNull$$$0(0);
        }
        this.myToolWindowReady = false;
        this.myToolWindowDisposed = false;
        this.myProject = project;
        this.myToolWindowUpdateQueue = new MergingUpdateQueue("android.layout.preview", 100, true, null, (Disposable)project);
        if (!((Boolean)StudioFlags.NELE_SPLIT_EDITOR.get()).booleanValue()) {
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
        }
    }

    private void onToolWindowReady() {
        this.myToolWindowReady = true;
        this.processFileEditorChange(this.getActiveLayoutXmlEditor(null));
    }

    public boolean isWindowVisible() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    protected boolean isUseInteractiveSelector() {
        return true;
    }

    protected String getToolWindowId() {
        return AndroidBundle.message("android.layout.preview.tool.window.title", new Object[0]);
    }

    @NotNull
    protected NlPreviewForm createPreviewForm() {
        return new NlPreviewForm(this);
    }

    protected void initToolWindow() {
        if (((Boolean)StudioFlags.NELE_SPLIT_EDITOR.get()).booleanValue()) {
            return;
        }
        this.myToolWindowForm = this.createPreviewForm();
        Disposer.register((Disposable)this, (Disposable)this.myToolWindowForm);
        final String toolWindowId = this.getToolWindowId();
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(toolWindowId, false, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PREVIEW);
        this.myToolWindow.getComponent().setFocusTraversalPolicy(new NoDefaultFocusTraversalPolicy());
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow window;
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((window = toolWindowManager.getToolWindow(toolWindowId)) != null && window.isAvailable()) {
                    boolean visible = window.isVisible();
                    AndroidEditorSettings.getInstance().getGlobalState().setVisible(visible);
                    if (NlPreviewManager.this.myToolWindowForm != null) {
                        if (visible) {
                            NlPreviewManager.this.myToolWindowForm.activate();
                        } else {
                            NlPreviewManager.this.myToolWindowForm.deactivate();
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/android/tools/idea/uibuilder/editor/NlPreviewManager$1", "stateChanged"));
            }
        });
        JComponent contentPanel2 = this.myToolWindowForm.getComponent();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        contentManager.addDataProvider(dataId -> {
            TextEditor textEditor;
            if ((LangDataKeys.MODULE.is(dataId) || LangDataKeys.IDE_VIEW.is(dataId) || CommonDataKeys.VIRTUAL_FILE.is(dataId)) && (textEditor = this.myToolWindowForm.getEditor()) != null) {
                JComponent component3 = textEditor.getEditor().getContentComponent();
                DataContext context = DataManager.getInstance().getDataContext((Component)component3);
                return context.getData(dataId);
            }
            return null;
        });
        Content content2 = contentManager.getFactory().createContent(contentPanel2, null, false);
        content2.setDisposer((Disposable)this.myToolWindowForm);
        content2.setCloseable(false);
        content2.setPreferredFocusableComponent(contentPanel2);
        contentManager.addContent(content2);
        contentManager.setSelectedContent(content2, true);
        this.myToolWindowForm.setUseInteractiveSelector(this.isUseInteractiveSelector());
        if (this.isWindowVisible()) {
            this.myToolWindowForm.activate();
        }
    }

    public void dispose() {
        if (this.myToolWindowForm != null) {
            this.myToolWindowForm = null;
            this.myToolWindow = null;
            this.myToolWindowDisposed = true;
        }
    }

    @VisibleForTesting
    public int getUpdateCount() {
        return this.myUpdateCount;
    }

    @VisibleForTesting
    public boolean isPreviewVisible() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    private void processFileEditorChange(final @Nullable TextEditor newEditor) {
        if (this.myPendingShowComponent != null) {
            this.myPendingShowComponent.removeHierarchyListener(this.myHierarchyListener);
            this.myPendingShowComponent = null;
        }
        this.myToolWindowUpdateQueue.cancelAllUpdates();
        this.myToolWindowUpdateQueue.queue(new Update("update"){

            public void run() {
                boolean visible;
                Editor activeEditor;
                ++NlPreviewManager.this.myUpdateCount;
                if (!NlPreviewManager.this.myToolWindowReady || NlPreviewManager.this.myToolWindowDisposed) {
                    return;
                }
                Editor editor2 = activeEditor = newEditor != null ? newEditor.getEditor() : null;
                if (NlPreviewManager.this.myToolWindow == null) {
                    if (activeEditor == null) {
                        return;
                    }
                    if (!activeEditor.getComponent().isShowing()) {
                        if (!NlPreviewManager.this.mySeenEditor) {
                            NlPreviewManager.this.myPendingShowComponent = activeEditor.getComponent();
                            if (NlPreviewManager.this.myHierarchyListener == null) {
                                NlPreviewManager.this.myHierarchyListener = hierarchyEvent -> {
                                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getComponent() == NlPreviewManager.this.myPendingShowComponent && NlPreviewManager.this.myPendingShowComponent.isShowing()) {
                                        NlPreviewManager.this.myPendingShowComponent.removeHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                                        NlPreviewManager.this.mySeenEditor = true;
                                        NlPreviewManager.this.myPendingShowComponent = null;
                                        NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor(null));
                                    }
                                };
                            }
                            NlPreviewManager.this.myPendingShowComponent.addHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                        }
                        return;
                    }
                    NlPreviewManager.this.mySeenEditor = true;
                    NlPreviewManager.this.initToolWindow();
                }
                AndroidEditorSettings settings = AndroidEditorSettings.getInstance();
                boolean hideForNonLayoutFiles = settings.getGlobalState().isHideForNonLayoutFiles();
                if (activeEditor == null) {
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles);
                    return;
                }
                if (!NlPreviewManager.this.myToolWindowForm.setNextEditor(newEditor)) {
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles);
                    return;
                }
                NlPreviewManager.this.myToolWindow.setAvailable(true);
                boolean bl = visible = AndroidEditorSettings.getInstance().getGlobalState().isVisible() && !VisualizationManager.getInstance(NlPreviewManager.this.myProject).isWindowVisible();
                if (visible && !NlPreviewManager.this.myToolWindow.isVisible()) {
                    Runnable restoreFocus = null;
                    if (NlPreviewManager.this.myToolWindow.getType() == ToolWindowType.WINDOWED) {
                        restoreFocus = () -> IdeFocusManager.getInstance((Project)NlPreviewManager.this.myProject).doWhenFocusSettlesDown(() -> NlPreviewManager.restoreFocusToEditor(newEditor));
                    }
                    NlPreviewManager.this.myToolWindowForm.clearRenderResult();
                    NlPreviewManager.this.myToolWindow.activate(restoreFocus, false, false);
                }
            }
        });
    }

    private static void restoreFocusToEditor(@NotNull TextEditor newEditor) {
        if (newEditor == null) {
            NlPreviewManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> newEditor.getEditor().getContentComponent().requestFocus());
    }

    @Nullable
    private TextEditor getActiveLayoutXmlEditor(@Nullable PsiFile file) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (TextEditor)ApplicationManager.getApplication().runReadAction(() -> this.getActiveLayoutXmlEditor(file));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()).filter(editor2 -> editor2 instanceof TextEditor && this.isApplicableEditor((TextEditor)editor2, file)).findFirst().orElse(null);
    }

    public boolean isApplicableEditor(@NotNull TextEditor textEditor, @Nullable PsiFile file) {
        if (textEditor == null) {
            NlPreviewManager.$$$reportNull$$$0(2);
        }
        if (textEditor instanceof DesignToolsSplitEditor) {
            return false;
        }
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file != null && !file.equals(psiFile2)) {
            return false;
        }
        return NlPreviewManager.isInResourceFolder(psiFile2);
    }

    @Nullable
    protected XmlFile getBoundXmlFile(@Nullable PsiFile file) {
        return (XmlFile)file;
    }

    @Nullable
    protected ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    @NotNull
    public NlPreviewForm getPreviewForm() {
        if (this.myToolWindow == null) {
            this.initToolWindow();
        }
        NlPreviewForm nlPreviewForm = this.myToolWindowForm;
        if (nlPreviewForm == null) {
            NlPreviewManager.$$$reportNull$$$0(3);
        }
        return nlPreviewForm;
    }

    private static boolean isInResourceFolder(@Nullable PsiFile psiFile2) {
        if (psiFile2 instanceof XmlFile) {
            return RenderService.canRender(psiFile2);
        }
        return false;
    }

    @NotNull
    public static NlPreviewManager getInstance(@NotNull Project project) {
        if (project == null) {
            NlPreviewManager.$$$reportNull$$$0(4);
        }
        NlPreviewManager nlPreviewManager = (NlPreviewManager)project.getService(NlPreviewManager.class);
        if (nlPreviewManager == null) {
            NlPreviewManager.$$$reportNull$$$0(5);
        }
        return nlPreviewManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NlPreviewManager.$$$reportNull$$$0(6);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlPreviewManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewForm";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreFocusToEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableEditor";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NoDefaultFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private NoDefaultFocusTraversalPolicy() {
        }

        @Override
        @Nullable
        public Component getDefaultComponent(@Nullable Container aContainer) {
            super.getDefaultComponent(aContainer);
            return null;
        }
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            if (!file.isValid()) {
                return;
            }
            PsiFile psiFile2 = PsiManager.getInstance((Project)NlPreviewManager.this.myProject).findFile(file);
            NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor(psiFile2));
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(3);
            }
            if (NlPreviewManager.this.myToolWindowForm != null) {
                NlPreviewManager.this.myToolWindowForm.fileClosed(source, file);
            }
            if (!source.hasOpenFiles()) {
                ApplicationManager.getApplication().invokeLater(() -> NlPreviewManager.this.processFileEditorChange(null), NlPreviewManager.this.myProject.getDisposed());
            }
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            TextEditor textEditor;
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(4);
            }
            FileEditor newEditor = event.getNewEditor();
            TextEditor layoutXmlEditor = null;
            if (newEditor instanceof TextEditor && NlPreviewManager.this.isApplicableEditor(textEditor = (TextEditor)newEditor, null)) {
                layoutXmlEditor = textEditor;
            }
            NlPreviewManager.this.processFileEditorChange(layoutXmlEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewManager$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NlPreviewManagerPostStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                NlPreviewManagerPostStartupActivity.$$$reportNull$$$0(0);
            }
            if (!((Boolean)StudioFlags.NELE_SPLIT_EDITOR.get()).booleanValue()) {
                NlPreviewManager.getInstance(project).onToolWindowReady();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlPreviewManager$NlPreviewManagerPostStartupActivity", "runActivity"));
        }
    }
}

