/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.TextViewHandler;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditTextHandler
extends TextViewHandler {
    private static final Icon DEFAULT_ICON = StudioIcons.LayoutEditor.Palette.EDIT_TEXT;

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"inputType", (Object)"hint", (Object)"style", (Object)"singleLine", (Object)"selectAllOnFocus");
        if (immutableList == null) {
            EditTextHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component3) {
        if (component3 == null) {
            EditTextHandler.$$$reportNull$$$0(1);
        }
        if (!component3.getTagName().equals("EditText")) {
            String string = super.getTitleAttributes(component3);
            if (string == null) {
                EditTextHandler.$$$reportNull$$$0(2);
            }
            return string;
        }
        String title = super.getTitleAttributes(component3);
        if (StringUtil.isEmpty((String)title)) {
            EditTextInputType inputType = EditTextInputType.getInputType(component3);
            title = inputType != null ? String.format("(%s)", inputType.title) : "";
        }
        String string = title;
        if (string == null) {
            EditTextHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component3) {
        if (component3 == null) {
            EditTextHandler.$$$reportNull$$$0(4);
        }
        if (!component3.getTagName().equals("EditText")) {
            Icon icon2 = super.getIcon(component3);
            if (icon2 == null) {
                EditTextHandler.$$$reportNull$$$0(5);
            }
            return icon2;
        }
        EditTextInputType inputType = EditTextInputType.getInputType(component3);
        Icon icon3 = inputType != null ? inputType.icon : DEFAULT_ICON;
        if (icon3 == null) {
            EditTextHandler.$$$reportNull$$$0(6);
        }
        return icon3;
    }

    @Override
    @NotNull
    public String generateBaseId(@NotNull NlComponent component3) {
        String inputType;
        if (component3 == null) {
            EditTextHandler.$$$reportNull$$$0(7);
        }
        String string = "EditText" + ((inputType = component3.getAndroidAttribute("inputType")) == null ? "" : StringUtil.capitalize((String)inputType));
        if (string == null) {
            EditTextHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/EditTextHandler";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/EditTextHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateBaseId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTitleAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateBaseId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum EditTextInputType {
        PLAIN_TEXT("textPersonName", "Plain Text", StudioIcons.LayoutEditor.Palette.TEXTFIELD),
        PASSWORD("textPassword", "Password", StudioIcons.LayoutEditor.Palette.PASSWORD_TEXTFIELD),
        PASSWORD_NUMERIC("numberPassword", "Password (Numeric)", StudioIcons.LayoutEditor.Palette.PASSWORD_NUMERIC_TEXTFIELD),
        EMAIL("textEmailAddress", "E-mail", StudioIcons.LayoutEditor.Palette.EMAIL_TEXTFIELD),
        PHONE("phone", "Phone", StudioIcons.LayoutEditor.Palette.PHONE_TEXTFIELD),
        POSTAL_ADDRESS("textPostalAddress", "Postal Address", StudioIcons.LayoutEditor.Palette.POSTAL_ADDRESS_TEXTFIELD),
        MULTILINE_TEXT("textMultiLine", "Multiline Text", StudioIcons.LayoutEditor.Palette.TEXTFIELD_MULTILINE),
        TIME("time", "Time", StudioIcons.LayoutEditor.Palette.TIME_TEXTFIELD),
        DATE("date", "Date", StudioIcons.LayoutEditor.Palette.DATE_TEXTFIELD),
        NUMBER("number", "Number", StudioIcons.LayoutEditor.Palette.NUMBER_TEXTFIELD),
        NUMBER_SIGNED("numberSigned", "Number (Signed)", StudioIcons.LayoutEditor.Palette.NUMBER_SIGNED_TEXTFIELD),
        NUMBER_DECIMAL("numberDecimal", "Number (Decimal)", StudioIcons.LayoutEditor.Palette.NUMBER_DECIMAL_TEXTFIELD);

        @NotNull
        String typeString;
        @NotNull
        String title;
        @NotNull
        Icon icon;

        private EditTextInputType(@NotNull String typeString, String title, Icon icon2) {
            if (typeString == null) {
                EditTextInputType.$$$reportNull$$$0(0);
            }
            if (title == null) {
                EditTextInputType.$$$reportNull$$$0(1);
            }
            if (icon2 == null) {
                EditTextInputType.$$$reportNull$$$0(2);
            }
            this.typeString = typeString;
            this.title = title;
            this.icon = icon2;
        }

        @Nullable
        private static EditTextInputType getInputType(@NotNull NlComponent component3) {
            if (component3 == null) {
                EditTextInputType.$$$reportNull$$$0(3);
            }
            String inputTypeString = component3.getAttribute("http://schemas.android.com/apk/res/android", "inputType");
            return Arrays.stream(EditTextInputType.values()).filter(inputType -> inputType.typeString.equals(inputTypeString)).findAny().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeString";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/EditTextHandler$EditTextInputType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInputType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

