/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.model;

import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidgetContainer;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Rectangle;
import java.util.ArrayList;

public class WidgetContainer
extends ConstraintWidget {
    protected ArrayList<ConstraintWidget> mChildren = new ArrayList();

    public WidgetContainer() {
    }

    public WidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public WidgetContainer(int width, int height) {
        super(width, height);
    }

    @Override
    public void reset() {
        this.mChildren.clear();
        super.reset();
    }

    public void add(ConstraintWidget widget) {
        this.mChildren.add(widget);
        if (widget.getParent() != null) {
            WidgetContainer container = (WidgetContainer)widget.getParent();
            container.remove(widget);
        }
        widget.setParent(this);
    }

    public void remove(ConstraintWidget widget) {
        this.mChildren.remove(widget);
        widget.setParent(null);
    }

    public ArrayList<ConstraintWidget> getChildren() {
        return this.mChildren;
    }

    public ConstraintWidgetContainer getRootConstraintContainer() {
        ConstraintWidget item = this;
        ConstraintWidget parent = item.getParent();
        ConstraintWidgetContainer container = null;
        if (item instanceof ConstraintWidgetContainer) {
            container = (ConstraintWidgetContainer)this;
        }
        while (parent != null) {
            item = parent;
            parent = item.getParent();
            if (!(item instanceof ConstraintWidgetContainer)) continue;
            container = (ConstraintWidgetContainer)item;
        }
        return container;
    }

    public ConstraintWidget findWidget(float x, float y) {
        ConstraintWidget found = null;
        int l = this.getDrawX();
        int t = this.getDrawY();
        int r = l + this.getWidth();
        int b = t + this.getHeight();
        if (x >= (float)l && x <= (float)r && y >= (float)t && y <= (float)b) {
            found = this;
        }
        int mChildrenSize = this.mChildren.size();
        for (int i2 = 0; i2 < mChildrenSize; ++i2) {
            ConstraintWidget widget = this.mChildren.get(i2);
            if (widget instanceof WidgetContainer) {
                ConstraintWidget f = ((WidgetContainer)widget).findWidget(x, y);
                if (f == null) continue;
                found = f;
                continue;
            }
            l = widget.getDrawX();
            t = widget.getDrawY();
            r = l + widget.getWidth();
            b = t + widget.getHeight();
            if (!(x >= (float)l) || !(x <= (float)r) || !(y >= (float)t) || !(y <= (float)b)) continue;
            found = widget;
        }
        return found;
    }

    public ArrayList<ConstraintWidget> findWidgets(int x, int y, int width, int height) {
        ArrayList<ConstraintWidget> found = new ArrayList<ConstraintWidget>();
        Rectangle area = new Rectangle();
        area.setBounds(x, y, width, height);
        int mChildrenSize = this.mChildren.size();
        for (int i2 = 0; i2 < mChildrenSize; ++i2) {
            ConstraintWidget widget = this.mChildren.get(i2);
            Rectangle bounds = new Rectangle();
            bounds.setBounds(widget.getDrawX(), widget.getDrawY(), widget.getWidth(), widget.getHeight());
            if (!area.intersects(bounds)) continue;
            found.add(widget);
        }
        return found;
    }

    public static Rectangle getBounds(ArrayList<ConstraintWidget> widgets) {
        Rectangle bounds = new Rectangle();
        if (widgets.size() == 0) {
            return bounds;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        int widgetsSize = widgets.size();
        for (int i2 = 0; i2 < widgetsSize; ++i2) {
            ConstraintWidget widget = widgets.get(i2);
            if (widget.getX() < minX) {
                minX = widget.getX();
            }
            if (widget.getY() < minY) {
                minY = widget.getY();
            }
            if (widget.getRight() > maxX) {
                maxX = widget.getRight();
            }
            if (widget.getBottom() <= maxY) continue;
            maxY = widget.getBottom();
        }
        bounds.setBounds(minX, minY, maxX - minX, maxY - minY);
        return bounds;
    }

    @Override
    public void setOffset(int x, int y) {
        super.setOffset(x, y);
        int count = this.mChildren.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ConstraintWidget widget = this.mChildren.get(i2);
            widget.setOffset(this.getRootX(), this.getRootY());
        }
    }

    @Override
    public void updateDrawPosition() {
        super.updateDrawPosition();
        if (this.mChildren == null) {
            return;
        }
        int count = this.mChildren.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ConstraintWidget widget = this.mChildren.get(i2);
            widget.setOffset(this.getDrawX(), this.getDrawY());
            if (widget instanceof ConstraintWidgetContainer) continue;
            widget.updateDrawPosition();
        }
    }

    public void layout() {
        this.updateDrawPosition();
        if (this.mChildren == null) {
            return;
        }
        int count = this.mChildren.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ConstraintWidget widget = this.mChildren.get(i2);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
    }

    public void removeAllChildren() {
        this.mChildren.clear();
    }
}

