/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreatePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CreateTransition
extends BaseCreatePanel {
    static String TITLE = "Create ConstraintSet";
    JComboBox<String> mStartId = MEUI.makeComboBox(new String[0]);
    JComboBox<String> mEndId = MEUI.makeComboBox(new String[0]);
    private final JTextField mTransitionId;
    private final String DURATION_PROMPT = "Duration in ms";
    private final String ENTER_TID = "Enter Transition's id";
    String[] options = new String[]{"Do Nothing", "Jump to Start", "Jump to End", "Animate to Start", "Animate to End"};
    static final String[] ourValues = new String[]{"none", "jumpToStart", "jumpToEnd", "animateToStart", "animateToEnd"};
    JComboBox<String> comboBox = MEUI.makeComboBox(this.options);

    public CreateTransition() {
        this.icon = MEIcons.CREATE_TRANSITION;
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        CreateTransition.grid(gbc, 0, y++, 1, 1);
        gbc.weighty = 0.0;
        gbc.ipadx = MEUI.scale(60);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.fill = 2;
        this.add((Component)new JLabel("CREATE TRANSITION"), gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("ID"), gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mTransitionId = this.newTextField("Enter Transition's id", 15);
        this.add((Component)this.mTransitionId, gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Start"), gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.mStartId, gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("End"), gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.mEndId, gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Automatically"), gbc);
        CreateTransition.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.comboBox, gbc);
        gbc.weighty = 1.0;
        CreateTransition.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.insets(8, 12, 12, 12);
        gbc.anchor = 14;
        CreateTransition.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MeModel model2 = this.mMotionEditor.getMeModel();
        MTag[] mtags = model2.motionScene.getChildTags("ConstraintSet");
        if (mtags.length < 2) {
            this.showPreconditionDialog("Transition must at least 2 ConstraintSets to create a Transition");
            return false;
        }
        this.mStartId.removeAllItems();
        this.mEndId.removeAllItems();
        for (int i2 = 0; i2 < mtags.length; ++i2) {
            String id = mtags[i2].getAttributeValue("id");
            this.mStartId.addItem(Utils.stripID(id));
            this.mEndId.addItem(Utils.stripID(id));
        }
        this.mStartId.setSelectedIndex(0);
        this.mEndId.setSelectedIndex(1);
        return true;
    }

    @Override
    public MTag create() {
        String tid = this.mTransitionId.getText().trim();
        String sid = (String)this.mStartId.getSelectedItem();
        String eid = (String)this.mEndId.getSelectedItem();
        if (tid.equals("Enter Transition's id")) {
            tid = "";
        }
        if (tid.length() > 0 && Character.isDigit(tid.charAt(0))) {
            this.showErrorDialog("Transition ID cannot start with a number");
            return null;
        }
        if (sid.length() == 0 && eid.length() == 0) {
            this.showErrorDialog("Transition must have a start and end id");
            return null;
        }
        if (sid.length() == 0) {
            this.showErrorDialog("Transition must have a start id");
            return null;
        }
        if (eid.length() == 0) {
            this.showErrorDialog("Transition must have an end id");
            return null;
        }
        MeModel model2 = this.mMotionEditor.getMeModel();
        MTag.TagWriter writer = model2.motionScene.getChildTagWriter("Transition");
        if (tid.length() > 0) {
            writer.setAttribute("android", "id", this.addIdPrefix(tid));
        }
        writer.setAttribute("motion", "constraintSetStart", this.addIdPrefix(sid));
        writer.setAttribute("motion", "constraintSetEnd", this.addIdPrefix(eid));
        int index = this.comboBox.getSelectedIndex();
        if (index > 0) {
            writer.setAttribute("motion", "autoTransition", ourValues[index]);
        }
        MTag ret = writer.commit("Create Transition");
        Track.createTransition(this.mMotionEditor.myTrack);
        this.mMotionEditor.setMTag(model2);
        super.create();
        return ret;
    }

    @Override
    public String getName() {
        return "Transition";
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame(TITLE);
        f.setDefaultCloseOperation(3);
        f.setContentPane(new CreateTransition());
        f.pack();
        f.validate();
        f.setVisible(true);
    }
}

