/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEList;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScrollPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CombinedListPanel
extends JPanel {
    MTag mMotionScene;
    MTag mMotionLayout;
    ListSelectionListener mListSelectionListener;
    private boolean mSplitView = false;
    private static final int UNSCALED_LIST_MARGIN = 2;
    private int mScaledListMargin = MEUI.scale(2);
    boolean building = false;
    JList<Row> mMainList = new MEList();
    JScrollPane mTListPane = new MEScrollPane(this.mMainList);
    JList<Row> mConstraintSetList = new MEList();
    JScrollPane mConstraintSetPane = new MEScrollPane(this.mConstraintSetList);
    JList<Row> mTransitionList = new MEList();
    JScrollPane mTransitionPane = new MEScrollPane(this.mTransitionList);
    ListCellRenderer<Row> rowRenderer = new ListCellRenderer<Row>(){
        JLabel label = new JLabel();
        JLabel title = new JLabel();
        JPanel panel = new JPanel(new BorderLayout());
        Border b1 = BorderFactory.createMatteBorder(1, 0, 0, 0, MEUI.ourBorder);
        Border mChangeBorder;
        Border mNoBorder;
        Color mUnselectedColor;
        Color mSelectedColor;
        {
            this.mChangeBorder = BorderFactory.createCompoundBorder(this.b1, BorderFactory.createEmptyBorder(CombinedListPanel.this.mScaledListMargin - 1, CombinedListPanel.this.mScaledListMargin, 0, CombinedListPanel.this.mScaledListMargin));
            this.mNoBorder = BorderFactory.createEmptyBorder(CombinedListPanel.this.mScaledListMargin, CombinedListPanel.this.mScaledListMargin, 0, CombinedListPanel.this.mScaledListMargin);
            this.mUnselectedColor = MEUI.ourSecondaryPanelBackground;
            this.mSelectedColor = MEUI.ourMySelectedLineColor;
            this.title.setOpaque(true);
            this.panel.add(this.label);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Row> list, Row value2, int index, boolean isSelected, boolean cellHasFocus) {
            this.label.setFont(list.getFont());
            this.label.setText(value2.myString);
            String titleString = "";
            switch (value2.mType) {
                case LAYOUT: {
                    this.label.setIcon(MEIcons.LIST_LAYOUT);
                    titleString = "layout";
                    break;
                }
                case CONSTRAINT_SET: {
                    this.label.setIcon(MEIcons.CONSTRAINT_SET);
                    titleString = "Constraint Set";
                    break;
                }
                case TRANSITION: {
                    this.label.setIcon(MEIcons.LIST_TRANSITION);
                    titleString = "Transitions";
                    break;
                }
                case OTHER: {
                    this.label.setIcon(null);
                }
            }
            if (CombinedListPanel.this.mSplitView) {
                this.panel.remove(this.title);
                if (value2.mCount == 0 && index != 0) {
                    this.label.setBorder(this.mChangeBorder);
                } else {
                    this.label.setBorder(this.mNoBorder);
                }
                CombinedListPanel.this.mConstraintSetPane.getColumnHeader().getView().setBackground(MEUI.ourSecondaryHeaderBackgroundColor);
                CombinedListPanel.this.mConstraintSetPane.getColumnHeader().getView().setForeground(MEUI.ourSecondaryPanelHeaderTitleColor);
                CombinedListPanel.this.mTransitionPane.getColumnHeader().getView().setBackground(MEUI.ourSecondaryHeaderBackgroundColor);
                CombinedListPanel.this.mTransitionPane.getColumnHeader().getView().setForeground(MEUI.ourSecondaryPanelHeaderTitleColor);
            } else {
                this.label.setBorder(this.mNoBorder);
                this.title.setBorder(this.mNoBorder);
                if (value2.mCount == 0 && index != 0) {
                    this.title.setText(titleString);
                    this.panel.add((Component)this.title, "North");
                } else {
                    this.panel.remove(this.title);
                }
            }
            this.title.setBackground(MEUI.ourSecondaryHeaderBackgroundColor);
            this.title.setForeground(MEUI.ourSecondaryPanelHeaderTitleColor);
            this.label.setBackground(isSelected ? this.mSelectedColor : this.mUnselectedColor);
            this.label.setForeground(isSelected ? Color.WHITE : MEUI.ourTextColor);
            this.panel.setBackground(isSelected ? this.mSelectedColor : this.mUnselectedColor);
            this.panel.setForeground(isSelected ? Color.WHITE : MEUI.ourTextColor);
            return this.panel;
        }
    };

    CombinedListPanel() {
        super(new BorderLayout());
        this.setBackground(MEUI.ourSecondaryPanelBackground);
        this.mConstraintSetPane.setColumnHeaderView(this.addHorizontalMargin(new JLabel("Constraint Sets")));
        this.mConstraintSetPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, MEUI.ourBorder));
        this.mTransitionPane.setColumnHeaderView(this.addHorizontalMargin(new JLabel("Transitions")));
        this.mTransitionPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, MEUI.ourBorder));
        this.mMainList.setBackground(MEUI.ourSecondaryPanelBackground);
        this.mTransitionList.setBackground(MEUI.ourSecondaryPanelBackground);
        this.mConstraintSetList.setBackground(MEUI.ourSecondaryPanelBackground);
        this.mMainList.setCellRenderer(this.rowRenderer);
        this.mTransitionList.setCellRenderer(this.rowRenderer);
        this.mConstraintSetList.setCellRenderer(this.rowRenderer);
        this.mTListPane.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, MEUI.ourBorder));
        this.add((Component)this.mTListPane, "Center");
        ListSelectionListener listSelectionListener = e -> {
            if (e.getValueIsAdjusting() || this.building) {
                return;
            }
            if (e.getSource() == this.mConstraintSetList && this.mConstraintSetList.getSelectedIndex() != -1) {
                this.mTransitionList.clearSelection();
            } else if (e.getSource() == this.mTransitionList && this.mTransitionList.getSelectedIndex() != -1) {
                this.mConstraintSetList.clearSelection();
            }
            this.select(e);
        };
        this.mMainList.addListSelectionListener(listSelectionListener);
        this.mTransitionList.addListSelectionListener(listSelectionListener);
        this.mConstraintSetList.addListSelectionListener(listSelectionListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.mScaledListMargin = MEUI.scale(2);
    }

    public void setSplitView(boolean splitView) {
        this.mSplitView = splitView;
        if (splitView) {
            this.setLayout(new GridLayout(1, 2));
            this.remove(this.mTListPane);
            this.add(this.mConstraintSetPane);
            this.add(this.mTransitionPane);
        } else {
            this.setLayout(new BorderLayout());
            this.remove(this.mConstraintSetPane);
            this.remove(this.mTransitionPane);
            this.add(this.mTListPane);
        }
        this.validate();
    }

    void select(ListSelectionEvent e) {
        this.fireSelection(e);
    }

    public void setMTag(MTag motionScene, MTag layout2) {
        this.building = true;
        this.mMotionScene = motionScene;
        this.mMotionLayout = layout2;
        int selected = this.mMainList.getSelectedIndex();
        int csSelect = this.mConstraintSetList.getSelectedIndex();
        int transitionSelect = this.mTransitionList.getSelectedIndex();
        selected = Math.max(0, selected);
        ArrayList<MTag> list = motionScene.getChildren();
        Vector<Row> csRows = new Vector<Row>();
        Vector<Row> tRows = new Vector<Row>();
        int csCount = 0;
        int tCount = 0;
        csRows.add(new Row(null));
        for (MTag tag : list) {
            Row row = new Row(tag);
            if (row.mType == Row.Type.CONSTRAINT_SET) {
                row.mCount = csCount;
                csRows.insertElementAt(row, csCount + 1);
                ++csCount;
                continue;
            }
            if (row.mType != Row.Type.TRANSITION) continue;
            row.mCount = tCount;
            tRows.insertElementAt(row, tCount);
            ++tCount;
        }
        int count = this.mMotionLayout == null ? -1 : this.mMotionLayout.getChildTags().length;
        this.mConstraintSetList.setListData(csRows);
        this.mTransitionList.setListData(tRows);
        Vector<Row> rows = new Vector<Row>(csRows);
        rows.addAll(tRows);
        this.mMainList.setListData(rows);
        this.mMainList.setSelectedIndex(selected);
        this.mTransitionList.setSelectedIndex(csSelect);
        this.mConstraintSetList.setSelectedIndex(transitionSelect);
        this.building = false;
    }

    public void clearSelection() {
        this.building = true;
        this.mMainList.clearSelection();
        this.building = false;
    }

    public int getSelected() {
        return this.mMainList.getSelectedIndex();
    }

    public int getSelectedConstraintSet() {
        Row row = this.mSplitView ? this.mConstraintSetList.getSelectedValue() : this.mMainList.getSelectedValue();
        if (row == null) {
            return -1;
        }
        if (row.mType == Row.Type.CONSTRAINT_SET) {
            return 1 + row.mCount;
        }
        if (row.mType == Row.Type.LAYOUT) {
            return 0;
        }
        return -1;
    }

    public int getSelectedTransition() {
        Row row;
        if (this.mSplitView) {
            row = this.mTransitionList.getSelectedValue();
            if (row == null) {
                row = this.mConstraintSetList.getSelectedValue();
            }
        } else {
            row = this.mMainList.getSelectedValue();
        }
        if (row == null) {
            return -1;
        }
        if (row.mType == Row.Type.TRANSITION) {
            return row.mCount;
        }
        return -1;
    }

    public void selectTransition() {
        ListModel<Row> model2 = this.mSplitView ? this.mTransitionList.getModel() : this.mMainList.getModel();
        int size = model2.getSize();
        for (int i2 = 0; i2 < size; ++i2) {
            Row row = model2.getElementAt(i2);
            if (row.mType != Row.Type.TRANSITION) continue;
            this.mMainList.setSelectedIndex(i2);
            return;
        }
    }

    void setSelectionListener(ListSelectionListener l) {
        this.mListSelectionListener = l;
    }

    void fireSelection(ListSelectionEvent e) {
        if (this.mListSelectionListener == null) {
            System.err.println(" NO SELECTION LISTENER!");
            return;
        }
        this.mListSelectionListener.valueChanged(e);
    }

    public void selectTag(MTag tag) {
        if (tag == null) {
            return;
        }
        if (this.mSplitView) {
            String name = tag.getTagName();
            if (name.endsWith("MotionLayout")) {
                this.mConstraintSetList.setSelectedIndex(0);
                return;
            }
            if (name.endsWith("ConstraintSet")) {
                ListModel<Row> model2 = this.mConstraintSetList.getModel();
                int size = model2.getSize();
                for (int i2 = 0; i2 < size; ++i2) {
                    Row row = model2.getElementAt(i2);
                    if (!CombinedListPanel.tagEquals(tag, row.mTag)) continue;
                    this.mConstraintSetList.setSelectedIndex(i2);
                    return;
                }
            } else {
                ListModel<Row> model3 = this.mTransitionList.getModel();
                int size = model3.getSize();
                for (int i3 = 0; i3 < size; ++i3) {
                    Row row = model3.getElementAt(i3);
                    if (!CombinedListPanel.tagEquals(tag, row.mTag)) continue;
                    this.mTransitionList.setSelectedIndex(i3);
                    return;
                }
            }
        } else {
            ListModel<Row> model4 = this.mMainList.getModel();
            int size = model4.getSize();
            if (tag.getTagName().endsWith("MotionLayout")) {
                this.mMainList.setSelectedIndex(0);
                return;
            }
            for (int i4 = 0; i4 < size; ++i4) {
                Row row = model4.getElementAt(i4);
                if (!CombinedListPanel.tagEquals(tag, row.mTag)) continue;
                this.mMainList.setSelectedIndex(i4);
                return;
            }
        }
    }

    private static boolean tagEquals(MTag tag1, MTag tag2) {
        if (tag1 == null || tag2 == null) {
            return tag1 == tag2;
        }
        String t1 = tag1.getTreeId();
        String t2 = tag2.getTreeId();
        return Objects.equals(t1, t2);
    }

    private Component addHorizontalMargin(JLabel component3) {
        component3.setBorder(BorderFactory.createEmptyBorder(this.mScaledListMargin, this.mScaledListMargin, this.mScaledListMargin, this.mScaledListMargin));
        return component3;
    }

    static class Row {
        public int mCount = 0;
        Type mType;
        MTag mTag;
        String myString;

        Row(MTag tag) {
            String name;
            this.mTag = tag;
            if (this.mTag == null) {
                this.mType = Type.LAYOUT;
                this.myString = "MotionLayout";
                return;
            }
            switch (name = this.mTag.getTagName()) {
                case "ConstraintSet": {
                    this.mType = Type.CONSTRAINT_SET;
                    this.myString = this.buildListCSString(this.mTag);
                    break;
                }
                case "Transition": {
                    this.mType = Type.TRANSITION;
                    this.myString = this.buildListTransString(this.mTag);
                    break;
                }
                default: {
                    this.mType = Type.OTHER;
                }
            }
        }

        String buildListCSString(MTag tag) {
            String cid = Utils.stripID(tag.getAttributeValue("id"));
            int noc = tag.getChildTags().length;
            return cid + "(" + noc + ")";
        }

        String buildListTransString(MTag tag) {
            String tid = tag.getAttributeValue("id");
            tid = tid == null ? "T" : Utils.stripID(tid);
            String start = Utils.stripID(tag.getAttributeValue("constraintSetStart"));
            String end = Utils.stripID(tag.getAttributeValue("constraintSetEnd"));
            return tid + "(" + start + " -> " + end + ")";
        }

        static enum Type {
            LAYOUT,
            CONSTRAINT_SET,
            TRANSITION,
            OTHER;

        }
    }
}

