/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.MotionConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property2.SelectedTargetBuilder;
import com.android.tools.idea.uibuilder.handlers.motion.property2.SubTagAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.AddCustomFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.AddMotionFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.DeleteCustomFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.DeleteMotionFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.SubSectionControlAction;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.support.NeleEnumSupportProvider;
import com.android.tools.idea.uibuilder.property2.support.NeleTwoStateBooleanControlTypeProvider;
import com.android.tools.idea.uibuilder.property2.ui.EmptyTablePanel;
import com.android.tools.property.panel.api.EditorProvider;
import com.android.tools.property.panel.api.FilteredPTableModel;
import com.android.tools.property.panel.api.InspectorBuilder;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertiesModel;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertiesView;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.api.TableUIProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributesView
extends PropertiesView<NelePropertyItem> {
    private static final String MOTION_VIEW_NAME = "Motion";
    private static final List<String> CONSTRAINT_SECTIONS = ImmutableList.of((Object)"Layout", (Object)"Motion", (Object)"PropertySet", (Object)"Transform");

    public MotionLayoutAttributesView(@NotNull MotionLayoutAttributesModel model2) {
        if (model2 == null) {
            MotionLayoutAttributesView.$$$reportNull$$$0(0);
        }
        super(MOTION_VIEW_NAME, model2);
        NeleEnumSupportProvider enumSupportProvider2 = new NeleEnumSupportProvider(model2);
        NeleTwoStateBooleanControlTypeProvider controlTypeProvider2 = new NeleTwoStateBooleanControlTypeProvider(enumSupportProvider2);
        EditorProvider<NelePropertyItem> editorProvider = EditorProvider.Companion.create(enumSupportProvider2, controlTypeProvider2);
        TableUIProvider tableUIProvider = TableUIProvider.Companion.create(NelePropertyItem.class, controlTypeProvider2, editorProvider);
        this.getMain().getBuilders().add(new SelectedTargetBuilder());
        this.addTab("").getBuilders().add(new MotionInspectorBuilder(model2, tableUIProvider));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionLayoutAttributesView", "<init>"));
    }

    private static final class MotionInspectorBuilder
    implements InspectorBuilder<NelePropertyItem> {
        private final MotionLayoutAttributesModel myModel;
        private final TableUIProvider myTableUIProvider;
        private final XmlElementDescriptorProvider myDescriptorProvider;

        private MotionInspectorBuilder(@NotNull MotionLayoutAttributesModel model2, @NotNull TableUIProvider tableUIProvider) {
            if (model2 == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(0);
            }
            if (tableUIProvider == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(1);
            }
            this.myModel = model2;
            this.myTableUIProvider = tableUIProvider;
            this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<NelePropertyItem> properties) {
            NelePropertyItem any;
            if (inspector == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(2);
            }
            if (properties == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(3);
            }
            if ((any = properties.getFirst()) == null) {
                return;
            }
            MotionSelection selection = (MotionSelection)any.getOptionalValue1();
            if (selection == null) {
                return;
            }
            switch (selection.getType()) {
                case CONSTRAINT: {
                    boolean showConstraintPanel = !this.shouldDisplaySection("Layout", selection);
                    this.addPropertyTable(inspector, selection, "Constraint", this.myModel, true, false, showConstraintPanel);
                    this.addSubTagSections(inspector, selection, this.myModel);
                    break;
                }
                case TRANSITION: {
                    this.addPropertyTable(inspector, selection, selection.getMotionSceneTagName(), this.myModel, false, false, false);
                    this.addSubTagSections(inspector, selection, this.myModel);
                    break;
                }
                default: {
                    this.addPropertyTable(inspector, selection, selection.getMotionSceneTagName(), this.myModel, false, false, false);
                }
            }
            boolean showDefaultValues = selection.getType() == MotionEditorSelector.Type.CONSTRAINT;
            this.addCustomAttributes(inspector, selection, this.myModel, showDefaultValues);
        }

        private void addSubTagSections(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @NotNull MotionLayoutAttributesModel model2) {
            XmlElementDescriptor[] subTagDescriptors;
            XmlTag xmlTag;
            XmlElementDescriptor elementDescriptor;
            if (inspector == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(4);
            }
            if (selection == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(5);
            }
            if (model2 == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(6);
            }
            XmlElementDescriptor xmlElementDescriptor = elementDescriptor = (xmlTag = selection.getXmlTag(selection.getMotionSceneTag())) != null ? this.myDescriptorProvider.getDescriptor(xmlTag) : null;
            if (elementDescriptor == null) {
                return;
            }
            for (XmlElementDescriptor descriptor2 : subTagDescriptors = elementDescriptor.getElementsDescriptors(xmlTag)) {
                String subTagName = descriptor2.getName();
                if (subTagName.equals("CustomAttribute")) continue;
                boolean showConstraintWidget = subTagName.equals("Layout");
                SubTagAttributesModel subModel = new SubTagAttributesModel(model2, subTagName);
                this.addPropertyTable(inspector, selection, subTagName, subModel, true, true, showConstraintWidget);
            }
        }

        private void addCustomAttributes(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @NotNull MotionLayoutAttributesModel model2, boolean showDefaultValues) {
            if (inspector == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(7);
            }
            if (selection == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(8);
            }
            if (model2 == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(9);
            }
            if (!this.shouldDisplaySection("CustomAttribute", selection)) {
                return;
            }
            SubTagAttributesModel customModel = new SubTagAttributesModel(model2, "CustomAttribute");
            Function1 filter2 = item -> item.getNamespace().isEmpty() && (item.getRawValue() != null || showDefaultValues && item.getDefaultValue() != null);
            Function1 deleteOp = item -> null;
            FilteredPTableModel<NelePropertyItem> tableModel2 = FilteredPTableModel.PTableModelFactory.create(customModel, filter2, deleteOp, FilteredPTableModel.PTableModelFactory.getAlphabeticalSortOrder(), Collections.emptyList(), false, true, p -> true);
            AddCustomFieldAction addFieldAction = new AddCustomFieldAction(this.myModel, selection);
            DeleteCustomFieldAction deleteFieldAction = new DeleteCustomFieldAction();
            ImmutableList actions2 = ImmutableList.builder().add((Object)addFieldAction).add((Object)deleteFieldAction).build();
            InspectorLineModel title = inspector.addExpandableTitle("CustomAttributes", true, (List<? extends AnAction>)actions2);
            TableLineModel lineModel = inspector.addTable(tableModel2, true, this.myTableUIProvider, (List<? extends AnAction>)actions2, title);
            inspector.addComponent(new EmptyTablePanel(addFieldAction, lineModel), title);
            addFieldAction.setLineModel(lineModel);
            deleteFieldAction.setLineModel(lineModel);
        }

        private void addPropertyTable(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @Nullable String sectionTagName, @NotNull PropertiesModel<NelePropertyItem> model2, boolean showDefaultValues, boolean showSectionControl, boolean showConstraintPanel) {
            if (inspector == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(10);
            }
            if (selection == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(11);
            }
            if (model2 == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(12);
            }
            if (!this.shouldDisplaySection(sectionTagName, selection)) {
                return;
            }
            NelePropertyItem any = model2.getProperties().getFirst();
            Function1 filter2 = item -> !item.getNamespace().isEmpty() && (item.getRawValue() != null || showDefaultValues && item.getDefaultValue() != null);
            Function1 deleteOp = item -> {
                item.setValue(null);
                return null;
            };
            FilteredPTableModel<NelePropertyItem> tableModel2 = FilteredPTableModel.PTableModelFactory.create(model2, filter2, deleteOp, FilteredPTableModel.PTableModelFactory.getAlphabeticalSortOrder(), Collections.emptyList(), true, true, p -> true);
            SubSectionControlAction controlAction = new SubSectionControlAction(any);
            AddMotionFieldAction addFieldAction = new AddMotionFieldAction(this.myModel, model2.getProperties());
            DeleteMotionFieldAction deleteFieldAction = new DeleteMotionFieldAction();
            ImmutableList.Builder actionsBuilder = ImmutableList.builder();
            if (showSectionControl) {
                actionsBuilder.add((Object)controlAction);
            }
            actionsBuilder.add((Object)addFieldAction);
            actionsBuilder.add((Object)deleteFieldAction);
            ImmutableList actions2 = actionsBuilder.build();
            InspectorLineModel title = inspector.addExpandableTitle(sectionTagName, true, (List<? extends AnAction>)actions2);
            if (showConstraintPanel) {
                MotionInspectorBuilder.addConstraintPanel(inspector, selection, title);
            }
            TableLineModel lineModel = inspector.addTable(tableModel2, true, this.myTableUIProvider, (List<? extends AnAction>)actions2, title);
            inspector.addComponent(new EmptyTablePanel(addFieldAction, lineModel), title);
            if (showSectionControl) {
                controlAction.setLineModel(title);
            }
            addFieldAction.setLineModel(lineModel);
            deleteFieldAction.setLineModel(lineModel);
        }

        private static void addConstraintPanel(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @NotNull InspectorLineModel titleLine) {
            NlComponent component3;
            if (inspector == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(13);
            }
            if (selection == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(14);
            }
            if (titleLine == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(15);
            }
            List<NlComponent> components = (component3 = selection.getComponent()) == null ? Collections.emptyList() : Collections.singletonList(component3);
            MotionConstraintPanel panel2 = new MotionConstraintPanel(components);
            panel2.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            inspector.addComponent((JComponent)((Object)panel2), titleLine);
        }

        private boolean shouldDisplaySection(@Nullable String section, @NotNull MotionSelection selection) {
            if (selection == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(16);
            }
            if (section == null) {
                return false;
            }
            MotionSceneTag tag = selection.getMotionSceneTag();
            switch (section) {
                case "Constraint": {
                    if (selection.getType() != MotionEditorSelector.Type.CONSTRAINT) {
                        return false;
                    }
                    if (tag == null) {
                        return true;
                    }
                    Set<String> attrs = tag.getAttrList().keySet();
                    return !MotionInspectorBuilder.isSectionedConstraint(tag) || attrs.size() > 1 || !attrs.contains("id");
                }
                case "Layout": 
                case "PropertySet": 
                case "Transform": 
                case "Motion": {
                    if (selection.getType() != MotionEditorSelector.Type.CONSTRAINT) {
                        return false;
                    }
                    return tag != null && MotionInspectorBuilder.isSectionedConstraint(tag);
                }
                case "OnClick": 
                case "OnSwipe": {
                    return selection.getType() == MotionEditorSelector.Type.TRANSITION;
                }
                case "CustomAttribute": {
                    if (tag == null && selection.getType() == MotionEditorSelector.Type.CONSTRAINT) {
                        return true;
                    }
                    return tag != null && this.canHaveCustomAttributes(tag);
                }
            }
            return section.equals(selection.getMotionSceneTagName());
        }

        private static boolean isSectionedConstraint(@NotNull MotionSceneTag constraintTag) {
            if (constraintTag == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(17);
            }
            for (MTag tag : constraintTag.getChildTags()) {
                if (!CONSTRAINT_SECTIONS.contains(tag.getTagName())) continue;
                return true;
            }
            return false;
        }

        private boolean canHaveCustomAttributes(@NotNull MotionSceneTag tag) {
            XmlTag xml;
            if (tag == null) {
                MotionInspectorBuilder.$$$reportNull$$$0(18);
            }
            if ((xml = tag.getXmlTag()) == null) {
                return false;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(xml);
            if (elementDescriptor == null) {
                return false;
            }
            for (XmlElementDescriptor childDescriptor : elementDescriptor.getElementsDescriptors(xml)) {
                if (!childDescriptor.getDefaultName().equals("CustomAttribute")) continue;
                return true;
            }
            return false;
        }

        @Override
        public void resetCache() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableUIProvider";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 5: 
                case 8: 
                case 11: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titleLine";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraintTag";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionLayoutAttributesView$MotionInspectorBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "attachToInspector";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSubTagSections";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCustomAttributes";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPropertyTable";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addConstraintPanel";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldDisplaySection";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSectionedConstraint";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canHaveCustomAttributes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

