/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import android.widget.ListView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.ViewInfoUtils;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

abstract class PreferenceGroupDragHandler
extends DragHandler {
    SceneComponent myGroup;
    Map<SceneComponent, Rectangle> myPreferenceToBoundsMap;
    private SceneComponent myActivePreference;
    private int myDividerHeight;

    PreferenceGroupDragHandler(@NotNull ViewEditor editor2, @NotNull ViewGroupHandler handler, @NotNull SceneComponent group2, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        if (editor2 == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(1);
        }
        if (group2 == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(2);
        }
        if (preferences == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(4);
        }
        super(editor2, handler, group2, preferences, type);
        this.myGroup = group2;
        this.initDividerHeight();
        this.myPreferenceToBoundsMap = this.getPreferenceToBoundsMap(group2);
    }

    private void initDividerHeight() {
        ViewInfo listView = ViewInfoUtils.findViewWithName(this.editor.getRootViews(), "android.widget.ListView");
        this.myDividerHeight = listView != null ? this.editor.pxToDp(((ListView)listView.getViewObject()).getDividerHeight()) : 0;
    }

    @NotNull
    final Map<SceneComponent, Rectangle> getPreferenceToBoundsMap(@NotNull SceneComponent group2) {
        if (group2 == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(5);
        }
        Map<SceneComponent, Rectangle> map2 = group2.getChildren().stream().collect(Collectors.toMap(Function.identity(), this::getBounds));
        if (map2 == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @NotNull
    final Rectangle getBounds(@NotNull SceneComponent preference) {
        if (preference == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(7);
        }
        int height = preference.getDrawHeight() + this.myDividerHeight;
        if (preference.getNlComponent().getTagName().equals("PreferenceCategory")) {
            height += preference.getChildren().stream().mapToInt(child -> child.getDrawHeight() + this.myDividerHeight).sum();
        }
        return new Rectangle(preference.getDrawX(), preference.getDrawY(), preference.getDrawWidth(), height);
    }

    final void updateActivePreference() {
        List<SceneComponent> preferences = this.myGroup.getChildren();
        if (this.lastY < preferences.get(0).getDrawY()) {
            this.myActivePreference = preferences.get(0);
        } else {
            Optional<SceneComponent> activePreference = this.myPreferenceToBoundsMap.keySet().stream().filter(preference -> this.myPreferenceToBoundsMap.get(preference).contains(this.lastX, this.lastY)).findFirst();
            this.myActivePreference = activePreference.orElse(preferences.get(preferences.size() - 1));
        }
    }

    @Override
    public final void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(8);
        }
        this.drawDropPreviewLine(graphics);
        this.drawDropRecipientLines(graphics);
        this.drawDropZoneLines(graphics);
    }

    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(9);
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        Rectangle bounds = this.myPreferenceToBoundsMap.get(this.myActivePreference);
        if (this.lastY < PreferenceGroupDragHandler.getMidpointY(bounds)) {
            graphics.drawTopDp(bounds);
        } else {
            graphics.drawBottomDp(bounds);
        }
    }

    abstract void drawDropRecipientLines(@NotNull NlGraphics var1);

    abstract void drawDropZoneLines(@NotNull NlGraphics var1);

    final void drawDropZoneLines(@NotNull NlGraphics graphics, int startingIndex) {
        List<SceneComponent> preferences;
        if (graphics == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(10);
        }
        if ((preferences = this.myGroup.getChildren()).isEmpty()) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int midpointY = this.getMidpointY(this.myActivePreference);
        int size = preferences.size();
        for (int i2 = startingIndex; i2 < size; ++i2) {
            SceneComponent preference = preferences.get(i2);
            if (i2 != 0 && this.myActivePreference == preferences.get(i2 - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(preference.getNlComponent());
                continue;
            }
            if (this.myActivePreference == preference) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(preference.getNlComponent());
                continue;
            }
            graphics.drawTop(preference.getNlComponent());
        }
    }

    @Override
    public final void commit(int x, int y, int modifiers, @NotNull InsertType type) {
        List<SceneComponent> preferences;
        if (type == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(11);
        }
        if ((preferences = this.myGroup.getChildren()).isEmpty()) {
            this.editor.insertChildren(this.layout.getNlComponent(), this.components, -1, type);
            return;
        }
        int i2 = preferences.indexOf(this.myActivePreference);
        if (this.lastY >= this.getMidpointY(this.myActivePreference)) {
            ++i2;
        }
        this.editor.insertChildren(this.layout.getNlComponent(), this.components, i2 == preferences.size() ? -1 : i2, type);
    }

    final int getMidpointY(@NotNull SceneComponent preference) {
        if (preference == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(12);
        }
        return PreferenceGroupDragHandler.getMidpointY(this.myPreferenceToBoundsMap.get(preference));
    }

    private static int getMidpointY(@NotNull Rectangle bounds) {
        if (bounds == null) {
            PreferenceGroupDragHandler.$$$reportNull$$$0(13);
        }
        return bounds.y + bounds.height / 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferenceToBoundsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPreferenceToBoundsMap";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "drawDropPreviewLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "drawDropZoneLines";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMidpointY";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

