/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.colorextractor.Clusterer;
import java.util.ArrayList;
import java.util.List;

public class DBSCANClusterer
implements Clusterer {
    private int myVisited = 0;
    private float myEps;
    private int myMinPts;
    private List<List<double[]>> myClusters = new ArrayList<List<double[]>>();
    private PointType[] myPointTypes;
    Clusterer.ProgressListener listener;

    public DBSCANClusterer(float eps, int minPts) {
        this.myEps = eps;
        this.myMinPts = minPts;
    }

    public DBSCANClusterer(float eps, int minPts, Clusterer.ProgressListener listener2) {
        this(eps, minPts);
        this.listener = listener2;
    }

    @Override
    public List<List<double[]>> cluster(double[][] input) {
        ArrayList<Object> cluster = new ArrayList<double[]>();
        this.myPointTypes = new PointType[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (this.myPointTypes[i2] != null || !this.expandCluster(input, i2, cluster)) continue;
            if (!cluster.isEmpty()) {
                this.myClusters.add(cluster);
                this.myVisited += cluster.size();
                this.notifyProgress();
            }
            cluster = new ArrayList();
        }
        return this.myClusters;
    }

    private boolean expandCluster(double[][] input, int pointIndex, List<double[]> cluster) {
        List<Integer> seeds = this.regionQuery(input, pointIndex);
        if (seeds.size() < this.myMinPts) {
            this.myPointTypes[pointIndex] = PointType.NOISE;
            for (int i2 = 0; i2 < seeds.size(); ++i2) {
                this.myPointTypes[seeds.get((int)i2).intValue()] = PointType.NOISE;
            }
            return false;
        }
        cluster.add(input[pointIndex]);
        this.myPointTypes[pointIndex] = PointType.CORE;
        for (int i3 = 0; i3 < seeds.size(); ++i3) {
            cluster.add(input[seeds.get(i3)]);
            this.myPointTypes[seeds.get((int)i3).intValue()] = PointType.BORDER;
        }
        while (!seeds.isEmpty()) {
            int currentP = seeds.get(0);
            List<Integer> result2 = this.regionQuery(input, currentP);
            if (result2.size() >= this.myMinPts) {
                this.myPointTypes[currentP] = PointType.CORE;
                for (int i4 = 0; i4 < result2.size(); ++i4) {
                    Integer resultP = result2.get(i4);
                    if (this.myPointTypes[resultP] != null && this.myPointTypes[resultP] != PointType.NOISE) continue;
                    if (this.myPointTypes[resultP] == null) {
                        seeds.add(resultP);
                    }
                    this.myPointTypes[resultP.intValue()] = PointType.BORDER;
                    cluster.add(input[resultP]);
                }
            }
            seeds.remove(0);
        }
        return true;
    }

    private void notifyProgress() {
        if (this.listener != null) {
            this.listener.progress((float)this.myVisited / (float)this.myPointTypes.length);
        }
    }

    private List<Integer> regionQuery(double[][] input, int pointIndex) {
        ArrayList<Integer> seeds = new ArrayList<Integer>();
        double[] current = input[pointIndex];
        for (int i2 = 0; i2 < input.length; ++i2) {
            float epsSquare = this.myEps * this.myEps;
            if (input[i2] == current || !(DBSCANClusterer.distance(input[i2], current) <= (double)epsSquare)) continue;
            seeds.add(i2);
        }
        return seeds;
    }

    private static double distance(double[] neighbor, double[] point) {
        double squares = 0.0;
        for (int i2 = 0; i2 < Math.min(neighbor.length, point.length); ++i2) {
            squares += Math.pow(neighbor[i2] - point[i2], 2.0);
        }
        return squares;
    }

    private static enum PointType {
        NOISE,
        BORDER,
        CORE;

    }
}

