/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.Clusterer;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ImageUtils;
import com.android.tools.pixelprobe.color.Colors;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DoublesColorExtractor
extends ColorExtractor {
    protected static final int MAX_IMAGE_SIZE = 300;
    protected static final int PARSE_INCREMENT = 7;
    protected static final int POINT_DIMENSION = 3;

    protected DoublesColorExtractor(Mockup mockup) {
        super(mockup);
    }

    protected DoublesColorExtractor(@NotNull BufferedImage image) {
        if (image == null) {
            DoublesColorExtractor.$$$reportNull$$$0(0);
        }
        super(image);
    }

    @Override
    public void run(ColorExtractor.ColorExtractorCallback callback2) {
        if (callback2 == null) {
            return;
        }
        this.myCallback = callback2;
        BackgroundExtractTask task2 = new BackgroundExtractTask();
        task2.addPropertyChangeListener(evt -> {
            if ("progress".equals(evt.getPropertyName())) {
                this.myCallback.progress((Integer)evt.getNewValue());
            }
        });
        task2.execute();
    }

    @NotNull
    @VisibleForTesting
    static List<double[]> getLABPixels(BufferedImage image, HashMap<Integer, Integer> labToRgb, HashMap<Integer, double[]> rgbToLab, @Nullable List<Integer> treatedPixel) {
        float[] tempLAB = new float[3];
        ArrayList<double[]> clusterInput = new ArrayList<double[]>();
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        for (int i2 = 0; i2 < pixels.length; i2 += 7) {
            if (treatedPixel != null) {
                treatedPixel.add(i2);
            }
            int rgb = pixels[i2];
            new Color(rgb).getColorComponents(Colors.getLabColorSpace(), tempLAB);
            double[] LABDoubles = new double[]{tempLAB[0], tempLAB[1], tempLAB[2]};
            labToRgb.put(Arrays.hashCode(LABDoubles), rgb);
            rgbToLab.put(rgb, LABDoubles);
            clusterInput.add(LABDoubles);
        }
        ArrayList<double[]> arrayList = clusterInput;
        if (arrayList == null) {
            DoublesColorExtractor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    abstract List<ExtractedColor> runClustering(HashMap<Integer, Integer> var1, List<double[]> var2, Clusterer.ProgressListener var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/colorextractor/DoublesColorExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/colorextractor/DoublesColorExtractor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLABPixels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class BackgroundExtractTask
    extends SwingWorker<Collection<ExtractedColor>, Object> {
        protected BackgroundExtractTask() {
        }

        @Override
        protected Collection<ExtractedColor> doInBackground() throws Exception {
            if (DoublesColorExtractor.this.myImage == null) {
                return Collections.emptyList();
            }
            return this.extractColors();
        }

        @NotNull
        private Collection<ExtractedColor> extractColors() {
            BufferedImage image = ImageUtils.createScaledImage(DoublesColorExtractor.this.myImage, 300);
            HashMap<Integer, Integer> labToRgb = new HashMap<Integer, Integer>();
            HashMap<Integer, double[]> rgbToLab = new HashMap<Integer, double[]>();
            List<double[]> clusterInput = DoublesColorExtractor.getLABPixels(image, labToRgb, rgbToLab, null);
            List<ExtractedColor> extractedColors = DoublesColorExtractor.this.runClustering(labToRgb, clusterInput, this::publishProgress);
            this.publishProgress(1.0f);
            List<ExtractedColor> list = extractedColors;
            if (list == null) {
                BackgroundExtractTask.$$$reportNull$$$0(0);
            }
            return list;
        }

        protected void publishProgress(float progress) {
            this.setProgress(Math.max(0, Math.min(100, Math.round(progress * 100.0f))));
        }

        @Override
        protected void done() {
            try {
                DoublesColorExtractor.this.myCallback.result((Collection)this.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/colorextractor/DoublesColorExtractor$BackgroundExtractTask", "extractColors"));
        }
    }
}

