/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class Insets {
    public static final Insets NONE = new Insets(0, 0, 0, 0);
    public final int left;
    public final int top;
    public final int right;
    public final int bottom;

    public Insets(int left2, int top, int right2, int bottom2) {
        this.left = left2;
        this.right = right2;
        this.top = top;
        this.bottom = bottom2;
    }

    public boolean isEmpty() {
        return this == NONE || this.left == 0 && this.top == 0 && this.right == 0 && this.bottom == 0;
    }

    public boolean subtractFrom(Rectangle bounds) {
        if (this.isEmpty()) {
            return false;
        }
        bounds.x -= this.left;
        bounds.width += this.left;
        bounds.y -= this.top;
        bounds.height += this.top;
        bounds.width += this.right;
        bounds.height += this.bottom;
        return true;
    }

    public boolean addTo(Rectangle bounds) {
        if (this.isEmpty()) {
            return false;
        }
        bounds.x += this.left;
        bounds.width -= this.left;
        bounds.y += this.top;
        bounds.height -= this.top;
        bounds.width -= this.right;
        bounds.height -= this.bottom;
        return true;
    }

    public int width() {
        return this.left + this.right;
    }

    public int height() {
        return this.top + this.bottom;
    }

    @NotNull
    public String toString() {
        String string = "Margins [left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + "]";
        if (string == null) {
            Insets.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Insets insets = (Insets)o;
        if (this.bottom != insets.bottom) {
            return false;
        }
        if (this.left != insets.left) {
            return false;
        }
        if (this.right != insets.right) {
            return false;
        }
        return this.top == insets.top;
    }

    public int hashCode() {
        int result2 = this.left;
        result2 = 31 * result2 + this.top;
        result2 = 31 * result2 + this.right;
        result2 = 31 * result2 + this.bottom;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/Insets", "toString"));
    }
}

