/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.ide.PooledThreadExecutor;

public class DependencyManager
implements Disposable {
    private final Project myProject;
    private final List<DependencyChangeListener> myListeners;
    private final AtomicReference<Set<String>> myMissingLibraries;
    private final AtomicBoolean myUseAndroidXDependencies;
    private final Object mySync;
    @GuardedBy(value="mySync")
    private Module myModule;
    @GuardedBy(value="mySync")
    private Palette myPalette;
    private boolean myRegisteredForDependencyUpdates;
    private boolean myNotifyAlways;
    private Consumer<Future<?>> mySyncTopicConsumer;

    public DependencyManager(@NotNull Project project) {
        if (project == null) {
            DependencyManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myMissingLibraries = new AtomicReference(Collections.emptySet());
        this.myUseAndroidXDependencies = new AtomicBoolean(false);
        this.myListeners = new ArrayList<DependencyChangeListener>(2);
        this.myPalette = Palette.EMPTY;
        this.mySyncTopicConsumer = future2 -> {};
        this.mySync = new Object();
    }

    public void addDependencyChangeListener(@NotNull DependencyChangeListener listener2) {
        if (listener2 == null) {
            DependencyManager.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPalette(@NotNull Palette palette, @NotNull Module module) {
        if (palette == null) {
            DependencyManager.$$$reportNull$$$0(2);
        }
        if (module == null) {
            DependencyManager.$$$reportNull$$$0(3);
        }
        Object object = this.mySync;
        synchronized (object) {
            this.myPalette = palette;
            this.myModule = module;
        }
        this.checkForRelevantDependencyChanges();
        this.registerDependencyUpdates();
        ApplicationManager.getApplication().invokeLater(() -> this.myListeners.forEach(listener2 -> listener2.onDependenciesChanged()));
    }

    public boolean useAndroidXDependencies() {
        return this.myUseAndroidXDependencies.get();
    }

    public boolean needsLibraryLoad(@NotNull Palette.Item item) {
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(4);
        }
        return this.myMissingLibraries.get().contains(item.getGradleCoordinateId());
    }

    @TestOnly
    public void setSyncTopicListener(@NotNull Consumer<Future<?>> listener2) {
        if (listener2 == null) {
            DependencyManager.$$$reportNull$$$0(5);
        }
        this.mySyncTopicConsumer = listener2;
    }

    @TestOnly
    public void setNotifyAlways(boolean notifyAlways) {
        this.myNotifyAlways = notifyAlways;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForRelevantDependencyChanges() {
        Object object = this.mySync;
        synchronized (object) {
            return this.checkForNewMissingDependencies() | this.checkForNewAndroidXDependencies();
        }
    }

    private boolean checkForNewAndroidXDependencies() {
        boolean useAndroidX = this.computeUseAndroidXDependencies();
        if (useAndroidX == this.myUseAndroidXDependencies.get()) {
            return false;
        }
        this.myUseAndroidXDependencies.set(useAndroidX);
        return true;
    }

    private boolean checkForNewMissingDependencies() {
        Set missing = Collections.emptySet();
        if (this.myModule != null && !this.myModule.isDisposed() && !this.myProject.isDisposed()) {
            AndroidModuleSystem moduleSystem = ProjectSystemService.getInstance(this.myProject).getProjectSystem().getModuleSystem(this.myModule);
            missing = (Set)this.myPalette.getGradleCoordinateIds().stream().map(id -> GradleCoordinate.parseCoordinateString((String)(id + ":+"))).filter(Objects::nonNull).filter(coordinate -> moduleSystem.getRegisteredDependency((GradleCoordinate)coordinate) == null).map(coordinate -> coordinate.getId()).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            if (this.myMissingLibraries.get().equals(missing)) {
                return false;
            }
        }
        this.myMissingLibraries.set(missing);
        return true;
    }

    private void registerDependencyUpdates() {
        if (this.myRegisteredForDependencyUpdates || this.myProject.isDisposed()) {
            return;
        }
        this.myRegisteredForDependencyUpdates = true;
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> this.mySyncTopicConsumer.accept(this.ensureRunningOnBackgroundThread(() -> {
            if (result2 == ProjectSystemSyncManager.SyncResult.SUCCESS && this.checkForRelevantDependencyChanges() || this.myNotifyAlways) {
                ApplicationManager.getApplication().invokeLater(() -> this.myListeners.forEach(listener2 -> listener2.onDependenciesChanged()));
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureLibraryIsIncluded(@NotNull Palette.Item item) {
        GradleCoordinate coordinate;
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(6);
        }
        if (this.needsLibraryLoad(item) && (coordinate = GradleCoordinate.parseCoordinateString((String)(item.getGradleCoordinateId() + ":+"))) != null) {
            Object object = this.mySync;
            synchronized (object) {
                DependencyManagementUtil.addDependencies(this.myModule, Collections.singletonList(coordinate), true);
            }
        }
    }

    private boolean computeUseAndroidXDependencies() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (MigrateToAndroidxUtil.hasAndroidxProperty(this.myProject)) {
            return MigrateToAndroidxUtil.isAndroidx(this.myProject);
        }
        if (this.myModule == null || this.myModule.isDisposed()) {
            return false;
        }
        if (DependencyManagementUtil.dependsOnAndroidx(this.myModule)) {
            return true;
        }
        return !DependencyManagementUtil.dependsOnOldSupportLib(this.myModule);
    }

    private Future<?> ensureRunningOnBackgroundThread(@NotNull Runnable runnable2) {
        Application application;
        if (runnable2 == null) {
            DependencyManager.$$$reportNull$$$0(7);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            CompletableFuture<Void> future2 = CompletableFuture.runAsync(runnable2, PooledThreadExecutor.INSTANCE);
            Disposable taskCanceller = () -> future2.cancel(true);
            Disposer.register((Disposable)this, (Disposable)taskCanceller);
            return future2.whenComplete((r, e) -> Disposer.dispose((Disposable)taskCanceller));
        }
        runnable2.run();
        return Futures.immediateFuture(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/palette/DependencyManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependencyChangeListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setPalette";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "needsLibraryLoad";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setSyncTopicListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureLibraryIsIncluded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureRunningOnBackgroundThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DependencyChangeListener {
        public void onDependenciesChanged();
    }
}

