/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.lint.checks.ApiLookup;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    public static final String STARRED_PROP = "ANDROID.STARRED_PROPERTIES";
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull AndroidFacet facet2, @Nullable PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (facet2 == null) {
            NlProperties.$$$reportNull$$$0(0);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(1);
        }
        assert (!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        if (components.isEmpty()) {
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(2);
            }
            return immutableTable;
        }
        Project project = facet2.getModule().getProject();
        Table table2 = (Table)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.getPropertiesImpl(facet2, propertiesManager, components));
        if (table2 == null) {
            NlProperties.$$$reportNull$$$0(3);
        }
        return table2;
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesImpl(@NotNull AndroidFacet facet2, @Nullable PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (facet2 == null) {
            NlProperties.$$$reportNull$$$0(4);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(5);
        }
        assert (!components.isEmpty());
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet2);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet2.getModule().getName());
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(6);
            }
            return immutableTable;
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        Project project = facet2.getModule().getProject();
        ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
        int minApi = AndroidModuleInfo.getInstance(facet2).getMinSdkVersion().getFeatureLevel();
        for (NlComponent component3 : components) {
            String className;
            XmlTag tag = component3.getTagDeprecated();
            if (!tag.isValid()) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(7);
                }
                return immutableTable;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(8);
                }
                return immutableTable;
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                AttributeDefinition attrDef;
                XmlName name = NlProperties.getXmlName(desc, tag);
                if ("http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) && apiLookup != null && apiLookup.getFieldVersion("android/R$attr", name.getLocalName()) > minApi) continue;
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attributeDefinition = attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(name.getLocalName());
                if (!NlPropertyItem.isDefinitionAcceptable(name, attrDef)) continue;
                NlPropertyItem property2 = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property2.getName(), (Object)property2);
            }
            PsiElement declaration = elementDescriptor.getDeclaration();
            PsiClass tagClass = declaration instanceof PsiClass ? (PsiClass)declaration : null;
            String string = className = tagClass != null ? tagClass.getQualifiedName() : null;
            if (NlComponentHelperKt.getHasNlComponentInfo(component3)) {
                String viewClassName;
                ViewInfo view = NlComponentHelperKt.getViewInfo(component3);
                String string2 = viewClassName = view != null ? view.getClassName() : null;
                if (localAttrDefs != null && viewClassName != null && className != null && !viewClassName.equals(className)) {
                    NlProperties.addAttributesFromInflatedStyleable((Table<String, String, NlPropertyItem>)properties, localAttrDefs, tagClass, viewClassName, propertiesManager, components);
                }
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    AttributeDefinition definition;
                    XmlName popup2 = new XmlName("popupBackground", "http://schemas.android.com/apk/res/android");
                    AttributeDefinition attributeDefinition = definition = systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null;
                    if (!NlPropertyItem.isDefinitionAcceptable(popup2, definition)) break;
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(popup2, definition, components, propertiesManager));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.initStarState(combinedProperties);
        Table<String, String, NlPropertyItem> table2 = combinedProperties;
        if (table2 == null) {
            NlProperties.$$$reportNull$$$0(9);
        }
        return table2;
    }

    private static void addAttributesFromInflatedStyleable(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AttributeDefinitions localAttrDefs, @NotNull PsiClass xmlClass, @NotNull String inflatedClassName, @NotNull PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(10);
        }
        if (localAttrDefs == null) {
            NlProperties.$$$reportNull$$$0(11);
        }
        if (xmlClass == null) {
            NlProperties.$$$reportNull$$$0(12);
        }
        if (inflatedClassName == null) {
            NlProperties.$$$reportNull$$$0(13);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(14);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(15);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)xmlClass.getProject());
        for (PsiClass inflatedClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)inflatedClassName); inflatedClass != null && inflatedClass != xmlClass; inflatedClass = inflatedClass.getSuperClass()) {
            StyleableDefinition styleable;
            String styleableName = inflatedClass.getName();
            StyleableDefinition styleableDefinition = styleable = styleableName != null ? localAttrDefs.getStyleableByName(styleableName) : null;
            if (styleable == null) continue;
            for (AttributeDefinition attrDef : styleable.getAttributes()) {
                if (properties.contains((Object)"http://schemas.android.com/apk/res/android", (Object)attrDef.getName())) continue;
                XmlName name = NlProperties.getXmlName(attrDef.getName(), "http://schemas.android.com/apk/res-auto");
                NlPropertyItem property2 = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property2.getName(), (Object)property2);
            }
        }
    }

    private static void initStarState(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(16);
        }
        for (String starredProperty : NlProperties.getStarredProperties()) {
            Pair<String, String> property2 = NlProperties.split(starredProperty);
            NlPropertyItem item = (NlPropertyItem)properties.get(property2.getFirst(), property2.getSecond());
            if (item == null) continue;
            item.setInitialStarred();
        }
    }

    public static void saveStarState(@Nullable String propertyNamespace, @NotNull String propertyName, boolean starred, @Nullable PropertiesManager propertiesManager) {
        String removed;
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(17);
        }
        String propertyNameWithPrefix = NlProperties.getPropertyNameWithPrefix(propertyNamespace, propertyName);
        ArrayList<String> favorites = new ArrayList<String>();
        for (String starredProperty : NlProperties.getStarredProperties()) {
            if (starredProperty.equals(propertyNameWithPrefix)) continue;
            favorites.add(starredProperty);
        }
        if (starred) {
            favorites.add(propertyNameWithPrefix);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(STARRED_PROP, Joiner.on((char)';').join(favorites));
        String added = starred ? propertyNameWithPrefix : "";
        String string = removed = !starred ? propertyNameWithPrefix : "";
        if (propertiesManager != null) {
            propertiesManager.logFavoritesChange(added, removed, favorites);
        }
    }

    public static String getStarredPropertiesAsString() {
        String starredProperties = PropertiesComponent.getInstance().getValue(STARRED_PROP);
        if (starredProperties == null) {
            starredProperties = "visibility";
        }
        return starredProperties;
    }

    public static Iterable<String> getStarredProperties() {
        return Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)NlProperties.getStarredPropertiesAsString());
    }

    @NotNull
    private static String getPropertyNameWithPrefix(@Nullable String namespace, @NotNull String propertyName) {
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(18);
        }
        if (namespace == null) {
            String string = propertyName;
            if (string == null) {
                NlProperties.$$$reportNull$$$0(19);
            }
            return string;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                String string = "tools:" + propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(20);
                }
                return string;
            }
            case "http://schemas.android.com/apk/res/android": {
                String string = propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(21);
                }
                return string;
            }
        }
        String string = "app:" + propertyName;
        if (string == null) {
            NlProperties.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> split(@NotNull String propertyNameWithPrefix) {
        if (propertyNameWithPrefix == null) {
            NlProperties.$$$reportNull$$$0(23);
        }
        if (propertyNameWithPrefix.startsWith("tools:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/tools", (Object)propertyNameWithPrefix.substring("tools:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(24);
            }
            return pair;
        }
        if (propertyNameWithPrefix.startsWith("app:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyNameWithPrefix.substring("app:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(25);
            }
            return pair;
        }
        Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)propertyNameWithPrefix);
        if (pair == null) {
            NlProperties.$$$reportNull$$$0(26);
        }
        return pair;
    }

    @NotNull
    private static XmlName getXmlName(@NotNull XmlAttributeDescriptor descriptor2, @NotNull XmlTag context) {
        if (descriptor2 == null) {
            NlProperties.$$$reportNull$$$0(27);
        }
        if (context == null) {
            NlProperties.$$$reportNull$$$0(28);
        }
        String namespace = null;
        if (descriptor2 instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor2).getNamespace(context);
        }
        return new XmlName(descriptor2.getName(), namespace);
    }

    @NotNull
    private static XmlName getXmlName(@NotNull String qualifiedName, @NotNull String defaultNamespace2) {
        if (qualifiedName == null) {
            NlProperties.$$$reportNull$$$0(29);
        }
        if (defaultNamespace2 == null) {
            NlProperties.$$$reportNull$$$0(30);
        }
        if (qualifiedName.startsWith("android:")) {
            return new XmlName(StringUtil.trimStart((String)qualifiedName, (String)"android:"), "http://schemas.android.com/apk/res/android");
        }
        return new XmlName(qualifiedName, defaultNamespace2);
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(31);
        }
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add((String)entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(32);
        }
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 10: 
            case 16: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAttrDefs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inflatedClassName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNameWithPrefix";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesImpl";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameWithPrefix";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAttributesFromInflatedStyleable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initStarState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveStarState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameWithPrefix";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getXmlName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setUpDesignProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

