/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class CanvasResizeLayer
extends Layer {
    private final NlDesignSurface myDesignSurface;
    private final ScreenView myScreenView;
    private boolean myIsHovering;

    public CanvasResizeLayer(@NotNull NlDesignSurface designSurface, @NotNull ScreenView screenView) {
        if (designSurface == null) {
            CanvasResizeLayer.$$$reportNull$$$0(0);
        }
        if (screenView == null) {
            CanvasResizeLayer.$$$reportNull$$$0(1);
        }
        this.myDesignSurface = designSurface;
        this.myScreenView = screenView;
    }

    @Override
    public void onHover(int x, int y) {
        boolean oldHovering = this.myIsHovering;
        Dimension size = this.myScreenView.getSize();
        Rectangle resizeZone = new Rectangle(this.myScreenView.getX() + size.width, this.myScreenView.getY() + size.height, 48, 48);
        this.myIsHovering = resizeZone.contains(x, y);
        if (this.myIsHovering != oldHovering) {
            this.myDesignSurface.repaint();
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g2d) {
        if (g2d == null) {
            CanvasResizeLayer.$$$reportNull$$$0(2);
        }
        Dimension size = this.myScreenView.getSize();
        int x = this.myScreenView.getX();
        int y = this.myScreenView.getY();
        Graphics2D graphics = (Graphics2D)g2d.create();
        graphics.setStroke(NlConstants.SOLID_STROKE);
        graphics.setColor(this.myIsHovering ? NlConstants.RESIZING_CORNER_COLOR : NlConstants.RESIZING_CUE_COLOR);
        graphics.drawLine(x + size.width + 20, y + size.height + 4, x + size.width + 4, y + size.height + 20);
        graphics.drawLine(x + size.width + 20, y + size.height + 12, x + size.width + 12, y + size.height + 20);
        graphics.dispose();
    }

    @Override
    public boolean isVisible() {
        return this.myScreenView.getScene().isResizeAvailable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/CanvasResizeLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

