/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.Archive;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.updater.SdkComponentSource;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.HtmlBuilder;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class UpdateInfoDialog
extends AbstractUpdateDialog {
    private static final String RELEASE_NOTES_URL = "https://developer.android.com/tools/revisions/index.html";
    private final List<RemotePackage> myPackages;
    private final JComponent myComponent;

    protected UpdateInfoDialog(boolean enableLink, List<RemotePackage> packages) {
        super(enableLink);
        this.myPackages = packages;
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
        this.myComponent = new UpdateInfoPanel(this.myPackages).getRootPanel();
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions2 = new ArrayList<Action>();
        actions2.add(new AbstractAction("Update Now"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> paths = new ArrayList<String>();
                for (RemotePackage p : UpdateInfoDialog.this.myPackages) {
                    paths.add(p.getPath());
                }
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(UpdateInfoDialog.this.myComponent, paths, true);
                if (dialog2 != null) {
                    dialog2.show();
                }
                UpdateInfoDialog.this.close(0);
            }
        });
        actions2.add(new AbstractAction("Release Notes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)UpdateInfoDialog.RELEASE_NOTES_URL);
            }
        });
        actions2.add(new AbstractAction(IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                List ignores = UpdateSettings.getInstance().getIgnoredBuildNumbers();
                for (RemotePackage p : UpdateInfoDialog.this.myPackages) {
                    ignores.add(SdkComponentSource.getPackageRevisionId((RepoPackage)p));
                }
                UpdateInfoDialog.this.doCancelAction();
            }
        });
        actions2.add(this.getCancelAction());
        Action[] actionArray = actions2.toArray(new Action[actions2.size()]);
        if (actionArray == null) {
            UpdateInfoDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected String getCancelButtonText() {
        return IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/UpdateInfoDialog", "createActions"));
    }

    private class UpdateInfoPanel {
        private JPanel myRootPanel;
        private JBLabel myPackages;
        private JBLabel myDownloadSize;
        private JEditorPane mySettingsLink;
        private JBScrollPane myScrollPane;

        public UpdateInfoPanel(List<RemotePackage> packages) {
            this.$$$setupUI$$$();
            UpdateInfoDialog.this.configureMessageArea(this.mySettingsLink);
            this.myDownloadSize.setText(WelcomeUiUtils.getSizeLabel(this.computeDownloadSize(packages)));
            AndroidVersion noVersion = new AndroidVersion(-1, null);
            Map versionedPackages = packages.stream().collect(Collectors.groupingBy(pkg -> pkg.getTypeDetails() instanceof DetailsTypes.ApiDetailsType ? ((DetailsTypes.ApiDetailsType)pkg.getTypeDetails()).getAndroidVersion() : noVersion, TreeMap::new, Collectors.toCollection(TreeSet::new)));
            HtmlBuilder packageHtmlBuilder = new HtmlBuilder();
            packageHtmlBuilder.openHtmlBody();
            if (versionedPackages.containsKey(noVersion)) {
                for (RemotePackage p : versionedPackages.getOrDefault(noVersion, Collections.emptySet())) {
                    packageHtmlBuilder.addNbsps(4).add(p.getDisplayName() + " revision " + p.getVersion()).newline();
                }
                versionedPackages.remove(noVersion);
            }
            boolean first = true;
            for (AndroidVersion version2 : versionedPackages.keySet()) {
                if (!first) {
                    packageHtmlBuilder.newline();
                } else {
                    first = false;
                }
                packageHtmlBuilder.addNbsps(4).addBold(SdkVersionInfo.getVersionWithCodename((AndroidVersion)version2) + ":").newline();
                for (RemotePackage p : (Set)versionedPackages.get(version2)) {
                    packageHtmlBuilder.addNbsps(8).add(p.getDisplayName() + " revision " + p.getVersion()).newline();
                }
            }
            packageHtmlBuilder.closeHtmlBody();
            this.myPackages.setText(packageHtmlBuilder.getHtml());
            this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        }

        public JPanel getRootPanel() {
            return this.myRootPanel;
        }

        private long computeDownloadSize(List<RemotePackage> packages) {
            long size = 0L;
            for (RemotePackage pkg : packages) {
                Archive arch = pkg.getArchive();
                if (arch == null) continue;
                size += arch.getComplete().getSize();
            }
            return size;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBLabel jBLabel;
            JBScrollPane jBScrollPane;
            JEditorPane jEditorPane;
            JBLabel jBLabel2;
            JPanel jPanel;
            this.myRootPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBLabel jBLabel3 = new JBLabel();
            jBLabel3.setText("<html>Updates are available for the Android SDK and Tools<br><br>Android SDK updates ensure you have the latest features and enhancements.<br>Android Studio will update the following components:</html>");
            jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            JBLabel jBLabel4 = new JBLabel();
            jBLabel4.setText("Download Size:");
            jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myDownloadSize = jBLabel2 = new JBLabel();
            jPanel.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.mySettingsLink = jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jPanel.add((Component)jEditorPane, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 3, null, null, null));
            this.myScrollPane = jBScrollPane = new JBScrollPane();
            jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
            jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0), null, 0, 0, null, null));
            this.myPackages = jBLabel = new JBLabel();
            jBScrollPane.setViewportView((Component)jBLabel);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRootPanel;
        }
    }
}

