/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Downloader;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SimpleRepositorySource;
import com.android.repository.impl.sources.LocalSourceProvider;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.AndroidAuthenticator;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.updater.configure.EditSourceDialog;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.icons.AllIcons;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SourcesTableModel
extends ListTableModel<Row>
implements EditableModel {
    private Set<RepositorySource> myInitialItems;
    private Runnable myRefreshCallback;
    private Runnable myLoadingStartedCallback;
    private Runnable myLoadingFinishedCallback;
    private static final com.android.repository.api.ProgressIndicator myLogger = new StudioLoggerProgressIndicator(SourcesTableModel.class);
    private SdkUpdaterConfigurable myConfigurable;
    private final ModalityState myModalityState;

    SourcesTableModel(@NotNull Runnable startLoading2, @NotNull Runnable finishLoading, @NotNull ModalityState modalityState) {
        if (startLoading2 == null) {
            SourcesTableModel.$$$reportNull$$$0(0);
        }
        if (finishLoading == null) {
            SourcesTableModel.$$$reportNull$$$0(1);
        }
        if (modalityState == null) {
            SourcesTableModel.$$$reportNull$$$0(2);
        }
        super(new ColumnInfo[0]);
        this.myModalityState = modalityState;
        this.setColumnInfos(new ColumnInfo[]{new ColumnInfo<Row, Boolean>("Enabled"){

            @Nullable
            public Boolean valueOf(Row row) {
                return row.mySource.isEnabled();
            }

            public int getWidth(JTable table2) {
                return 60;
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public boolean isCellEditable(Row row) {
                return SourcesTableModel.this.isEditable(SourcesTableModel.this.indexOf(row)) && Strings.isNullOrEmpty((String)row.mySource.getFetchError());
            }

            public void setValue(Row row, Boolean value2) {
                row.mySource.setEnabled(value2.booleanValue());
                SourcesTableModel.this.myRefreshCallback.run();
            }

            @Nullable
            public TableCellRenderer getRenderer(final Row row) {
                String error = row.mySource.getFetchError();
                if (!Strings.isNullOrEmpty((String)error)) {
                    return new IconTableCellRenderer<Boolean>(){

                        @Nullable
                        protected Icon getIcon(@NotNull Boolean value2, JTable table2, int row2) {
                            if (value2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return AllIcons.General.Error;
                        }

                        public String getText() {
                            return null;
                        }

                        public String getToolTipText() {
                            return row.mySource.getFetchError();
                        }

                        public int getHorizontalAlignment() {
                            return 0;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/updater/configure/SourcesTableModel$1$1", "getIcon"));
                        }
                    };
                }
                return super.getRenderer((Object)row);
            }
        }, new ColumnInfo<Row, String>("Name"){

            @Nullable
            public String valueOf(Row r) {
                return r.mySource.getDisplayName();
            }
        }, new ColumnInfo<Row, String>("URL"){

            @Nullable
            public String valueOf(Row r) {
                return r.mySource.getUrl();
            }
        }});
        this.setLoadingFinishedCallback(finishLoading);
        this.myLoadingStartedCallback = startLoading2;
    }

    public void setAllEnabled(boolean enabled) {
        for (Row r : this.getItems()) {
            r.mySource.setEnabled(enabled);
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        this.myRefreshCallback.run();
    }

    public void setConfigurable(SdkUpdaterConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    private void refreshUi(boolean force) {
        this.myLoadingStartedCallback.run();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            ArrayList<Row> items2 = new ArrayList<Row>();
            HashSet<RepositorySource> initial = new HashSet<RepositorySource>();
            for (RepositorySource source : this.myConfigurable.getRepoManager().getSources((Downloader)new StudioDownloader(), myLogger, force)) {
                items2.add(new Row(source));
                initial.add(source);
            }
            Collections.sort(items2);
            application.invokeAndWait(() -> {
                if (this.myInitialItems == null) {
                    this.myInitialItems = initial;
                }
                this.setItems(items2);
                this.myLoadingFinishedCallback.run();
                if (force) {
                    this.myRefreshCallback.run();
                }
            }, this.myModalityState);
        });
    }

    public void editRow(int index) {
        Row r = (Row)this.getRowValue(index);
        EditSourceDialog input = this.showEditDialog(r.mySource);
        if (input.isOK()) {
            this.removeRow(index);
            this.createSource(input.getUrl(), input.getUiName(), input.getCredentials());
        }
    }

    public void addRow() {
        EditSourceDialog input = this.showEditDialog(null);
        if (input.isOK()) {
            this.createSource(input.getUrl(), input.getUiName(), input.getCredentials());
        }
    }

    @NotNull
    private EditSourceDialog showEditDialog(@Nullable RepositorySource source) {
        RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
        assert (userSourceProvider != null);
        EditSourceDialog input = new EditSourceDialog(userSourceProvider, source);
        input.show();
        EditSourceDialog editSourceDialog = input;
        if (editSourceDialog == null) {
            SourcesTableModel.$$$reportNull$$$0(3);
        }
        return editSourceDialog;
    }

    @VisibleForTesting
    void createSource(@NotNull String url, @Nullable String uiName, @Nullable Credentials credentials) {
        if (url == null) {
            SourcesTableModel.$$$reportNull$$$0(4);
        }
        RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
        assert (userSourceProvider != null);
        SimpleRepositorySource newSource = new SimpleRepositorySource(url, uiName, true, (Collection)ImmutableList.of((Object)AndroidSdkHandler.getAddonModule(), (Object)AndroidSdkHandler.getSysImgModule(), (Object)RepoManager.getCommonModule()), userSourceProvider);
        userSourceProvider.addSource((RepositorySource)newSource);
        PasswordSafe.getInstance().set(new CredentialAttributes(AndroidAuthenticator.getCredentialServiceName(url)), credentials);
        try {
            PasswordSafe.getInstance().set(new CredentialAttributes(AndroidAuthenticator.getCredentialServiceName(new URL(url).getHost())), credentials);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        this.refreshUi(false);
    }

    public void removeRow(int idx) {
        RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
        assert (userSourceProvider != null);
        userSourceProvider.removeSource(((Row)this.getRowValue((int)idx)).mySource);
        this.refreshUi(false);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public boolean isEditable(int row) {
        return this.isEditable() && ((Row)this.getRowValue((int)row)).mySource.getProvider().isModifiable();
    }

    public boolean hasEditableRows() {
        int rowCount2 = this.getRowCount();
        for (int i2 = 0; i2 < rowCount2; ++i2) {
            if (!this.isEditable(i2)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        if (!this.isSourcesModified()) {
            if (this.myInitialItems == null) {
                this.refreshUi(false);
            }
            return;
        }
        this.myInitialItems = null;
        this.refreshUi(true);
    }

    public boolean isSourcesModified() {
        if (this.myInitialItems == null) {
            return false;
        }
        if (this.getItems().size() != this.myInitialItems.size()) {
            return true;
        }
        for (Row row : this.getItems()) {
            if (row.isModified()) {
                return true;
            }
            if (this.myInitialItems.contains(row.mySource)) continue;
            return true;
        }
        return false;
    }

    public void save(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            SourcesTableModel.$$$reportNull$$$0(5);
        }
        if (this.isSourcesModified()) {
            RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
            assert (userSourceProvider != null);
            userSourceProvider.save((com.android.repository.api.ProgressIndicator)new RepoProgressIndicatorAdapter(progress));
            this.reset();
        }
    }

    @Nullable
    private RepositorySourceProvider getUserSourceProvider() {
        return this.myConfigurable == null ? null : this.myConfigurable.getSdkHandler().getUserSourceProvider(myLogger);
    }

    public void setRefreshCallback(@NotNull Runnable refreshCallback) {
        if (refreshCallback == null) {
            SourcesTableModel.$$$reportNull$$$0(6);
        }
        this.myRefreshCallback = refreshCallback;
    }

    @VisibleForTesting
    void setLoadingFinishedCallback(@NotNull Runnable loadingFinishedCallback) {
        if (loadingFinishedCallback == null) {
            SourcesTableModel.$$$reportNull$$$0(7);
        }
        this.myLoadingFinishedCallback = loadingFinishedCallback;
    }

    public boolean isEditable() {
        return this.getUserSourceProvider() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLoading";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishLoading";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/updater/configure/SourcesTableModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingFinishedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/updater/configure/SourcesTableModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "showEditDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSource";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRefreshCallback";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLoadingFinishedCallback";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    class Row
    implements SdkUpdaterConfigPanel.MultiStateRow,
    Comparable<Row> {
        RepositorySource mySource;
        boolean myOriginalEnabled;
        String myOriginalName;

        Row(RepositorySource source) {
            this.mySource = source;
            this.myOriginalEnabled = this.mySource.isEnabled();
            this.myOriginalName = this.mySource.getDisplayName();
        }

        @Override
        public void cycleState() {
            if (SourcesTableModel.this.isEditable(SourcesTableModel.this.indexOf(this))) {
                this.mySource.setEnabled(!this.mySource.isEnabled());
            }
        }

        public boolean isModified() {
            return this.myOriginalEnabled != this.mySource.isEnabled() || !Objects.equal((Object)this.myOriginalName, (Object)this.mySource.getDisplayName());
        }

        @Override
        public int compareTo(Row o) {
            boolean isLocal = this.mySource.getProvider() instanceof LocalSourceProvider;
            if (isLocal != o.mySource.getProvider() instanceof LocalSourceProvider) {
                return isLocal ? -1 : 1;
            }
            if (this.myOriginalName == null || o.myOriginalName == null) {
                return this.myOriginalName == null ? (o.myOriginalName == null ? 0 : 1) : -1;
            }
            return this.myOriginalName.compareTo(o.myOriginalName);
        }
    }
}

