/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;

public final class CpuVendor {
    private CpuVendor() {
    }

    static String getCpuVendor() {
        assert (SystemInfo.isWindows);
        String CpuVendor2 = "";
        String CpuInfoKey = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\";
        String[] CpuNum = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\");
        if (CpuNum.length > 0) {
            String Cpu0InfoKey = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + CpuNum[0];
            CpuVendor2 = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)Cpu0InfoKey, (String)"VendorIdentifier");
        }
        return CpuVendor2;
    }

    public static boolean isAMD() {
        return CpuVendor.getCpuVendor().compareTo("AuthenticAMD") == 0;
    }

    public static boolean isIntel() {
        return CpuVendor.getCpuVendor().compareTo("GenuineIntel") == 0;
    }
}

