/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.api.TableUIProvider;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.android.tools.property.panel.impl.model.GenericInspectorLineModel;
import com.android.tools.property.panel.impl.model.InspectorPanelModel;
import com.android.tools.property.panel.impl.model.SeparatorLineModel;
import com.android.tools.property.panel.impl.model.TableLineModelImpl;
import com.android.tools.property.panel.impl.model.TitleLineModel;
import com.android.tools.property.panel.impl.ui.CollapsibleLabelPanel;
import com.android.tools.property.panel.impl.ui.GenericLinePanel;
import com.android.tools.property.panel.impl.ui.InspectorPanelImpl;
import com.android.tools.property.panel.impl.ui.TableEditor;
import com.android.tools.property.ptable2.PTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001cH\u0002J\u001a\u0010$\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001cH\u0002J\u001c\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00192\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010,\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010\u001cH\u0002J\u0006\u0010-\u001a\u00020 J\b\u0010.\u001a\u00020 H\u0002J8\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\b\u0010#\u001a\u0004\u0018\u00010\u001cH\u0016J\u001e\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\n2\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0016J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0006\u0010=\u001a\u00020 J\u0010\u0010>\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010?\u001a\u00020\u0019J\u0006\u0010@\u001a\u00020 J\u0006\u0010A\u001a\u00020 R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/android/tools/property/panel/impl/ui/PropertiesPage;", "Lcom/android/tools/property/panel/api/InspectorPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "value", "", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "inspector", "Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl;", "inspectorModel", "Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "getInspectorModel$annotations", "()V", "getInspectorModel", "()Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "isEmpty", "", "()Z", "lastAddedLine", "Lcom/android/tools/property/panel/api/InspectorLineModel;", "lastTitleLine", "Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;", "addAsChild", "", "model", "Lcom/android/tools/property/panel/impl/model/GenericInspectorLineModel;", "parent", "addComponent", "addCustomEditor", "editorModel", "Lcom/android/tools/property/panel/api/PropertyEditorModel;", "editor", "addLine", "addSeparator", "bottomDivider", "addSeparatorAfterTitle", "addSeparatorBeforeTabs", "addSeparatorBeforeTitle", "addTable", "Lcom/android/tools/property/panel/api/TableLineModel;", "tableModel", "Lcom/android/tools/property/ptable2/PTableModel;", "searchable", "tableUI", "Lcom/android/tools/property/panel/api/TableUIProvider;", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "addTitle", "title", "checkExistingParent", "checkNewParent", "clear", "createScrollPane", "enterInFilter", "propertyValuesChanged", "repaint", "intellij.android.layout-ui"})
public final class PropertiesPage
implements InspectorPanel {
    @NotNull
    private final InspectorPanelModel inspectorModel;
    private final InspectorPanelImpl inspector;
    private InspectorLineModel lastAddedLine;
    private CollapsibleLabelModel lastTitleLine;
    @NotNull
    private final JComponent component;

    @VisibleForTesting
    public static /* synthetic */ void getInspectorModel$annotations() {
    }

    @NotNull
    public final InspectorPanelModel getInspectorModel() {
        return this.inspectorModel;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final String getFilter() {
        return this.inspectorModel.getFilter();
    }

    public final void setFilter(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.inspectorModel.setFilter(value2);
    }

    public final boolean isEmpty() {
        return this.inspectorModel.getLines().isEmpty();
    }

    public final boolean enterInFilter() {
        return this.inspectorModel.enterInFilter();
    }

    public final void clear() {
        this.inspectorModel.clear();
        this.inspector.removeAll();
        this.lastAddedLine = null;
        this.lastTitleLine = null;
    }

    public final void propertyValuesChanged() {
        this.inspectorModel.propertyValuesChanged();
    }

    public final void repaint() {
        this.inspector.revalidate();
        this.inspector.repaint();
    }

    public final void addSeparatorBeforeTabs() {
        this.addSeparatorBeforeTitle();
    }

    private final JComponent createScrollPane(JComponent component3) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)component3, (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026RIZONTAL_SCROLLBAR_NEVER)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setVerticalScrollBar((JScrollBar)new JBScrollBar(){

            public void setOpaque(boolean isOpaque) {
                super.setOpaque(isOpaque || SystemInfo.isMac);
            }
        });
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.addComponentListener(new ComponentAdapter(scrollPane){
            final /* synthetic */ JScrollPane $scrollPane;

            public void componentResized(@Nullable ComponentEvent event) {
                JScrollBar jScrollBar = this.$scrollPane.getVerticalScrollBar();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
                jScrollBar.setUnitIncrement(JBUI.scale((int)16) * (SystemInfo.isWindows ? 1 : 2));
                JScrollBar jScrollBar2 = this.$scrollPane.getVerticalScrollBar();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollBar2, (String)"scrollPane.verticalScrollBar");
                jScrollBar2.setBlockIncrement(this.$scrollPane.getHeight());
            }
            {
                this.$scrollPane = $captured_local_variable$0;
            }
        });
        return scrollPane;
    }

    @Override
    @NotNull
    public InspectorLineModel addTitle(@NotNull String title, @NotNull List<? extends AnAction> actions2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        this.addSeparatorBeforeTitle();
        TitleLineModel model2 = new TitleLineModel(title);
        CollapsibleLabelPanel label = new CollapsibleLabelPanel(model2, UIUtil.FontSize.NORMAL, 1, actions2);
        label.setOpaque(true);
        label.setInnerBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        label.setBorder(JBUI.Borders.merge((Border)((Border)JBUI.Borders.empty((int)0, (int)6, (int)0, (int)0)), (Border)((Border)new SideBorder(JBColor.border(), 8)), (boolean)true));
        this.addLine(model2, null);
        this.inspector.addLineElement(label);
        label.setBackground(UIUtil.getPanelBackground());
        this.lastTitleLine = model2;
        return model2;
    }

    @Override
    @NotNull
    public InspectorLineModel addCustomEditor(@NotNull PropertyEditorModel editorModel, @NotNull JComponent editor2, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.addSeparatorAfterTitle(parent);
        CollapsibleLabelModel model2 = new CollapsibleLabelModel(editorModel.getProperty().getName(), editorModel, false, null, 12, null);
        CollapsibleLabelPanel label = new CollapsibleLabelPanel(model2, UIUtil.FontSize.SMALL, 0, null, 8, null);
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        editorModel.setLineModel(model2);
        this.addLine(model2, parent);
        this.inspector.addLineElement(label, editor2);
        return model2;
    }

    @Override
    @NotNull
    public TableLineModel addTable(@NotNull PTableModel tableModel2, boolean searchable, @NotNull TableUIProvider tableUI, @NotNull List<? extends AnAction> actions2, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter((Object)tableModel2, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)tableUI, (String)"tableUI");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        TableLineModelImpl model2 = new TableLineModelImpl(tableModel2, searchable);
        TableEditor editor2 = new TableEditor(model2, tableUI.getTableCellRendererProvider(), tableUI.getTableCellEditorProvider(), actions2);
        this.addLine(model2, parent);
        this.inspector.addLineElement(editor2.getComponent());
        return model2;
    }

    @Override
    @NotNull
    public InspectorLineModel addComponent(@NotNull JComponent component3, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter((Object)component3, (String)"component");
        this.addSeparatorAfterTitle(parent);
        GenericInspectorLineModel model2 = new GenericInspectorLineModel();
        GenericLinePanel wrapper = new GenericLinePanel(component3, model2);
        this.addLine(model2, parent);
        this.inspector.addLineElement(wrapper);
        return model2;
    }

    private final void addLine(GenericInspectorLineModel model2, InspectorLineModel parent) {
        this.addAsChild(model2, parent);
        this.inspectorModel.add(model2);
        this.lastAddedLine = model2;
    }

    private final void addAsChild(GenericInspectorLineModel model2, InspectorLineModel parent) {
        InspectorLineModel inspectorLineModel = parent;
        if (inspectorLineModel != null) {
            if (Intrinsics.areEqual((Object)inspectorLineModel, (Object)this.lastAddedLine)) {
                this.checkNewParent(parent).addChild(model2);
            } else {
                this.checkExistingParent(parent).addChild(model2);
            }
        }
    }

    private final CollapsibleLabelModel checkNewParent(InspectorLineModel parent) {
        InspectorLineModel inspectorLineModel = parent;
        if (!(inspectorLineModel instanceof CollapsibleLabelModel)) {
            inspectorLineModel = null;
        }
        CollapsibleLabelModel collapsibleLabelModel = (CollapsibleLabelModel)inspectorLineModel;
        if (collapsibleLabelModel == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        CollapsibleLabelModel label = collapsibleLabelModel;
        if (!label.getExpandable()) {
            throw (Throwable)new IllegalArgumentException();
        }
        return label;
    }

    private final CollapsibleLabelModel checkExistingParent(InspectorLineModel parent) {
        InspectorLineModel lastParentLine;
        InspectorLineModel inspectorLineModel = this.lastAddedLine;
        InspectorLineModel inspectorLineModel2 = lastParentLine = inspectorLineModel != null ? inspectorLineModel.getParent() : null;
        while (lastParentLine != null) {
            if (Intrinsics.areEqual((Object)parent, (Object)lastParentLine)) {
                return (CollapsibleLabelModel)lastParentLine;
            }
            lastParentLine = lastParentLine.getParent();
        }
        throw (Throwable)new IllegalArgumentException();
    }

    private final void addSeparatorBeforeTitle() {
        if (this.lastAddedLine == null || Intrinsics.areEqual((Object)this.lastAddedLine, (Object)this.lastTitleLine)) {
            return;
        }
        InspectorLineModel topParent = this.lastAddedLine;
        while (true) {
            InspectorLineModel inspectorLineModel = topParent;
            if ((inspectorLineModel != null ? inspectorLineModel.getParent() : null) == null) break;
            topParent = topParent.getParent();
        }
        CollapsibleLabelModel parent = Intrinsics.areEqual((Object)topParent, (Object)this.lastTitleLine) ? this.lastTitleLine : null;
        this.addSeparator(true, parent);
    }

    private final void addSeparatorAfterTitle(InspectorLineModel parent) {
        if (this.lastAddedLine == null || Intrinsics.areEqual((Object)this.lastAddedLine, (Object)this.lastTitleLine)) {
            this.addSeparator(false, parent);
        }
    }

    private final GenericInspectorLineModel addSeparator(boolean bottomDivider, InspectorLineModel parent) {
        JPanel component3 = new JPanel();
        component3.setPreferredSize((Dimension)new JBDimension(0, 4));
        component3.setBackground(this.inspector.getBackground());
        component3.setBorder(bottomDivider ? (Border)new SideBorder(JBColor.border(), 8) : (Border)JBUI.Borders.empty());
        SeparatorLineModel model2 = new SeparatorLineModel();
        GenericLinePanel wrapper = new GenericLinePanel(component3, model2);
        this.addLine(model2, parent);
        this.inspector.addLineElement(wrapper);
        return model2;
    }

    static /* synthetic */ GenericInspectorLineModel addSeparator$default(PropertiesPage propertiesPage, boolean bl, InspectorLineModel inspectorLineModel, int n, Object object) {
        if ((n & 2) != 0) {
            inspectorLineModel = null;
        }
        return propertiesPage.addSeparator(bl, inspectorLineModel);
    }

    public PropertiesPage(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.inspectorModel = new InspectorPanelModel();
        this.inspector = new InspectorPanelImpl(this.inspectorModel, parentDisposable);
        this.component = this.createScrollPane((JComponent)((Object)this.inspector));
    }

    @Override
    @NotNull
    public InspectorLineModel addExpandableTitle(@NotNull String title, boolean initiallyExpanded, @NotNull List<? extends AnAction> actions2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        return InspectorPanel.DefaultImpls.addExpandableTitle(this, title, initiallyExpanded, actions2);
    }

    @Override
    @NotNull
    public InspectorLineModel addEditor(@NotNull Pair<? extends PropertyEditorModel, ? extends JComponent> modelEditorPair, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter(modelEditorPair, (String)"modelEditorPair");
        return InspectorPanel.DefaultImpls.addEditor(this, modelEditorPair, parent);
    }
}

