/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.ptable2.impl;

import com.android.tools.property.ptable2.impl.PTablePosition;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JTable;
import javax.swing.LayoutFocusTraversalPolicy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\bH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/property/ptable2/impl/PTableFocusTraversalPolicy;", "Ljavax/swing/LayoutFocusTraversalPolicy;", "table", "Ljavax/swing/JTable;", "(Ljavax/swing/JTable;)V", "getTable", "()Ljavax/swing/JTable;", "accept", "", "aComponent", "Ljava/awt/Component;", "editNextEditableCell", "forwards", "getComponentAfter", "aContainer", "Ljava/awt/Container;", "getComponentBefore", "getDefaultComponent", "getFirstComponent", "getFocusCandidateFromNewlyCreatedEditor", "getLastComponent", "intellij.android.layout-ui"})
public final class PTableFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    @NotNull
    private final JTable table;

    @Override
    @Nullable
    public Component getComponentAfter(@NotNull Container aContainer, @NotNull Component aComponent) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        Intrinsics.checkNotNullParameter((Object)aComponent, (String)"aComponent");
        if (!this.table.isEditing()) {
            return null;
        }
        Component after = super.getComponentAfter(aContainer, aComponent);
        if (after != null && Intrinsics.areEqual((Object)after, (Object)this.table) ^ true) {
            return after;
        }
        return this.editNextEditableCell(true);
    }

    @Override
    @Nullable
    public Component getComponentBefore(@NotNull Container aContainer, @NotNull Component aComponent) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        Intrinsics.checkNotNullParameter((Object)aComponent, (String)"aComponent");
        if (!this.table.isEditing()) {
            return null;
        }
        Component before = super.getComponentBefore(aContainer, aComponent);
        if (before != null && Intrinsics.areEqual((Object)before, (Object)this.table) ^ true) {
            return before;
        }
        return this.editNextEditableCell(false);
    }

    private final Component editNextEditableCell(boolean forwards) {
        if (!this.table.isVisible()) {
            return null;
        }
        int rows = this.table.getRowCount();
        int columns2 = this.table.getColumnCount();
        PTablePosition pos = this.table.isEditing() ? new PTablePosition(this.table.getEditingRow(), this.table.getEditingColumn(), rows, columns2) : (forwards ? new PTablePosition(-1, columns2 - 1, rows, columns2) : new PTablePosition(rows, 0, rows, columns2));
        while (pos.next(forwards)) {
            Component component3;
            if (!this.table.isCellEditable(pos.getRow(), pos.getColumn())) continue;
            this.table.setRowSelectionInterval(pos.getRow(), pos.getRow());
            if (!this.table.editCellAt(pos.getRow(), pos.getColumn()) || (component3 = this.getFocusCandidateFromNewlyCreatedEditor(forwards)) == null) continue;
            return component3;
        }
        return null;
    }

    private final Component getFocusCandidateFromNewlyCreatedEditor(boolean forwards) {
        if (forwards) {
            return super.getFirstComponent(this.table);
        }
        return super.getLastComponent(this.table);
    }

    @Override
    @Nullable
    public Component getFirstComponent(@NotNull Container aContainer) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        return this.editNextEditableCell(true);
    }

    @Override
    @Nullable
    public Component getLastComponent(@NotNull Container aContainer) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        return this.editNextEditableCell(false);
    }

    @Override
    @Nullable
    public Component getDefaultComponent(@NotNull Container aContainer) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        return this.getFirstComponent(aContainer);
    }

    @Override
    protected boolean accept(@Nullable Component aComponent) {
        if (Intrinsics.areEqual((Object)aComponent, (Object)this.table)) {
            return false;
        }
        return super.accept(aComponent);
    }

    @NotNull
    public final JTable getTable() {
        return this.table;
    }

    public PTableFocusTraversalPolicy(@NotNull JTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
    }
}

