/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.AndroidRClassBase;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.ManifestClass;
import org.jetbrains.android.augment.ManifestInnerClass;
import org.jetbrains.android.augment.StyleableAttrFieldUrl;
import org.jetbrains.android.augment.StyleableAttrLightField;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElementWithRequiredName;
import org.jetbrains.android.dom.manifest.Permission;
import org.jetbrains.android.dom.manifest.PermissionGroup;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J/\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/android/AndroidGotoDeclarationHandler;", "Lcom/intellij/codeInsight/navigation/actions/GotoDeclarationHandler;", "()V", "collectManifestElements", "", "Lcom/intellij/psi/PsiElement;", "nestedClassName", "", "fieldName", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/android/facet/AndroidFacet;)[Lcom/intellij/psi/PsiElement;", "findAttrElementsInStyleables", "styleables", "", "Lcom/android/ide/common/resources/ResourceItem;", "targetElement", "Lorg/jetbrains/android/augment/StyleableAttrLightField;", "(Ljava/util/List;Lorg/jetbrains/android/augment/StyleableAttrLightField;)[Lcom/intellij/psi/PsiElement;", "findAttributeResourceInStyleableTag", "Lcom/intellij/psi/xml/XmlAttributeValue;", "styleableDeclaration", "asReference", "Lcom/android/ide/common/rendering/api/ResourceReference;", "getGotoDeclarationTargets", "sourceElement", "offset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;ILcom/intellij/openapi/editor/Editor;)[Lcom/intellij/psi/PsiElement;", "intellij.android.core"})
public final class AndroidGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, @NotNull Editor editor2) {
        PsiElement[] psiElementArray;
        block16: {
            block19: {
                String string;
                PsiClass containingClass;
                PsiElement targetElement;
                block21: {
                    block20: {
                        block17: {
                            block18: {
                                block15: {
                                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                                    if (sourceElement == null) {
                                        return PsiElement.EMPTY_ARRAY;
                                    }
                                    targetElement = TargetElementUtil.getInstance().findTargetElement(editor2, 1, offset);
                                    if (!(targetElement instanceof ResourceReferencePsiElement)) break block15;
                                    psiElementArray = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(((ResourceReferencePsiElement)targetElement).getResourceReference(), (PsiElement)sourceElement.getContainingFile());
                                    break block16;
                                }
                                if (!(targetElement instanceof StyleableAttrLightField)) break block17;
                                if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) break block18;
                                ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(targetElement);
                                if (resourceReferencePsiElement == null) {
                                    return PsiElement.EMPTY_ARRAY;
                                }
                                ResourceReferencePsiElement referencePsiElement = resourceReferencePsiElement;
                                psiElementArray = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(referencePsiElement.getResourceReference(), sourceElement);
                                break block16;
                            }
                            StyleableAttrFieldUrl styleableAttrUrl = ((StyleableAttrLightField)targetElement).getStyleableAttrFieldUrl();
                            Object object = ResourceRepositoryManager.getInstance(sourceElement);
                            if (object == null || (object = ((ResourceRepositoryManager)object).getAllResources()) == null || (object = object.getResources(styleableAttrUrl.getStyleable())) == null) {
                                return PsiElement.EMPTY_ARRAY;
                            }
                            Object styleables = object;
                            return this.findAttrElementsInStyleables((List<? extends ResourceItem>)styleables, (StyleableAttrLightField)targetElement);
                        }
                        if (targetElement instanceof AndroidLightField) {
                            PsiElement[] psiElementArray2;
                            PsiClass styleableAttrUrl = ((AndroidLightField)targetElement).getContainingClass().getContainingClass();
                            if (styleableAttrUrl instanceof AndroidRClassBase) {
                                ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(targetElement);
                                if (resourceReferencePsiElement == null) {
                                    return PsiElement.EMPTY_ARRAY;
                                }
                                ResourceReferencePsiElement referencePsiElement = resourceReferencePsiElement;
                                psiElementArray2 = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(referencePsiElement.getResourceReference(), sourceElement);
                            } else if (styleableAttrUrl instanceof ManifestClass) {
                                AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)sourceElement);
                                if (androidFacet == null) {
                                    return PsiElement.EMPTY_ARRAY;
                                }
                                AndroidFacet androidFacet2 = androidFacet;
                                String field2 = ((AndroidLightField)targetElement).getName();
                                PsiClass psiClass = ((AndroidLightField)targetElement).getParent();
                                if (psiClass == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.android.augment.ManifestInnerClass");
                                }
                                String string2 = ((ManifestInnerClass)psiClass).getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(targetElement.parent as ManifestInnerClass).name");
                                String innerClassName = string2;
                                psiElementArray2 = this.collectManifestElements(innerClassName, field2, androidFacet2);
                            } else {
                                psiElementArray2 = PsiElement.EMPTY_ARRAY;
                            }
                            return psiElementArray2;
                        }
                        if (!(targetElement instanceof ClsFieldImpl)) break block19;
                        PsiClass psiClass = ((ClsFieldImpl)targetElement).getContainingClass();
                        if (psiClass == null) {
                            return PsiElement.EMPTY_ARRAY;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"targetElement.containing\u2026rn PsiElement.EMPTY_ARRAY");
                        containingClass = psiClass;
                        string = containingClass.getName();
                        if (string == null) break block20;
                        String string3 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string3;
                        boolean bl3 = false;
                        string = ResourceType.fromClassName((String)it);
                        if (string != null) break block21;
                    }
                    return PsiElement.EMPTY_ARRAY;
                }
                String resourceType = string;
                PsiClass psiClass = containingClass.getContainingClass();
                return Intrinsics.areEqual((Object)"android.R", (Object)(psiClass != null ? psiClass.getQualifiedName() : null)) ? AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(new ResourceReference(ResourceNamespace.ANDROID, (ResourceType)resourceType, ((ClsFieldImpl)targetElement).getName()), sourceElement) : PsiElement.EMPTY_ARRAY;
            }
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        return psiElementArray;
    }

    private final PsiElement[] findAttrElementsInStyleables(List<? extends ResourceItem> styleables, StyleableAttrLightField targetElement) {
        boolean bl = false;
        List result2 = new ArrayList();
        StyleableAttrFieldUrl styleableAttrUrl = targetElement.getStyleableAttrFieldUrl();
        for (ResourceItem resourceItem : styleables) {
            ResourceValue resourceValue2 = resourceItem.getResourceValue();
            if (!(resourceValue2 instanceof StyleableResourceValue)) continue;
            for (AttrResourceValue attributeValue : ((StyleableResourceValue)resourceValue2).getAllAttributes()) {
                XmlAttributeValue attributeInStyleable;
                XmlAttributeValue declaration;
                if (!Intrinsics.areEqual((Object)attributeValue.asReference(), (Object)styleableAttrUrl.getAttr())) continue;
                PsiElement psiElement = AndroidResourceToPsiResolver.getInstance().resolveToDeclaration(resourceItem, targetElement.getProject());
                if (!(psiElement instanceof XmlAttributeValue)) {
                    psiElement = null;
                }
                if ((XmlAttributeValue)psiElement == null) {
                    continue;
                }
                ResourceReference resourceReference = attributeValue.asReference();
                Intrinsics.checkNotNullExpressionValue((Object)resourceReference, (String)"attributeValue.asReference()");
                if (this.findAttributeResourceInStyleableTag(declaration, resourceReference) == null) {
                    continue;
                }
                result2.add(attributeInStyleable);
            }
        }
        Collection collection2 = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = collection2;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        if (psiElementArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiElementArray;
    }

    private final XmlAttributeValue findAttributeResourceInStyleableTag(XmlAttributeValue styleableDeclaration, ResourceReference asReference) {
        XmlTag[] subTags;
        ResourceFolderType resourceType = ResourceHelper.getFolderType(styleableDeclaration.getContainingFile());
        if (resourceType != ResourceFolderType.VALUES) {
            return null;
        }
        PsiElement $this$parentOfType$iv = (PsiElement)styleableDeclaration;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlAttribute.class, (boolean)true);
        if (xmlAttribute == null) {
            return null;
        }
        XmlAttribute xmlAttribute2 = xmlAttribute;
        if (Intrinsics.areEqual((Object)xmlAttribute2.getName(), (Object)"name") ^ true) {
            return null;
        }
        PsiElement $this$parentOfType$iv2 = (PsiElement)xmlAttribute2;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv2, XmlTag.class, (boolean)true);
        if (xmlTag == null) {
            return null;
        }
        XmlTag xmlTag2 = xmlTag;
        if (Intrinsics.areEqual((Object)xmlTag2.getName(), (Object)"declare-styleable") ^ true) {
            return null;
        }
        for (XmlTag subTag : subTags = xmlTag2.getSubTags()) {
            ResourceReferencePsiElement resourceReferencePsiElement;
            XmlAttribute xmlAttribute3 = subTag.getAttribute("name");
            if (xmlAttribute3 == null || (xmlAttribute3 = xmlAttribute3.getValueElement()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttribute3, (String)"subTag.getAttribute(NAME\u2026.valueElement ?: continue");
            XmlAttribute attributeValue = xmlAttribute3;
            ResourceReferencePsiElement resourceReferencePsiElement2 = resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create((PsiElement)attributeValue);
            if (!Intrinsics.areEqual((Object)asReference, (Object)(resourceReferencePsiElement2 != null ? resourceReferencePsiElement2.getResourceReference() : null))) continue;
            return attributeValue;
        }
        return null;
    }

    private final PsiElement[] collectManifestElements(String nestedClassName, String fieldName, AndroidFacet facet2) {
        List<ManifestElementWithRequiredName> list;
        ArrayList<XmlAttributeValue> result2 = new ArrayList<XmlAttributeValue>();
        Manifest manifest = Manifest.getMainManifest(facet2);
        if (manifest == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
            return PsiElement.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"Manifest.getMainManifest\u2026rn PsiElement.EMPTY_ARRAY");
        Manifest manifest2 = manifest;
        switch (nestedClassName) {
            case "permission": {
                List<Permission> list2 = manifest2.getPermissions();
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"manifest.permissions");
                break;
            }
            case "permission_group": {
                List<PermissionGroup> list3 = manifest2.getPermissionGroups();
                list = list3;
                Intrinsics.checkNotNullExpressionValue(list3, (String)"manifest.permissionGroups");
                break;
            }
            default: {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }
        }
        List<ManifestElementWithRequiredName> list4 = list;
        for (ManifestElementWithRequiredName domElement : list4) {
            XmlAttributeValue psiElement;
            String unqualifiedName;
            AndroidAttributeValue<String> nameAttribute;
            AndroidAttributeValue<String> androidAttributeValue = nameAttribute = domElement.getName();
            Intrinsics.checkNotNullExpressionValue(androidAttributeValue, (String)"nameAttribute");
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.getShortName((String)StringUtil.notNullize((String)((String)androidAttributeValue.getValue()))), (String)"StringUtil.getShortName(\u2026ize(nameAttribute.value))");
            if (!AndroidUtils.equal(unqualifiedName, fieldName, false) || (psiElement = nameAttribute.getXmlAttributeValue()) == null) continue;
            result2.add(psiElement);
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        if (psiElementArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiElementArray;
    }
}

