/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

final class AndroidPlugin {
    AndroidPlugin() {
        VirtualFileSystemOpener.INSTANCE.mount();
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            AndroidPlugin.initializeForNonStudio();
        }
    }

    private static void initializeForNonStudio() {
        AnalyticsSettings.disable();
        UsageTracker.disable();
        UsageTracker.setIdeBrand((AndroidStudioEvent.IdeBrand)AndroidStudioEvent.IdeBrand.INTELLIJ);
    }

    private static void setUpActionsUnderFlag(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            AndroidPlugin.$$$reportNull$$$0(0);
        }
        if (!((Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get()).booleanValue()) {
            return;
        }
        AnAction parentGroup = actionManager.getAction("BuildMenu");
        if (!(parentGroup instanceof DefaultActionGroup)) {
            return;
        }
        String groupId = "Android.BuildApkOrBundle";
        DefaultActionGroup group2 = new DefaultActionGroup("Build Bundle(s) / APK(s)", true){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project = e.getProject();
                e.getPresentation().setEnabledAndVisible(project != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/AndroidPlugin$1", "update"));
            }
        };
        actionManager.registerAction("Android.BuildApkOrBundle", (AnAction)group2);
        ((DefaultActionGroup)parentGroup).add((AnAction)group2, new Constraints(Anchor.BEFORE, "Android.GenerateSignedApk"), actionManager);
        Actions.moveAction("Android.BuildApk", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.FIRST, null), actionManager);
        Actions.moveAction("Android.BuildBundle", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.AFTER, null), actionManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "org/jetbrains/android/AndroidPlugin", "setUpActionsUnderFlag"));
    }

    static final class AndroidActionConfigurationCustomizer
    implements ActionConfigurationCustomizer {
        AndroidActionConfigurationCustomizer() {
        }

        public void customize(@NotNull ActionManager manager) {
            if (manager == null) {
                AndroidActionConfigurationCustomizer.$$$reportNull$$$0(0);
            }
            AndroidPlugin.setUpActionsUnderFlag(manager);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/AndroidPlugin$AndroidActionConfigurationCustomizer", "customize"));
        }
    }
}

