/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDialogUtils {
    private static final Logger LOG = Logger.getInstance(ExternalSystemUtil.class);

    @Nullable
    public static IdeaSourceProvider getSourceProvider(@Nullable JComboBox combo) {
        Object selectedItem;
        if (combo != null && combo.isVisible() && (selectedItem = combo.getSelectedItem()) instanceof ApiComboBoxItem) {
            return (IdeaSourceProvider)((ApiComboBoxItem)selectedItem).getData();
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getResourceDirectory(@Nullable IdeaSourceProvider sourceProvider, @NotNull Module module) {
        VirtualFile res;
        AndroidFacet facet2;
        if (module == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceProvider != null) {
            PsiManager manager = PsiManager.getInstance((Project)module.getProject());
            for (String fileUrl : sourceProvider.getResDirectoryUrls()) {
                PsiDirectory dir;
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
                if (virtualFile == null) {
                    try {
                        virtualFile = VfsUtil.createDirectories((String)VfsUtilCore.urlToPath((String)fileUrl));
                    }
                    catch (IOException ex) {
                        LOG.warn((Throwable)ex);
                    }
                }
                if (virtualFile == null || (dir = manager.findDirectory(virtualFile)) == null) continue;
                return dir;
            }
        }
        if ((facet2 = AndroidFacet.getInstance((Module)module)) != null && (res = ResourceFolderManager.getInstance(facet2).getPrimaryFolder()) != null) {
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(res);
        }
        return null;
    }

    public static void updateSourceSetCombo(@NotNull JComponent label, @NotNull JComboBox combo, @Nullable AndroidFacet facet2) {
        if (label == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(1);
        }
        if (combo == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(2);
        }
        if (facet2 != null && AndroidModel.isRequired(facet2) && AndroidModel.get(facet2) != null) {
            List<NamedIdeaSourceProvider> providers2 = SourceProviderManager.getInstance(facet2).getAllSourceProviders();
            DefaultComboBoxModel<ApiComboBoxItem<NamedIdeaSourceProvider>> model2 = new DefaultComboBoxModel<ApiComboBoxItem<NamedIdeaSourceProvider>>();
            for (NamedIdeaSourceProvider sourceProvider : providers2) {
                model2.addElement(new ApiComboBoxItem<NamedIdeaSourceProvider>(sourceProvider, sourceProvider.getName(), 0, 0));
            }
            combo.setModel(model2);
            label.setVisible(true);
            combo.setVisible(true);
        } else {
            label.setVisible(false);
            combo.setVisible(false);
        }
    }

    @Nullable
    private static VirtualFile getResFolderParent(@NotNull LocalResourceManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(4);
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || !manager.isResourceDir(current)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findResourceDirectory(@NotNull DataContext dataContext) {
        VirtualFile resFolder;
        LocalResourceManager manager;
        Module module;
        AbstractProjectViewPane pane;
        Project project;
        if (dataContext == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(5);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null && (pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane()) instanceof AndroidProjectViewPane) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && (module = (Module)LangDataKeys.MODULE.getData(dataContext)) != null && (manager = LocalResourceManager.getInstance(module)) != null && (resFolder = CreateResourceDialogUtils.getResFolderParent(manager, file)) != null) {
            return AndroidPsiUtils.getPsiDirectorySafely((Project)module.getProject(), (VirtualFile)resFolder);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/actions/CreateResourceDialogUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSourceSetCombo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getResFolderParent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findResourceDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

