/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.google.common.base.Verify;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.AndroidLightInnerClassBase;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.android.augment.StyleableAttrFieldUrl;
import org.jetbrains.android.augment.StyleableAttrLightField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InnerRClassBase
extends AndroidLightInnerClassBase {
    private static final Logger LOG = Logger.getInstance(InnerRClassBase.class);
    @NotNull
    protected final ResourceType myResourceType;
    @Nullable
    private CachedValue<PsiField[]> myFieldsCache;
    protected static PsiType INT_ARRAY = PsiType.INT.createArrayType();

    public InnerRClassBase(@NotNull PsiClass context, @NotNull ResourceType resourceType) {
        if (context == null) {
            InnerRClassBase.$$$reportNull$$$0(0);
        }
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(1);
        }
        super(context, resourceType.getName());
        this.myResourceType = resourceType;
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull ResourceRepository repository, @NotNull ResourceNamespace namespace, @NotNull AndroidLightField.FieldModifier fieldModifier, @NotNull BiPredicate<ResourceType, String> isPublic, @NotNull ResourceType resourceType, @NotNull PsiClass context) {
        if (repository == null) {
            InnerRClassBase.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            InnerRClassBase.$$$reportNull$$$0(3);
        }
        if (fieldModifier == null) {
            InnerRClassBase.$$$reportNull$$$0(4);
        }
        if (isPublic == null) {
            InnerRClassBase.$$$reportNull$$$0(5);
        }
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(6);
        }
        if (context == null) {
            InnerRClassBase.$$$reportNull$$$0(7);
        }
        ArrayList<String> styleableFields = new ArrayList<String>();
        ArrayList<StyleableAttrFieldUrl> styleableAttrFields = new ArrayList<StyleableAttrFieldUrl>();
        ArrayList<String> otherFields = new ArrayList<String>();
        if (resourceType == ResourceType.STYLEABLE) {
            ListMultimap map2 = repository.getResources(namespace, resourceType);
            styleableFields.addAll(map2.keySet());
            for (ResourceItem item : map2.values()) {
                StyleableResourceValue value2 = (StyleableResourceValue)item.getResourceValue();
                if (value2 == null) continue;
                List attributes = value2.getAllAttributes();
                for (AttrResourceValue attr : attributes) {
                    if (!isPublic.test(attr.getResourceType(), attr.getName())) continue;
                    ResourceNamespace attrNamespace = attr.getNamespace();
                    styleableAttrFields.add(new StyleableAttrFieldUrl(new ResourceReference(namespace, ResourceType.STYLEABLE, item.getName()), new ResourceReference(attrNamespace, ResourceType.ATTR, attr.getName())));
                }
            }
        } else {
            otherFields.addAll(repository.getResourceNames(namespace, resourceType));
        }
        return InnerRClassBase.buildResourceFields(otherFields, styleableFields, styleableAttrFields, resourceType, context, fieldModifier);
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull Collection<String> otherFields, @NotNull Collection<String> styleableFields, @NotNull Collection<StyleableAttrFieldUrl> styleableAttrFields, @NotNull ResourceType resourceType, @NotNull PsiClass context, @NotNull AndroidLightField.FieldModifier fieldModifier) {
        AndroidLightField field2;
        int fieldId;
        if (otherFields == null) {
            InnerRClassBase.$$$reportNull$$$0(8);
        }
        if (styleableFields == null) {
            InnerRClassBase.$$$reportNull$$$0(9);
        }
        if (styleableAttrFields == null) {
            InnerRClassBase.$$$reportNull$$$0(10);
        }
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(11);
        }
        if (context == null) {
            InnerRClassBase.$$$reportNull$$$0(12);
        }
        if (fieldModifier == null) {
            InnerRClassBase.$$$reportNull$$$0(13);
        }
        PsiField[] result2 = new PsiField[otherFields.size() + styleableFields.size() + styleableAttrFields.size()];
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        int nextId = resourceType.ordinal() * 100000;
        int i2 = 0;
        for (String fieldName : otherFields) {
            fieldId = nextId++;
            field2 = new ResourceLightField(fieldName, context, (PsiType)PsiType.INT, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null);
            field2.setInitializer(factory.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i2++] = field2;
        }
        for (String fieldName : styleableFields) {
            fieldId = nextId++;
            field2 = new ResourceLightField(fieldName, context, INT_ARRAY, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null);
            field2.setInitializer(factory.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i2++] = field2;
        }
        for (StyleableAttrFieldUrl fieldContents : styleableAttrFields) {
            fieldId = nextId++;
            field2 = new StyleableAttrLightField(fieldContents, context, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null);
            field2.setInitializer(factory.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i2++] = field2;
        }
        if (result2 == null) {
            InnerRClassBase.$$$reportNull$$$0(14);
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                ModificationTracker dependencies2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Recomputing fields for " + this);
                }
                Verify.verify((!((dependencies2 = this.getFieldsDependencies()) instanceof ResourceRepository) ? 1 : 0) != 0, (String)"Resource repository leaked in a CachedValue.", (Object[])new Object[0]);
                return CachedValueProvider.Result.create((Object)this.doGetFields(), (Object[])new Object[]{dependencies2});
            });
        }
        PsiField[] psiFieldArray = (PsiField[])this.myFieldsCache.getValue();
        if (psiFieldArray == null) {
            InnerRClassBase.$$$reportNull$$$0(15);
        }
        return psiFieldArray;
    }

    @NotNull
    protected abstract PsiField[] doGetFields();

    @NotNull
    protected abstract ModificationTracker getFieldsDependencies();

    @NotNull
    public ResourceType getResourceType() {
        ResourceType resourceType = this.myResourceType;
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(16);
        }
        return resourceType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldModifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPublic";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherFields";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleableFields";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleableAttrFields";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/augment/InnerRClassBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/augment/InnerRClassBase";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResourceFields";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildResourceFields";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

