/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPrecompileTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidPrecompileTask");

    public boolean execute(@NotNull CompileContext context) {
        Project project;
        if (context == null) {
            AndroidPrecompileTask.$$$reportNull$$$0(0);
        }
        if (!ProjectFacetManager.getInstance((Project)(project = context.getProject())).hasFacets(AndroidFacet.ID)) {
            return true;
        }
        BuildManager.forceModelLoading((CompileContext)context);
        AndroidPrecompileTask.createGenModulesAndSourceRoots(project);
        return true;
    }

    private static boolean prepareForCompilation(CompileContext context) {
        Project project = context.getProject();
        if (!AndroidPrecompileTask.checkArtifacts(context)) {
            return false;
        }
        AndroidPrecompileTask.checkAndroidDependencies(context);
        ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        HashSet<ExcludeEntryDescription> addedEntries = new HashSet<ExcludeEntryDescription>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidPlatform platform;
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null) continue;
            if (context.isRebuild()) {
                AndroidPrecompileTask.clearResCache(facet2, context);
            }
            int platformToolsRevision = (platform = AndroidPlatform.getInstance(facet2.getModule())) != null ? platform.getSdkData().getPlatformToolsRevision() : -1;
            LOG.debug("Platform-tools revision for module " + module.getName() + " is " + platformToolsRevision);
            if (((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
            if (platformToolsRevision >= 0 && platformToolsRevision <= 7) {
                LOG.debug("Excluded sources of module " + module.getName());
                AndroidPrecompileTask.excludeAllSourceRoots(module, configuration, addedEntries);
                continue;
            }
            AndroidPrecompileTask.unexcludeAllSourceRoots(facet2, configuration);
        }
        if (!addedEntries.isEmpty()) {
            LOG.debug("Files excluded by Android: " + addedEntries.size());
            project.getMessageBus().connect().subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new MyCompilationStatusListener(project, addedEntries));
        }
        return true;
    }

    private static void createGenModulesAndSourceRoots(final Project project) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        final ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null) continue;
            facets.add(facet2);
        }
        if (!facets.isEmpty()) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AndroidCompileUtil.createGenModulesAndSourceRoots(project, facets);
                }
            }, indicator != null ? indicator.getModalityState() : ModalityState.NON_MODAL);
        }
    }

    private static boolean checkArtifacts(@NotNull CompileContext context) {
        String message2;
        if (context == null) {
            AndroidPrecompileTask.$$$reportNull$$$0(1);
        }
        final Project project = context.getProject();
        final CompileScope scope = context.getCompileScope();
        Set artifacts = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<Artifact>>(){

            public Set<Artifact> compute() {
                return ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)scope, (boolean)false);
            }
        });
        if (artifacts == null) {
            return true;
        }
        HashSet<Artifact> debugArtifacts = new HashSet<Artifact>();
        HashSet<Artifact> releaseArtifacts = new HashSet<Artifact>();
        HashMap facet2artifacts = new HashMap();
        for (final Artifact artifact : artifacts) {
            AndroidFacet facet2;
            ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
            if (properties instanceof AndroidApplicationArtifactProperties) {
                AndroidArtifactSigningMode mode = ((AndroidApplicationArtifactProperties)properties).getSigningMode();
                if (mode == AndroidArtifactSigningMode.DEBUG || mode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
                    debugArtifacts.add(artifact);
                } else {
                    releaseArtifacts.add(artifact);
                }
            }
            if ((facet2 = (AndroidFacet)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AndroidFacet>(){

                @Nullable
                public AndroidFacet compute() {
                    return AndroidArtifactUtil.getPackagedFacet(project, artifact);
                }
            })) == null) continue;
            ArrayList<Artifact> list = (ArrayList<Artifact>)facet2artifacts.get(facet2);
            if (list == null) {
                list = new ArrayList<Artifact>();
                facet2artifacts.put(facet2, list);
            }
            list.add(artifact);
        }
        boolean success2 = true;
        if (!debugArtifacts.isEmpty() && !releaseArtifacts.isEmpty()) {
            message2 = "Cannot build debug and release Android artifacts in the same session\nDebug artifacts: " + AndroidPrecompileTask.toString(debugArtifacts) + "\nRelease artifacts: " + AndroidPrecompileTask.toString(releaseArtifacts);
            context.addMessage(CompilerMessageCategory.ERROR, message2, null, -1, -1);
            success2 = false;
        }
        if (!releaseArtifacts.isEmpty() && CompileStepBeforeRun.getRunConfiguration((CompileContext)context) != null) {
            message2 = "Cannot build release Android artifacts in the 'make before run' session\nRelease artifacts: " + AndroidPrecompileTask.toString(releaseArtifacts);
            context.addMessage(CompilerMessageCategory.ERROR, message2, null, -1, -1);
            success2 = false;
        }
        block1: for (Map.Entry entry : facet2artifacts.entrySet()) {
            List list = (List)entry.getValue();
            String moduleName2 = ((AndroidFacet)entry.getKey()).getModule().getName();
            if (list.size() <= 1) continue;
            Artifact firstArtifact = (Artifact)list.get(0);
            Object[] firstArtifactProGuardOptions = AndroidPrecompileTask.getProGuardOptions(firstArtifact);
            for (int i2 = 1; i2 < list.size(); ++i2) {
                Artifact artifact = (Artifact)list.get(i2);
                if (Arrays.equals(AndroidPrecompileTask.getProGuardOptions(artifact), firstArtifactProGuardOptions)) continue;
                context.addMessage(CompilerMessageCategory.ERROR, "Artifacts related to the same module '" + moduleName2 + "' have different ProGuard options: " + firstArtifact.getName() + ", " + artifact.getName(), null, -1, -1);
                success2 = false;
                continue block1;
            }
        }
        return success2;
    }

    @NotNull
    private static Object[] getProGuardOptions(@NotNull Artifact artifact) {
        ArtifactProperties properties;
        if (artifact == null) {
            AndroidPrecompileTask.$$$reportNull$$$0(2);
        }
        if ((properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) {
            AndroidApplicationArtifactProperties p = (AndroidApplicationArtifactProperties)properties;
            Object[] objectArray = new Object[]{p.isRunProGuard(), p.getProGuardCfgFiles()};
            if (objectArray == null) {
                AndroidPrecompileTask.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            AndroidPrecompileTask.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private static String toString(Collection<Artifact> artifacts) {
        StringBuilder result2 = new StringBuilder();
        for (Artifact artifact : artifacts) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            result2.append(artifact.getName());
        }
        return result2.toString();
    }

    private static void checkAndroidDependencies(@NotNull CompileContext context) {
        if (context == null) {
            AndroidPrecompileTask.$$$reportNull$$$0(5);
        }
        for (Module module : context.getCompileScope().getAffectedModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null) continue;
            Pair<String, VirtualFile> manifestMergerProp = AndroidRootUtil.getProjectPropertyValue(module, "manifestmerger.enabled");
            if (manifestMergerProp != null && Boolean.parseBoolean((String)manifestMergerProp.getFirst())) {
                context.addMessage(CompilerMessageCategory.WARNING, "[" + module.getName() + "] " + AndroidBundle.message("android.manifest.merger.not.supported.error", new Object[0]), ((VirtualFile)manifestMergerProp.getSecond()).getUrl(), -1, -1);
            }
            if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                AndroidFacet depFacet;
                Module depModule;
                ModuleOrderEntry moduleOrderEntry;
                if (!(entry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)entry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance((Module)depModule)) == null || ((AndroidFacetConfiguration)depFacet.getConfiguration()).canBeDependency()) continue;
                String message2 = "Suspicious module dependency " + module.getName() + " -> " + depModule.getName() + ": Android application module depends on other application module. Possibly, you should ";
                if (AndroidMavenUtil.isMavenizedModule(depModule)) {
                    message2 = message2 + "change packaging type of module " + depModule.getName() + " to 'apklib' in pom.xml file or ";
                }
                message2 = message2 + "change dependency scope to 'Provided'.";
                context.addMessage(CompilerMessageCategory.WARNING, message2, null, -1, -1);
            }
        }
    }

    private static void clearResCache(@NotNull AndroidFacet facet2, @NotNull CompileContext context) {
        File dir;
        Module module;
        String dirPath;
        if (facet2 == null) {
            AndroidPrecompileTask.$$$reportNull$$$0(6);
        }
        if (context == null) {
            AndroidPrecompileTask.$$$reportNull$$$0(7);
        }
        if ((dirPath = AndroidCompileUtil.findResourcesCacheDirectory(module = facet2.getModule(), false, null)) != null && (dir = new File(dirPath)).exists()) {
            FileUtil.delete((File)dir);
        }
    }

    private static void unexcludeAllSourceRoots(AndroidFacet facet2, ExcludesConfiguration configuration) {
        VirtualFile buildconfigGenDir;
        VirtualFile rsGenRoot;
        VirtualFile aptGenSourceRoot;
        String aptGenSourceRootPath;
        VirtualFile aidlGenSourceRoot;
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)facet2.getModule()).getSourceRoots();
        HashSet<VirtualFile> sourceRootSet = new HashSet<VirtualFile>();
        sourceRootSet.addAll(Arrays.asList(sourceRoots));
        String aidlGenSourceRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet2);
        if (aidlGenSourceRootPath != null && (aidlGenSourceRoot = LocalFileSystem.getInstance().findFileByPath(aidlGenSourceRootPath)) != null) {
            sourceRootSet.remove(aidlGenSourceRoot);
        }
        if ((aptGenSourceRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet2)) != null && (aptGenSourceRoot = LocalFileSystem.getInstance().findFileByPath(aptGenSourceRootPath)) != null) {
            sourceRootSet.remove(aptGenSourceRoot);
        }
        if ((rsGenRoot = AndroidRootUtil.getRenderscriptGenDir(facet2)) != null) {
            sourceRootSet.remove(rsGenRoot);
        }
        if ((buildconfigGenDir = AndroidRootUtil.getBuildconfigGenDir(facet2)) != null) {
            sourceRootSet.remove(buildconfigGenDir);
        }
        ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
        configuration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description : descriptions) {
            VirtualFile file = description.getVirtualFile();
            if (file != null && sourceRootSet.contains(file)) continue;
            configuration.addExcludeEntryDescription(description);
        }
    }

    private static void excludeAllSourceRoots(Module module, ExcludesConfiguration configuration, Collection<ExcludeEntryDescription> addedEntries) {
        VirtualFile[] sourceRoots;
        Project project = module.getProject();
        for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            ExcludeEntryDescription description = new ExcludeEntryDescription(sourceRoot, true, false, (Disposable)project);
            if (configuration.containsExcludeEntryDescription(description)) continue;
            configuration.addExcludeEntryDescription(description);
            addedEntries.add(description);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/AndroidPrecompileTask";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/AndroidPrecompileTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProGuardOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkArtifacts";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProGuardOptions";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAndroidDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearResCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCompilationStatusListener
    implements CompilationStatusListener {
        private final Project myProject;
        private final Set<ExcludeEntryDescription> myEntriesToRemove;

        public MyCompilationStatusListener(Project project, Set<ExcludeEntryDescription> entriesToRemove) {
            this.myProject = project;
            this.myEntriesToRemove = entriesToRemove;
        }

        public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            if (compileContext == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(0);
            }
            ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)this.myProject).getExcludedEntriesConfiguration();
            ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
            configuration.removeAllExcludeEntryDescriptions();
            for (ExcludeEntryDescription description : descriptions) {
                if (this.myEntriesToRemove.contains(description)) continue;
                configuration.addExcludeEntryDescription(description);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "org/jetbrains/android/compiler/AndroidPrecompileTask$MyCompilationStatusListener", "compilationFinished"));
        }
    }
}

