/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.lang.aidl.AidlFileType;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidResourceFilesListener
implements Disposable,
BulkFileListener {
    private static final Key<String> CACHED_PACKAGE_KEY = Key.create((String)"ANDROID_RESOURCE_LISTENER_CACHED_PACKAGE");
    private final MergingUpdateQueue myQueue;
    private final Project myProject;

    public AndroidResourceFilesListener(@NotNull Project project) {
        if (project == null) {
            AndroidResourceFilesListener.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("AndroidResourcesCompilationQueue", 300, true, null, (Disposable)this, null, false);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Set<VirtualFile> filesToProcess;
        if (events == null) {
            AndroidResourceFilesListener.$$$reportNull$$$0(1);
        }
        if (!(filesToProcess = AndroidResourceFilesListener.getFilesToProcess(events)).isEmpty()) {
            this.myQueue.queue((Update)new MyUpdate(filesToProcess));
        }
    }

    @NotNull
    private static Set<VirtualFile> getFilesToProcess(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AndroidResourceFilesListener.$$$reportNull$$$0(2);
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !AndroidFileChangeListener.isRelevantFile(file)) continue;
            result2.add(file);
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            AndroidResourceFilesListener.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/AndroidResourceFilesListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/AndroidResourceFilesListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToProcess";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyUpdate
    extends Update {
        private final Set<VirtualFile> myFiles;

        MyUpdate(Set<VirtualFile> files2) {
            if (files2 == null) {
                MyUpdate.$$$reportNull$$$0(0);
            }
            super(files2);
            this.myFiles = files2;
        }

        public void run() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MultiMap map2 = (MultiMap)ApplicationManager.getApplication().runReadAction(() -> this.computeCompilersToRunAndInvalidateLocalAttributesMap());
            if (map2.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map2.entrySet()) {
                Module module = (Module)entry.getKey();
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
                if (facet2 == null || !ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet2)) continue;
                ModuleSourceAutogenerating sourceAutogenerator = ModuleSourceAutogenerating.getInstance(facet2);
                assert (sourceAutogenerator != null);
                for (AndroidAutogeneratorMode mode : (Collection)entry.getValue()) {
                    sourceAutogenerator.scheduleSourceRegenerating(mode);
                }
            }
        }

        @NotNull
        private MultiMap<Module, AndroidAutogeneratorMode> computeCompilersToRunAndInvalidateLocalAttributesMap() {
            if (AndroidResourceFilesListener.this.myProject.isDisposed()) {
                MultiMap multiMap = MultiMap.empty();
                if (multiMap == null) {
                    MyUpdate.$$$reportNull$$$0(1);
                }
                return multiMap;
            }
            MultiMap result2 = MultiMap.create();
            for (VirtualFile file : this.myFiles) {
                List<AndroidAutogeneratorMode> modes;
                AndroidFacet facet2;
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)AndroidResourceFilesListener.this.myProject);
                if (module == null || module.isDisposed() || (facet2 = AndroidFacet.getInstance((Module)module)) == null || (modes = this.computeCompilersToRunAndInvalidateLocalAttributesMap(facet2, file)).isEmpty()) continue;
                result2.putValues((Object)module, modes);
            }
            MultiMap multiMap = result2;
            if (multiMap == null) {
                MyUpdate.$$$reportNull$$$0(2);
            }
            return multiMap;
        }

        @NotNull
        private List<AndroidAutogeneratorMode> computeCompilersToRunAndInvalidateLocalAttributesMap(AndroidFacet facet2, VirtualFile file) {
            VirtualFile sourceRoot;
            VirtualFile parent = file.getParent();
            if (parent == null) {
                List<AndroidAutogeneratorMode> list = Collections.emptyList();
                if (list == null) {
                    MyUpdate.$$$reportNull$$$0(3);
                }
                return list;
            }
            Module module = facet2.getModule();
            VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet2);
            ArrayList<AndroidAutogeneratorMode> modes = new ArrayList<AndroidAutogeneratorMode>();
            if (Comparing.equal((Object)manifestFile, (Object)file)) {
                Manifest manifest = Manifest.getMainManifest(facet2);
                String aPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
                String cachedPackage = (String)facet2.getUserData(CACHED_PACKAGE_KEY);
                if (cachedPackage != null && !cachedPackage.equals(aPackage)) {
                    String aptGenDirPath = AndroidRootUtil.getAptGenSourceRootPath(facet2);
                    AndroidCompileUtil.removeDuplicatingClasses(module, cachedPackage, "R", null, aptGenDirPath);
                }
                facet2.putUserData(CACHED_PACKAGE_KEY, (Object)aPackage);
                modes.add(AndroidAutogeneratorMode.BUILDCONFIG);
            } else if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)AidlFileType.INSTANCE)) {
                VirtualFile sourceRoot2 = AndroidUtils.findSourceRoot(module, file);
                if (sourceRoot2 != null && !Comparing.equal((Object)AndroidRootUtil.getAidlGenDir(facet2), (Object)sourceRoot2)) {
                    modes.add(AndroidAutogeneratorMode.AIDL);
                }
            } else if (file.getFileType() == AndroidRenderscriptFileType.INSTANCE && (sourceRoot = AndroidUtils.findSourceRoot(module, file)) != null && !Comparing.equal((Object)AndroidRootUtil.getRenderscriptGenDir(facet2), (Object)sourceRoot)) {
                modes.add(AndroidAutogeneratorMode.RENDERSCRIPT);
            }
            ArrayList<AndroidAutogeneratorMode> arrayList = modes;
            if (arrayList == null) {
                MyUpdate.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        public boolean canEat(Update update2) {
            return update2 instanceof MyUpdate && this.myFiles.containsAll(((MyUpdate)update2).myFiles);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/compiler/AndroidResourceFilesListener$MyUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/compiler/AndroidResourceFilesListener$MyUpdate";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeCompilersToRunAndInvalidateLocalAttributesMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

