/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.CommonBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElementType;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidArtifactUtil {
    private AndroidArtifactUtil() {
    }

    public static boolean containsAndroidPackage(ArtifactEditorContext editorContext, Artifact artifact) {
        return !ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)AndroidFinalPackageElementType.getInstance(), (Processor)new Processor<AndroidFinalPackageElement>(){

            public boolean process(AndroidFinalPackageElement e) {
                return false;
            }
        }, (PackagingElementResolvingContext)editorContext, (boolean)true);
    }

    public static boolean isRelatedArtifact(@NotNull Artifact artifact, @NotNull Module module) {
        if (artifact == null) {
            AndroidArtifactUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AndroidArtifactUtil.$$$reportNull$$$0(1);
        }
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            return false;
        }
        AndroidFacet facet2 = AndroidArtifactUtil.getPackagedFacet(module.getProject(), artifact);
        return facet2 != null && module.equals(facet2.getModule());
    }

    @Nullable
    public static AndroidFacet getPackagedFacet(Project project, Artifact artifact) {
        final Ref elementRef = Ref.create(null);
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project).getResolvingContext();
        ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)AndroidFinalPackageElementType.getInstance(), (Processor)new Processor<AndroidFinalPackageElement>(){

            public boolean process(AndroidFinalPackageElement e) {
                elementRef.set((Object)e);
                return false;
            }
        }, (PackagingElementResolvingContext)resolvingContext, (boolean)true);
        AndroidFinalPackageElement element = (AndroidFinalPackageElement)((Object)elementRef.get());
        return element != null ? element.getFacet() : null;
    }

    @Nullable
    public static AndroidFacet chooseAndroidApplicationModule(@NotNull Project project, @NotNull List<AndroidFacet> facets) {
        if (project == null) {
            AndroidArtifactUtil.$$$reportNull$$$0(2);
        }
        if (facets == null) {
            AndroidArtifactUtil.$$$reportNull$$$0(3);
        }
        HashMap<Module, AndroidFacet> map2 = new HashMap<Module, AndroidFacet>();
        for (AndroidFacet facet2 : facets) {
            map2.put(facet2.getModule(), facet2);
        }
        Object message2 = "Selected Android application module will be included in the created artifact with all dependencies";
        ChooseModulesDialog dialog2 = new ChooseModulesDialog(project, new ArrayList(map2.keySet()), "Select Module", (String)message2);
        dialog2.setSingleSelectionMode();
        dialog2.show();
        List selected = dialog2.getChosenElements();
        if (selected.isEmpty()) {
            return null;
        }
        assert (selected.size() == 1);
        Module module = (Module)selected.get(0);
        String moduleName2 = module.getName();
        AndroidFacet facet3 = (AndroidFacet)map2.get(module);
        if (facet3 == null) {
            message2 = "Cannot find Android facet for module " + moduleName2;
            Messages.showErrorDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle());
            return null;
        }
        return facet3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/compiler/artifact/AndroidArtifactUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRelatedArtifact";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAndroidApplicationModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

