/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.android.dom.ProvidedDocumentationPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemovedApiField
extends ProvidedDocumentationPsiElement
implements PsiNamedElement {
    private static final String API_LEVELS_URL = "https://developer.android.com/guide/topics/manifest/uses-sdk-element.html#ApiLevels";
    private final String myName;
    private final PsiClass myContext;
    private final int mySince;
    private final int myDeprecatedIn;
    private final int myRemovedIn;

    public RemovedApiField(@NotNull String name, @NotNull PsiClass context, int since, int deprecatedIn, int removedIn) {
        if (name == null) {
            RemovedApiField.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RemovedApiField.$$$reportNull$$$0(1);
        }
        super(context.getManager(), Language.ANY, name, "");
        this.myName = name;
        this.myContext = context;
        this.mySince = since;
        this.myDeprecatedIn = deprecatedIn;
        this.myRemovedIn = removedIn;
    }

    public int getSince() {
        return this.mySince;
    }

    public int getDeprecatedIn() {
        return this.myDeprecatedIn;
    }

    public int getRemovedIn() {
        return this.myRemovedIn;
    }

    public boolean isEquivalentTo(PsiElement element) {
        if (element == this) {
            return true;
        }
        if (!(element instanceof RemovedApiField)) {
            return false;
        }
        RemovedApiField other = (RemovedApiField)element;
        return this.myName.equals(other.myName) && this.myContext.isEquivalentTo((PsiElement)other.myContext);
    }

    @NotNull
    public PsiElement getParent() {
        PsiClass psiClass = this.myContext;
        if (psiClass == null) {
            RemovedApiField.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.myContext.getContainingFile();
    }

    @Override
    @NotNull
    public String getDocumentation() {
        StringBuilder sb = new StringBuilder();
        sb.append("<HTML>\n");
        sb.append(String.format(Locale.US, "<p><b>%s</b>\n", this.myName));
        sb.append(String.format(Locale.US, "<p>Added in <a href=\"%s\">API level %d</a>\n", API_LEVELS_URL, this.mySince));
        if (this.myDeprecatedIn != 0 && this.myDeprecatedIn < this.myRemovedIn) {
            sb.append(String.format(Locale.US, "<br>Deprecated in <a href=\"%s\">API level %d</a>\n", API_LEVELS_URL, this.myDeprecatedIn));
        }
        sb.append(String.format(Locale.US, "<br>Removed in <a href=\"%s\">API level %d</a>\n", API_LEVELS_URL, this.myRemovedIn));
        sb.append("</HTML>\n");
        String string = sb.toString();
        if (string == null) {
            RemovedApiField.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.myName;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RemovedApiField.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            RemovedApiField.$$$reportNull$$$0(5);
        }
        throw new IncorrectOperationException();
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    public Icon getElementIcon(int flags) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RemovedApiField field2 = (RemovedApiField)((Object)o);
        return this.myName.equals(field2.myName) && this.myContext.equals(field2.myContext) && this.mySince == field2.mySince && this.myDeprecatedIn == field2.myDeprecatedIn && this.myRemovedIn == field2.myRemovedIn;
    }

    public int hashCode() {
        return 31 * this.myName.hashCode() + this.myContext.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/RemovedApiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/RemovedApiField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

