/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.google.common.collect.Multimap;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.navigation.NavElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubtagsProcessingUtil {
    private SubtagsProcessingUtil() {
    }

    private static boolean isPreferenceGroup(@NotNull PsiClass psiClass, @Nullable PsiClass baseClass) {
        if (psiClass == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(0);
        }
        Project project = psiClass.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return baseClass != null && (psiManager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)psiClass) || psiClass.isInheritor(baseClass, true));
    }

    public static void registerXmlResourcesSubtags(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull SubtagProcessor subtagProcessor) {
        String tagName;
        if (facet2 == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(1);
        }
        if (tag == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(2);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(3);
        }
        switch (tagName = tag.getName()) {
            case "searchable": {
                subtagProcessor.processSubtag("actionkey", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Keyboard": {
                subtagProcessor.processSubtag("Row", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Row": {
                subtagProcessor.processSubtag("Key", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "device-admin": {
                subtagProcessor.processSubtag("uses-policies", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "uses-policies": {
                subtagProcessor.processSubtag("limit-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("watch-login", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("reset-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("force-lock", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("wipe-data", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("set-global-proxy", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("expire-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("encrypted-storage", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-camera", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-keyguard-features", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "preference-headers": {
                subtagProcessor.processSubtag("header", (Type)((Object)PreferenceElement.class));
            }
        }
        AndroidXmlResourcesUtil.PreferenceSource preferenceSource = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet2);
        Map<String, PsiClass> prefClassMap = AttributeProcessingUtil.getClassMap(facet2, preferenceSource.getQualifiedBaseClass());
        PsiClass groupClass = prefClassMap.get(preferenceSource.getQualifiedGroupClass());
        PsiClass psiClass = prefClassMap.get(tagName);
        if (psiClass != null && SubtagsProcessingUtil.isPreferenceGroup(psiClass, groupClass)) {
            SubtagsProcessingUtil.registerClassNameSubtags(tag, prefClassMap, PreferenceElement.class, subtagProcessor);
        }
    }

    private static void registerClassNameSubtags(XmlTag tag, Map<String, PsiClass> classMap, Type type, SubtagProcessor subtagProcessor) {
        HashSet<String> allAllowedTags = new HashSet<String>();
        HashMap<String, String> class2Name = new HashMap<String, String>();
        for (Map.Entry<String, PsiClass> entry : classMap.entrySet()) {
            String tagName = entry.getKey();
            PsiClass aClass = entry.getValue();
            if (AndroidUtils.isAbstract(aClass)) continue;
            allAllowedTags.add(tagName);
            String qName = aClass.getQualifiedName();
            String prevTagName = (String)class2Name.get(qName);
            if (prevTagName != null && tagName.indexOf(46) != -1) continue;
            class2Name.put(qName, tagName);
        }
        SubtagsProcessingUtil.registerSubtags(tag, allAllowedTags, class2Name.values(), type, subtagProcessor);
    }

    private static void registerSubtags(@NotNull XmlTag tag, @NotNull Collection<String> allowedTags, @NotNull Collection<String> tagsToComplete, @NotNull Type type, @NotNull SubtagProcessor subtagProcessor) {
        if (tag == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(4);
        }
        if (allowedTags == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(5);
        }
        if (tagsToComplete == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(6);
        }
        if (type == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(7);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(8);
        }
        for (String tagName : tagsToComplete) {
            subtagProcessor.processSubtag(tagName, type);
        }
        SubtagsProcessingUtil.registerExistingSubtags(tag, allowedTags::contains, type, subtagProcessor);
    }

    public static void processSubtags(@NotNull AndroidFacet facet2, @NotNull AndroidDomElement element, @NotNull SubtagProcessor subtagProcessor) {
        if (facet2 == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(9);
        }
        if (element == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(10);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(11);
        }
        if (element instanceof LayoutElement) {
            SubtagsProcessingUtil.registerClassNameSubtags(element.getXmlTag(), AttributeProcessingUtil.getViewClassMap(facet2), LayoutViewElement.class, subtagProcessor);
        } else if (element instanceof XmlResourceElement) {
            XmlTag tag = element.getXmlTag();
            if (tag != null) {
                SubtagsProcessingUtil.registerXmlResourcesSubtags(facet2, tag, subtagProcessor);
            }
        } else if (element instanceof NavElement) {
            try {
                NavigationSchema.createIfNecessary(facet2.getModule());
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get(facet2.getModule());
            Multimap<Class<? extends AndroidDomElement>, String> subtags = schema.getDestinationSubtags(element.getXmlTag().getName());
            for (Class c : subtags.keys()) {
                SubtagsProcessingUtil.registerSubtags(element.getXmlTag(), subtags.get((Object)c), subtags.get((Object)c), c, subtagProcessor);
            }
        }
    }

    private static void registerExistingSubtags(@NotNull XmlTag tag, @NotNull Predicate<String> filter2, @NotNull Type type, @NotNull SubtagProcessor subtagProcessor) {
        XmlTag[] subtags;
        if (tag == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(12);
        }
        if (filter2 == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(13);
        }
        if (type == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(14);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(15);
        }
        for (XmlTag subtag : subtags = tag.getSubTags()) {
            String localName = subtag.getLocalName();
            if (!filter2.test(localName) || localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            subtagProcessor.processSubtag(new XmlName(localName), type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtagProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedTags";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagsToComplete";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/dom/SubtagsProcessingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPreferenceGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerXmlResourcesSubtags";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSubtags";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processSubtags";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExistingSubtags";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface SubtagProcessor {
        public void processSubtag(@NotNull XmlName var1, @NotNull Type var2);

        default public void processSubtag(@NotNull String xmlName, @NotNull Type type) {
            if (xmlName == null) {
                SubtagProcessor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                SubtagProcessor.$$$reportNull$$$0(1);
            }
            this.processSubtag(new XmlName(xmlName), type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "xmlName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/SubtagsProcessingUtil$SubtagProcessor";
            objectArray[2] = "processSubtag";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

