/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReferenceBase
extends PsiReferenceBase.Poly<XmlElement> {
    protected final AndroidFacet myFacet;
    protected final ResourceValue myResourceValue;

    public AndroidResourceReferenceBase(@NotNull GenericDomValue value2, @Nullable TextRange range, @NotNull ResourceValue resourceValue2, @NotNull AndroidFacet facet2) {
        if (value2 == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(0);
        }
        if (resourceValue2 == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(1);
        }
        if (facet2 == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(2);
        }
        super((PsiElement)DomUtil.getValueElement((GenericDomValue)value2), range, true);
        this.myResourceValue = resourceValue2;
        this.myFacet = facet2;
    }

    public boolean includeDynamicFeatures() {
        return false;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public ResourceValue getResourceValue() {
        ResourceValue resourceValue2 = this.myResourceValue;
        if (resourceValue2 == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(4);
        }
        return resourceValue2;
    }

    @NotNull
    public PsiElement[] computeTargetElements() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        ArrayList<Object> results = new ArrayList<Object>();
        for (ResolveResult result2 : resolveResults) {
            PsiElement element = result2.getElement();
            if (element instanceof LazyValueResourceElementWrapper) {
                results.add(((LazyValueResourceElementWrapper)element).computeElement());
                continue;
            }
            if (element instanceof ResourceElementWrapper) {
                results.add(((ResourceElementWrapper)element).getWrappedElement());
                continue;
            }
            if (element instanceof ResourceReferencePsiElement) {
                PsiElement[] targets = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(((ResourceReferencePsiElement)element).getResourceReference(), this.myElement);
                results.addAll(Arrays.asList(targets));
                continue;
            }
            results.add(element);
        }
        PsiElement[] psiElementArray = results.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)((XmlElement)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (reference2, incompleteCode1) -> this.resolveInner(), false, incompleteCode);
        if (resolveResultArray == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    @NotNull
    private ResolveResult[] resolveInner() {
        if (this.includeDynamicFeatures()) {
            ResolveResult[] resolveResultArray = AndroidResourceToPsiResolver.getInstance().resolveReferenceWithDynamicFeatureModules(this.myResourceValue, (XmlElement)this.myElement, this.myFacet);
            if (resolveResultArray == null) {
                AndroidResourceReferenceBase.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = AndroidResourceToPsiResolver.getInstance().resolveReference(this.myResourceValue, (XmlElement)this.myElement, this.myFacet);
        if (resolveResultArray == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(9);
        }
        ResolveResult[] results = this.multiResolve(false);
        PsiFile psiFile2 = element.getContainingFile();
        VirtualFile vFile = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        for (ResolveResult result2 : results) {
            ValueResourceInfo info;
            PsiElement target = result2.getElement();
            if (element.getManager().areElementsEquivalent(target, element)) {
                return true;
            }
            if (!(target instanceof LazyValueResourceElementWrapper) || vFile == null || !(info = ((LazyValueResourceElementWrapper)target).getResourceInfo()).getContainingFile().equals(vFile)) continue;
            XmlAttributeValue realTarget = info.computeXmlElement();
            if (!element.getManager().areElementsEquivalent((PsiElement)realTarget, element)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTargetElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

