/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceNameConverter
extends ResolvingConverter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (this.getErrorMessage(s, context) != null) {
            return null;
        }
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        ResourceType type = null;
        XmlTag tag = context.getTag();
        if (tag != null && "attr".equals(tag.getName())) {
            type = ResourceType.ATTR;
        }
        return s == null ? null : ValueResourceNameValidator.getErrorText((String)s, type);
    }

    @Nullable
    public PsiElement resolve(String s, ConvertContext context) {
        ResourceType type;
        LocalResourceManager resourceManager;
        ResourceFolderType fileResType;
        XmlTag tag;
        XmlElement element = context.getXmlElement();
        XmlTag xmlTag = tag = element instanceof XmlTag ? (XmlTag)element : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null || s == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)tag);
        if (facet2 != null && ResourceFolderType.VALUES == (fileResType = (resourceManager = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager()).getFileResourceFolderType(tag.getContainingFile())) && (type = AndroidResourceUtil.getResourceTypeForResourceTag(tag)) != null) {
            return new ResourceReferencePsiElement(new ResourceReference(ResourceNamespace.TODO(), type, s), context.getPsiManager(), false);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable String resolveResult, ConvertContext context) {
        if (element == null) {
            ResourceNameConverter.$$$reportNull$$$0(0);
        }
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue() && element instanceof ResourceReferencePsiElement) {
            return element.isEquivalentTo(this.resolve(stringValue, context));
        }
        return super.isReferenceTo(element, stringValue, (Object)resolveResult, context);
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        if (!(element instanceof GenericAttributeValue)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ResourceNameConverter.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (element.getParent() instanceof Style) {
            Collection<String> collection2 = ResourceNameConverter.getStyleNameVariants(context, (GenericAttributeValue)element);
            if (collection2 == null) {
                ResourceNameConverter.$$$reportNull$$$0(2);
            }
            return collection2;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            ResourceNameConverter.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static Collection<String> getStyleNameVariants(ConvertContext context, GenericAttributeValue element) {
        Module module = context.getModule();
        if (module == null) {
            return Collections.emptyList();
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            return Collections.emptyList();
        }
        LocalResourceManager manager = LocalResourceManager.getInstance(module);
        if (manager == null) {
            return Collections.emptyList();
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet2);
        Set styleNames = appResources.getResources(ResourceNamespace.TODO(), ResourceType.STYLE).keySet();
        ArrayList<String> result2 = new ArrayList<String>();
        String currentValue = element.getStringValue();
        for (String name : styleNames) {
            if (currentValue != null && currentValue.startsWith(name)) continue;
            result2.add(name + ".");
        }
        return result2;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ResourceNameConverter.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ResourceNameConverter.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        DomElement parent = value2.getParent();
        if (parent instanceof Style) {
            PsiReference[] psiReferenceArray = ResourceNameConverter.getReferencesInStyleName((Style)parent, value2, facet2);
            if (psiReferenceArray == null) {
                ResourceNameConverter.$$$reportNull$$$0(6);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            ResourceNameConverter.$$$reportNull$$$0(7);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getReferencesInStyleName(@NotNull Style style, @NotNull GenericDomValue<String> value2, @NotNull AndroidFacet facet2) {
        String s;
        if (style == null) {
            ResourceNameConverter.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            ResourceNameConverter.$$$reportNull$$$0(9);
        }
        if (facet2 == null) {
            ResourceNameConverter.$$$reportNull$$$0(10);
        }
        if ((s = value2.getStringValue()) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String[] ids2 = s.split("\\.");
        if (ids2.length < 2 || style.getParentStyle().getStringValue() != null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<MyParentStyleReference> result2 = new ArrayList<MyParentStyleReference>(ids2.length - 1);
        int offset = s.length();
        for (int i2 = ids2.length - 1; i2 >= 0; --i2) {
            if (i2 < ids2.length - 1) {
                String parentStyleName = s.substring(0, offset);
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), parentStyleName);
                result2.add(new MyParentStyleReference(value2, new TextRange(1, 1 + offset), val, facet2));
                if (ResourceNameConverter.hasExplicitParent(facet2, parentStyleName)) break;
            }
            offset = offset - ids2[i2].length() - 1;
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    public static boolean hasExplicitParent(@NotNull AndroidFacet facet2, @NotNull String localStyleName) {
        LocalResourceRepository repository;
        List<ResourceItem> styles2;
        if (facet2 == null) {
            ResourceNameConverter.$$$reportNull$$$0(11);
        }
        if (localStyleName == null) {
            ResourceNameConverter.$$$reportNull$$$0(12);
        }
        if ((styles2 = (repository = ResourceRepositoryManager.getAppResources(facet2)).getResources(ResourceNamespace.TODO(), ResourceType.STYLE, localStyleName)).isEmpty()) {
            return false;
        }
        for (ResourceItem style : styles2) {
            com.android.ide.common.rendering.api.ResourceValue resourceValue2 = style.getResourceValue();
            if (resourceValue2 instanceof StyleResourceValue && ((StyleResourceValue)resourceValue2).getParentStyleName() != null) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/resources/ResourceNameConverter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localStyleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/resources/ResourceNameConverter";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesInStyleName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyParentStyleReference
    extends AndroidResourceReferenceBase
    implements LocalQuickFixProvider {
        public MyParentStyleReference(@NotNull GenericDomValue value2, @Nullable TextRange range, @NotNull ResourceValue resourceValue2, @NotNull AndroidFacet facet2) {
            if (value2 == null) {
                MyParentStyleReference.$$$reportNull$$$0(0);
            }
            if (resourceValue2 == null) {
                MyParentStyleReference.$$$reportNull$$$0(1);
            }
            if (facet2 == null) {
                MyParentStyleReference.$$$reportNull$$$0(2);
            }
            super(value2, range, resourceValue2, facet2);
        }

        public LocalQuickFix[] getQuickFixes() {
            String resourceName = this.getValue();
            if (resourceName.isEmpty()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiFile psiFile2 = ((XmlElement)this.getElement()).getContainingFile();
            if (psiFile2 == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new CreateValueResourceQuickFix(this.myFacet, ResourceType.STYLE, resourceName, psiFile2, false)};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resourceValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "facet";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/resources/ResourceNameConverter$MyParentStyleReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

