/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AndroidSourceType {
    MANIFEST("manifest", it -> ImmutableList.copyOf(it.getManifestFiles()), AllIcons.Modules.SourceRoot),
    JAVA("java", it -> ImmutableList.copyOf(it.getJavaDirectories()), AllIcons.Modules.SourceRoot),
    GENERATED_JAVA(JAVA.getName(), null, AllIcons.Modules.GeneratedSourceRoot, true),
    CPP("cpp", it -> ImmutableList.copyOf(it.getJniDirectories()), AllIcons.Modules.SourceRoot),
    AIDL("aidl", it -> ImmutableList.copyOf(it.getAidlDirectories()), AllIcons.Modules.SourceRoot),
    RENDERSCRIPT("renderscript", it -> ImmutableList.copyOf(it.getRenderscriptDirectories()), AllIcons.Modules.SourceRoot),
    SHADERS("shaders", it -> ImmutableList.copyOf(it.getShadersDirectories()), AllIcons.Modules.SourceRoot),
    ASSETS("assets", it -> ImmutableList.copyOf(it.getAssetsDirectories()), AllIcons.Modules.ResourcesRoot),
    JNILIBS("jniLibs", it -> ImmutableList.copyOf(it.getJniLibsDirectories()), AllIcons.Modules.ResourcesRoot),
    RES("res", it -> ImmutableList.copyOf(it.getResDirectories()), AllIcons.Modules.ResourcesRoot),
    GENERATED_RES(RES.getName(), it -> ImmutableList.copyOf(it.getResDirectories()), AllIcons.Modules.ResourcesRoot, true),
    RESOURCES("resources", it -> ImmutableList.copyOf(it.getResourcesDirectories()), AllIcons.Modules.ResourcesRoot);

    private final String myName;
    private final Function<NamedIdeaSourceProvider, List<VirtualFile>> mySourceExtractor;
    private final Icon myIcon;
    private final boolean myGenerated;

    private AndroidSourceType(@NotNull String name, Function<NamedIdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon2) {
        if (name == null) {
            AndroidSourceType.$$$reportNull$$$0(0);
        }
        if (icon2 == null) {
            AndroidSourceType.$$$reportNull$$$0(1);
        }
        this(name, sourceExtractor, icon2, false);
    }

    private AndroidSourceType(@NotNull String name, Function<NamedIdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon2, boolean generated) {
        if (name == null) {
            AndroidSourceType.$$$reportNull$$$0(2);
        }
        if (icon2 == null) {
            AndroidSourceType.$$$reportNull$$$0(3);
        }
        this.myName = name;
        this.mySourceExtractor = sourceExtractor;
        this.myIcon = icon2;
        this.myGenerated = generated;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<VirtualFile> getSources(NamedIdeaSourceProvider provider2) {
        if (this.mySourceExtractor == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                AndroidSourceType.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<VirtualFile> files2 = this.mySourceExtractor.apply(provider2);
        List<Object> list = files2 == null ? Collections.emptyList() : files2;
        if (list == null) {
            AndroidSourceType.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isGenerated() {
        return this.myGenerated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidSourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidSourceType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

