/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.magicConstant.MagicCompletionContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTypeCompletionContributor
extends CompletionContributor {
    private static final int PRIORITY = 100;

    public void fillCompletionVariants(final @NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiElement pos;
        if (parameters2 == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(1);
        }
        if (JavaKeywordCompletion.AFTER_DOT.accepts((Object)(pos = parameters2.getPosition()))) {
            return;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)pos);
        if (facet2 == null) {
            return;
        }
        Constraints allowedValues = ResourceTypeCompletionContributor.getAllowedValues(pos);
        if (allowedValues == null) {
            return;
        }
        THashSet allowed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiElement>(){

            public int computeHashCode(PsiElement object) {
                return 0;
            }

            public boolean equals(PsiElement o1, PsiElement o2) {
                return parameters2.getOriginalFile().getManager().areElementsEquivalent(o1, o2);
            }
        });
        if (allowedValues instanceof ResourceTypeAllowedValues) {
            for (ResourceType resourceType : ((ResourceTypeAllowedValues)allowedValues).types) {
                if (resourceType == ResourceEvaluator.COLOR_INT_MARKER_TYPE || resourceType == ResourceEvaluator.DIMENSION_MARKER_TYPE) continue;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                String code = "R." + resourceType.getName();
                String fqcn = MergedManifestManager.getSnapshot(facet2).getPackage();
                String qualifiedCode = fqcn + "." + code;
                Project project = facet2.getModule().getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedCode, GlobalSearchScope.allScope((Project)project));
                if (cls != null) {
                    result2.addElement((LookupElement)new JavaPsiClassReferenceElement(cls));
                    continue;
                }
                PsiExpression type = factory.createExpressionFromText(code, pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)type, (String)code), (double)99.0));
                allowed.add(type);
            }
        } else if (allowedValues instanceof AllowedValues) {
            AllowedValues a = (AllowedValues)allowedValues;
            if (a.canBeOred) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                PsiExpression zero = factory.createExpressionFromText("0", pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)zero, (String)"0"), (double)99.0));
                PsiExpression minusOne = factory.createExpressionFromText("-1", pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)minusOne, (String)"-1"), (double)99.0));
                allowed.add(zero);
                allowed.add(minusOne);
            }
            List<ExpectedTypeInfo> types = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes((CompletionParameters)parameters2));
            for (PsiAnnotationMemberValue value2 : a.values) {
                PsiElement resolved;
                if (value2 instanceof PsiReference && (resolved = ((PsiReference)value2).resolve()) instanceof PsiNamedElement) {
                    LookupElement lookupElement = LookupItemUtil.objectToLookupItem((Object)resolved);
                    if (lookupElement instanceof VariableLookupItem) {
                        ((VariableLookupItem)lookupElement).setSubstitutor(PsiSubstitutor.EMPTY);
                    }
                    LookupElement element = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0);
                    element = ResourceTypeCompletionContributor.decorate(parameters2, types, element);
                    result2.addElement(element);
                    allowed.add(resolved);
                    continue;
                }
                LookupElementBuilder element = LookupElementBuilder.create((Object)value2, (String)value2.getText());
                element = ResourceTypeCompletionContributor.decorate(parameters2, types, (LookupElement)element);
                result2.addElement((LookupElement)element);
                allowed.add(value2);
            }
        }
        result2.runRemainingContributors(parameters2, (Consumer)new Consumer<CompletionResult>((Set)allowed, result2){
            final /* synthetic */ Set val$allowed;
            final /* synthetic */ CompletionResultSet val$result;
            {
                this.val$allowed = set;
                this.val$result = completionResultSet;
            }

            public void consume(CompletionResult completionResult) {
                LookupElement element = completionResult.getLookupElement();
                Object object = element.getObject();
                if (object instanceof PsiElement && this.val$allowed.contains(object)) {
                    return;
                }
                this.val$result.passResult(completionResult);
            }
        });
    }

    @Nullable
    private static Constraints getAllowedValues(@NotNull PsiElement pos) {
        if (pos == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(2);
        }
        Constraints allowedValues = null;
        for (Pair pair : MagicCompletionContributor.getMembersWithAllowedValues((PsiElement)pos)) {
            Constraints values = ResourceTypeCompletionContributor.getAllowedValues((PsiModifierListOwner)pair.first, (PsiType)pair.second, null);
            if (values == null) continue;
            if (allowedValues == null) {
                allowedValues = values;
                continue;
            }
            if (allowedValues.equals(values)) continue;
            return null;
        }
        return allowedValues;
    }

    private static LookupElement decorate(CompletionParameters parameters2, List<ExpectedTypeInfo> types, LookupElement element) {
        if (!types.isEmpty() && parameters2.getCompletionType() == CompletionType.SMART) {
            element = JavaSmartCompletionContributor.decorate((LookupElement)element, types);
        }
        return element;
    }

    @Nullable
    public static Constraints getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type, @Nullable Set<PsiClass> visited) {
        if (element == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(3);
        }
        PsiAnnotation[] annotations = ResourceTypeCompletionContributor.getAllAnnotations(element);
        PsiManager manager = element.getManager();
        ArrayList<ResourceType> resourceTypes = null;
        Constraints constraint = null;
        for (PsiAnnotation annotation : annotations) {
            PsiClass aClass;
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(qualifiedName) || qualifiedName.startsWith("test.pkg.")) {
                ResourceType resourceType;
                if (SdkConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) || SdkConstants.STRING_DEF_ANNOTATION.isEquals(qualifiedName)) {
                    if (type != null && !(annotation instanceof PsiCompiledElement)) {
                        constraint = ResourceTypeCompletionContributor.merge(ResourceTypeCompletionContributor.getAllowedValuesFromTypedef(type, annotation, manager), constraint);
                    }
                } else if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(qualifiedName)) {
                    constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.COLOR_INT_MARKER_TYPE)), constraint);
                } else if (ResourceEvaluator.PX_ANNOTATION.isEquals(qualifiedName) || ResourceEvaluator.DIMENSION_ANNOTATION.isEquals(qualifiedName)) {
                    constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.DIMENSION_MARKER_TYPE)), constraint);
                } else if (qualifiedName.endsWith("Res") && (resourceType = ResourceTypeCompletionContributor.getResourceTypeFromAnnotation(qualifiedName)) != null) {
                    if (resourceTypes == null) {
                        resourceTypes = new ArrayList<ResourceType>();
                    }
                    resourceTypes.add(resourceType);
                }
            }
            if (constraint != null || (aClass = annotation.resolveAnnotationType()) == null) continue;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass)) continue;
            constraint = ResourceTypeCompletionContributor.getAllowedValues((PsiModifierListOwner)aClass, type, (Set<PsiClass>)visited);
        }
        if (resourceTypes != null) {
            constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(resourceTypes), constraint);
        }
        return constraint;
    }

    @Nullable
    private static Constraints merge(@Nullable Constraints head, @Nullable Constraints tail) {
        if (head != null) {
            if (tail != null) {
                head.next = tail;
                if (tail instanceof AllowedValues) {
                    head.next = tail.next;
                    tail.next = head;
                    head = tail;
                }
            }
            return head;
        }
        return tail;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(4);
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)true, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiAnnotationArray == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    @Nullable
    private static Constraints getAllowedValuesFromTypedef(@NotNull PsiType type, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        boolean isString;
        if (type == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(6);
        }
        if (magic == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(8);
        }
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).getComponentType();
        } else if (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        boolean isInt = TypeConversionUtil.getTypeRank((PsiType)type) <= 5;
        boolean bl = isString = !isInt && type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())));
        if (isInt || isString) {
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = isInt ? (orValue = magic.findAttributeValue("flag")) instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue()) : false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred);
        }
        return null;
    }

    private static boolean same(@Nullable PsiElement e1, @Nullable PsiElement e2, @NotNull PsiManager manager) {
        if (manager == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(9);
        }
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return ResourceTypeCompletionContributor.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    @Nullable
    public static ResourceType getResourceTypeFromAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ResourceTypeCompletionContributor.$$$reportNull$$$0(10);
        }
        String resourceTypeName = qualifiedName.startsWith(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName()) ? Character.toLowerCase(qualifiedName.charAt(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName().length())) + qualifiedName.substring(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName().length() + 1, qualifiedName.length() - "Res".length()) : Character.toLowerCase(qualifiedName.charAt(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length())) + qualifiedName.substring(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length() + 1, qualifiedName.length() - "Res".length());
        return ResourceType.fromClassName((String)resourceTypeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/ResourceTypeCompletionContributor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magic";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeCompletionContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedValuesFromTypedef";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "same";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypeFromAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ResourceTypeAllowedValues
    extends Constraints {
        @NotNull
        final List<ResourceType> types;

        public ResourceTypeAllowedValues(@NotNull List<ResourceType> types) {
            if (types == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(0);
            }
            this.types = types;
        }

        public boolean isTypeAllowed(@NotNull ResourceType type) {
            if (type == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(1);
            }
            return this.isTypeAllowed(type.getName());
        }

        public boolean isTypeAllowed(@NotNull String typeName) {
            if (typeName == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(2);
            }
            for (ResourceType type : this.types) {
                if (!type.getName().equals(typeName) && (type != ResourceType.DRAWABLE || !ResourceType.COLOR.getName().equals(typeName) && !ResourceType.MIPMAP.getName().equals(typeName))) continue;
                return true;
            }
            return false;
        }

        public boolean isCompatibleWith(@NotNull ResourceTypeAllowedValues other) {
            if (other == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(3);
            }
            for (ResourceType type : other.types) {
                if (!this.isTypeAllowed(type)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeCompletionContributor$ResourceTypeAllowedValues";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTypeAllowed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCompatibleWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class AllowedValues
    extends Constraints {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred) {
            if (values == null) {
                AllowedValues.$$$reportNull$$$0(0);
            }
            this.values = values;
            this.canBeOred = canBeOred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value2 : v1) {
                for (PsiAnnotationMemberValue value22 : v2) {
                    if (!ResourceTypeCompletionContributor.same((PsiElement)value2, (PsiElement)value22, value2.getManager())) continue;
                    v2.remove(value22);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result2 = Arrays.hashCode(this.values);
            result2 = 31 * result2 + (this.canBeOred ? 1 : 0);
            return result2;
        }

        @Override
        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (other == null) {
                AllowedValues.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                AllowedValues.$$$reportNull$$$0(2);
            }
            if (!(other instanceof AllowedValues)) {
                return false;
            }
            AllowedValues o = (AllowedValues)other;
            for (PsiAnnotationMemberValue value2 : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : o.values) {
                    if (!ResourceTypeCompletionContributor.same((PsiElement)value2, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeCompletionContributor$AllowedValues";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSubsetOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Constraints {
        @Nullable
        public Constraints next;

        Constraints() {
        }

        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (other == null) {
                Constraints.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                Constraints.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "other";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "manager";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/inspections/ResourceTypeCompletionContributor$Constraints";
            objectArray[2] = "isSubsetOf";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

