/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import org.jetbrains.android.refactoring.AndroidInlineLayoutProcessor;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInlineLayoutDialog
extends InlineOptionsDialog {
    private final XmlFile myLayoutFile;
    private final XmlTag myLayoutRootTag;
    private final PsiElement myUsageElement;

    public AndroidInlineLayoutDialog(@NotNull Project project, @NotNull XmlFile layoutFile, @NotNull XmlTag layoutRootTag, @Nullable PsiElement usageElement) {
        if (project == null) {
            AndroidInlineLayoutDialog.$$$reportNull$$$0(0);
        }
        if (layoutFile == null) {
            AndroidInlineLayoutDialog.$$$reportNull$$$0(1);
        }
        if (layoutRootTag == null) {
            AndroidInlineLayoutDialog.$$$reportNull$$$0(2);
        }
        super(project, true, (PsiElement)layoutFile);
        this.myLayoutFile = layoutFile;
        this.myLayoutRootTag = layoutRootTag;
        this.myUsageElement = usageElement;
        this.myInvokedOnReference = usageElement != null;
        this.setTitle(AndroidBundle.message("android.inline.layout.title", new Object[0]));
        this.init();
    }

    protected String getNameLabelText() {
        return "Layout file '" + this.myLayoutFile.getName() + "'";
    }

    protected String getBorderTitle() {
        return "Inline";
    }

    protected String getInlineAllText() {
        return AndroidBundle.message("android.inline.file.inline.all.text", new Object[0]);
    }

    protected String getInlineThisText() {
        return AndroidBundle.message("android.inline.file.inline.this.text", new Object[0]);
    }

    protected boolean isInlineThis() {
        return this.myUsageElement != null;
    }

    protected void doAction() {
        PsiElement usageElement = this.isInlineThisOnly() ? this.myUsageElement : null;
        this.invokeRefactoring(new AndroidInlineLayoutProcessor(this.myProject, this.myLayoutFile, this.myLayoutRootTag, usageElement, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "layoutFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "layoutRootTag";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/refactoring/AndroidInlineLayoutDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

