/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.builder.model.TestOptions;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessor;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessorKt;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessorKt$sam$org_jetbrains_android_refactoring_MigrateToAppCompatUsageInfo_TriFunction$0;
import org.jetbrains.android.refactoring.MigrateToAndroidxUsageViewDescriptor;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.KotlinOptimizeImportsRefactoringHelper;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u000256BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\"\b\u0002\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0004\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001eJ6\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u001e\u0010!\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0#\u0012\u0004\u0012\u00020$0\"H\u0002J\b\u0010%\u001a\u00020\u001bH\u0002J\u001b\u0010&\u001a\u00020'2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020'H\u0014J\b\u0010*\u001a\u00020\tH\u0014J\b\u0010+\u001a\u00020\u001bH\u0014J\u001d\u0010,\u001a\u00020\u001b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010-\u001a\u00020\u000b2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170/H\u0014J\u001b\u00100\u001a\u00020\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0014\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u000bH\u0014J\u0010\u00103\u001a\u0002042\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "migrationMap", "", "Lorg/jetbrains/android/refactoring/AppCompatMigrationEntry;", "versionProvider", "Lkotlin/Function3;", "", "callSyncAfterMigration", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lkotlin/jvm/functions/Function3;Z)V", "elements", "", "Lcom/intellij/psi/PsiElement;", "getProject", "()Lcom/intellij/openapi/project/Project;", "refsToShorten", "Lcom/intellij/psi/SmartPsiElementPointer;", "createUsageViewDescriptor", "Lorg/jetbrains/android/refactoring/MigrateToAndroidxUsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lorg/jetbrains/android/refactoring/MigrateToAndroidxUsageViewDescriptor;", "execute", "", "([Lcom/intellij/usageView/UsageInfo;)V", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "findUsagesInBuildFiles", "Lorg/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo;", "gradleDependencyEntries", "", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/android/refactoring/AppCompatMigrationEntry$GradleMigrationEntry;", "finishFindMigration", "getAfterData", "Lcom/intellij/refactoring/listeners/RefactoringEventData;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/refactoring/listeners/RefactoringEventData;", "getBeforeData", "getCommandName", "performPsiSpoilingRefactoring", "performRefactoring", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "refreshElements", "([Lcom/intellij/psi/PsiElement;)V", "skipNonCodeUsages", "startMigration", "Lcom/intellij/psi/PsiMigration;", "KotlinFileWrapper", "UsageAccumulator", "intellij.android.core"})
public class MigrateToAndroidxProcessor
extends BaseRefactoringProcessor {
    private final List<PsiElement> elements;
    private final List<SmartPsiElementPointer<PsiElement>> refsToShorten;
    private final Function3<String, String, String, String> versionProvider;
    @NotNull
    private final Project project;
    private final List<AppCompatMigrationEntry> migrationMap;
    private final boolean callSyncAfterMigration;

    @NotNull
    protected final MigrateToAndroidxUsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        Collection $this$toTypedArray$iv = this.elements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        if (psiElementArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new MigrateToAndroidxUsageViewDescriptor(psiElementArray);
    }

    private final PsiMigration startMigration(Project project) {
        this.finishFindMigration();
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)project).startMigration();
        Intrinsics.checkNotNullExpressionValue((Object)psiMigration, (String)"PsiMigrationManager.getI\u2026project).startMigration()");
        PsiMigration migration = psiMigration;
        for (AppCompatMigrationEntry entry : this.migrationMap) {
            AppCompatMigrationEntry appCompatMigrationEntry = entry;
            if (appCompatMigrationEntry instanceof AppCompatMigrationEntry.PackageMigrationEntry) {
                String string = ((AppCompatMigrationEntry.PackageMigrationEntry)entry).myNewName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.myNewName");
                AndroidRefactoringUtil.findOrCreatePackage(project, migration, string);
                String string2 = ((AppCompatMigrationEntry.PackageMigrationEntry)entry).myOldName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.myOldName");
                AndroidRefactoringUtil.findOrCreatePackage(project, migration, string2);
                continue;
            }
            if (!(appCompatMigrationEntry instanceof AppCompatMigrationEntry.ClassMigrationEntry)) continue;
            String string = ((AppCompatMigrationEntry.ClassMigrationEntry)entry).myNewName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.myNewName");
            AndroidRefactoringUtil.findOrCreateClass$default(project, migration, string, null, 8, null);
            String string3 = ((AppCompatMigrationEntry.ClassMigrationEntry)entry).myOldName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.myOldName");
            AndroidRefactoringUtil.findOrCreateClass$default(project, migration, string3, null, 8, null);
        }
        return migration;
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(@NotNull UsageInfo[] usages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        UsageInfo[] $this$map$iv = usages;
        boolean $i$f$map = false;
        UsageInfo[] usageInfoArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        int n = ((void)var8_7).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = var8_7[j];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void var15_14 = it.getFile() instanceof KtFile ? (UsageInfo)new KotlinFileWrapper((UsageInfo)it) : it;
            collection2.add(var15_14);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray2 = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        UsageInfo[] wrapped = usageInfoArray2;
        super.execute(wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        Object object;
        Object object2;
        UsageAccumulator usageAccumulator = new UsageAccumulator();
        Function1 generatedCodeUsages2 = (Function1)new Function1<UsageInfo, Boolean>(this){
            final /* synthetic */ MigrateToAndroidxProcessor this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull UsageInfo usage) {
                Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
                VirtualFile virtualFile = usage.getVirtualFile();
                if (virtualFile == null) return true;
                VirtualFile virtualFile2 = virtualFile;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile2;
                boolean bl3 = false;
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)it, (Project)this.this$0.getProject())) return false;
                return true;
            }
            {
                this.this$0 = migrateToAndroidxProcessor;
                super(1);
            }
        };
        try {
            boolean bl = false;
            Map gradleDependencyEntries = new LinkedHashMap();
            for (AppCompatMigrationEntry entry : this.migrationMap) {
                switch (entry.getType()) {
                    case 1: {
                        UsageInfo it;
                        Iterable $this$mapTo$iv$iv;
                        Iterable $this$filterTo$iv$iv;
                        AppCompatMigrationEntry appCompatMigrationEntry = entry;
                        if (appCompatMigrationEntry == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.ClassMigrationEntry");
                        }
                        AppCompatMigrationEntry.ClassMigrationEntry clsEntry = (AppCompatMigrationEntry.ClassMigrationEntry)appCompatMigrationEntry;
                        List<UsageInfo> classUsages = MigrateToAppCompatUtil.findClassUsages(this.project, clsEntry.myOldName);
                        boolean bl2 = false;
                        List infos = new ArrayList();
                        List<UsageInfo> list = classUsages;
                        Intrinsics.checkNotNullExpressionValue(list, (String)"classUsages");
                        Iterable $this$filter$iv = list;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            if (!((Boolean)generatedCodeUsages2.invoke(element$iv$iv)).booleanValue()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$map$iv22 = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv22;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            UsageInfo usageInfo = (UsageInfo)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl3 = false;
                            object = new MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo(it, clsEntry);
                            object2.add(object);
                        }
                        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)infos);
                        UsageAccumulator.addAll$default(usageAccumulator, infos, false, 2, null);
                        break;
                    }
                    case 9: {
                        UsageInfo it;
                        Iterable $this$filterTo$iv$iv;
                        AppCompatMigrationEntry appCompatMigrationEntry = entry;
                        if (appCompatMigrationEntry == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.PackageMigrationEntry");
                        }
                        AppCompatMigrationEntry.PackageMigrationEntry pkgEntry = (AppCompatMigrationEntry.PackageMigrationEntry)appCompatMigrationEntry;
                        List<UsageInfo> packageUsages = MigrateToAppCompatUtil.findPackageUsages(this.project, pkgEntry.myOldName);
                        boolean $this$map$iv22 = false;
                        List infos = new ArrayList();
                        List<UsageInfo> list = packageUsages;
                        Intrinsics.checkNotNullExpressionValue(list, (String)"packageUsages");
                        Iterable $this$filter$iv = list;
                        boolean $i$f$filter = false;
                        Iterable $this$mapTo$iv$iv = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            if (!((Boolean)generatedCodeUsages2.invoke(element$iv$iv)).booleanValue()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$map$iv22 = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv22;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (UsageInfo)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl4 = false;
                            object = new MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo(it, pkgEntry);
                            object2.add(object);
                        }
                        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)infos);
                        UsageAccumulator.addAll$default(usageAccumulator, infos, false, 2, null);
                        break;
                    }
                    case 10: {
                        AppCompatMigrationEntry appCompatMigrationEntry = entry;
                        if (appCompatMigrationEntry == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.GradleDependencyMigrationEntry");
                        }
                        AppCompatMigrationEntry.GradleMigrationEntry migrationEntry = (AppCompatMigrationEntry.GradleDependencyMigrationEntry)appCompatMigrationEntry;
                        Pair<String, String> pair = ((AppCompatMigrationEntry.GradleDependencyMigrationEntry)migrationEntry).compactKey();
                        Intrinsics.checkNotNullExpressionValue(pair, (String)"migrationEntry.compactKey()");
                        gradleDependencyEntries.put(pair, migrationEntry);
                        break;
                    }
                    case 11: {
                        AppCompatMigrationEntry appCompatMigrationEntry = entry;
                        if (appCompatMigrationEntry == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry");
                        }
                        AppCompatMigrationEntry.GradleMigrationEntry migrationEntry = (AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry)appCompatMigrationEntry;
                        Pair<String, String> pair = ((AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry)migrationEntry).compactKey();
                        Intrinsics.checkNotNullExpressionValue(pair, (String)"migrationEntry.compactKey()");
                        gradleDependencyEntries.put(pair, migrationEntry);
                        break;
                    }
                }
            }
            UsageAccumulator.addAll$default(usageAccumulator, this.findUsagesInBuildFiles(this.project, gradleDependencyEntries), false, 2, null);
        }
        catch (Throwable gradleDependencyEntries) {
            Application application = ApplicationManager.getApplication();
            Runnable runnable2 = new Runnable(this){
                final /* synthetic */ MigrateToAndroidxProcessor this$0;

                public final void run() {
                    WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(this){
                        final /* synthetic */ findUsages.3 this$0;

                        public final void run() {
                            MigrateToAndroidxProcessor migrateToAndroidxProcessor = this.this$0.this$0;
                            boolean bl = false;
                            boolean bl2 = false;
                            MigrateToAndroidxProcessor $this$run = migrateToAndroidxProcessor;
                            boolean bl3 = false;
                            MigrateToAndroidxProcessor.access$finishFindMigration($this$run);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                }
                {
                    this.this$0 = migrateToAndroidxProcessor;
                }
            };
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            application.invokeLater(runnable2, project.getDisposed());
            throw gradleDependencyEntries;
        }
        Application application = ApplicationManager.getApplication();
        Runnable runnable3 = new /* invalid duplicate definition of identical inner class */;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        application.invokeLater(runnable3, project.getDisposed());
        Logger $this$debug$iv = MigrateToAndroidxProcessorKt.access$getLog$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object2 = $this$debug$iv;
            boolean bl = false;
            object = CollectionsKt.joinToString$default((Iterable)usageAccumulator.getUsageInfos(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            object2.debug(object, (Throwable)e$iv);
        }
        Collection $this$toTypedArray$iv = usageAccumulator.getUsageInfos();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return usageInfoArray;
    }

    /*
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        PsiMigration migration = this.startMigration(this.project);
        this.refsToShorten.clear();
        try {
            PsiElement it;
            Object $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            void $this$filterIsInstanceTo$iv$iv22322;
            KotlinFileWrapper kotlinFileWrapper;
            boolean bl;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.project);
            MigrateToAndroidxUtil.setAndroidxProperties$default(this.project, null, 1, null);
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            Object $this$map$iv = usages;
            boolean $i$f$map = false;
            UsageInfo[] usageInfoArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((UsageInfo[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv;
            int n = ((void)iterator).length;
            for (int j = 0; j < n; ++j) {
                KotlinFileWrapper kotlinFileWrapper2;
                void it2;
                void item$iv$iv;
                void var13_31 = item$iv$iv = iterator[j];
                collection2 = destination$iv$iv;
                bl = false;
                Object v0 = it2;
                if (!(v0 instanceof KotlinFileWrapper)) {
                    v0 = null;
                }
                if ((kotlinFileWrapper2 = (KotlinFileWrapper)v0) == null || (kotlinFileWrapper2 = kotlinFileWrapper2.getDelegate()) == null) {
                    kotlinFileWrapper2 = it2;
                }
                kotlinFileWrapper = kotlinFileWrapper2;
                collection2.add(kotlinFileWrapper);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object t : $this$filterIsInstanceTo$iv$iv22322) {
                if (!(t instanceof MigrateToAppCompatUsageInfo)) continue;
                destination$iv$iv.add(t);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            boolean $this$filterIsInstanceTo$iv$iv22322 = false;
            Iterable $this$mapNotNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    int value2;
                    boolean bl = false;
                    MigrateToAppCompatUsageInfo it = (MigrateToAppCompatUsageInfo)((Object)b);
                    boolean bl2 = false;
                    MigrateToAppCompatUsageInfo migrateToAppCompatUsageInfo = it;
                    int n = migrateToAppCompatUsageInfo instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo ? 1000000 : (value2 = migrateToAppCompatUsageInfo instanceof MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo ? 1000 + ((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)it).mapEntry.myOldName.length() : 0);
                    if (MigrateToAndroidxProcessorKt.access$isImportElement(it.getElement())) {
                        value2 += 1000;
                    }
                    it = (MigrateToAppCompatUsageInfo)((Object)a);
                    Comparable comparable = Integer.valueOf(value2);
                    bl2 = false;
                    migrateToAppCompatUsageInfo = it;
                    int n2 = migrateToAppCompatUsageInfo instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo ? 1000000 : (value2 = migrateToAppCompatUsageInfo instanceof MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo ? 1000 + ((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)it).mapEntry.myOldName.length() : 0);
                    if (MigrateToAndroidxProcessorKt.access$isImportElement(it.getElement())) {
                        value2 += 1000;
                    }
                    Integer n3 = value2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
                }
            });
            boolean $i$f$mapNotNull = false;
            Iterable $this$filterIsInstanceTo$iv$iv22322 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiElement psiElement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl = false;
                MigrateToAppCompatUsageInfo it3 = (MigrateToAppCompatUsageInfo)((Object)element$iv$iv);
                boolean bl22 = false;
                if (it3.applyChange(migration) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PsiElement it$iv$iv = psiElement;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (PsiElement)t;
                boolean bl5 = false;
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                if (!psiElement.isValid()) continue;
                destination$iv$iv.add(t);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                it = (PsiElement)t;
                collection2 = destination$iv$iv;
                boolean bl6 = false;
                kotlinFileWrapper = smartPointerManager.createSmartPsiElementPointer(it);
                collection2.add(kotlinFileWrapper);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                SmartPsiElementPointer it4 = (SmartPsiElementPointer)element$iv;
                boolean bl7 = false;
                SmartPsiElementPointer smartPsiElementPointer = it4;
                Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"it");
                this.refsToShorten.add((SmartPsiElementPointer<PsiElement>)smartPsiElementPointer);
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.project, (IncorrectOperationException)e);
        }
        if (this.callSyncAfterMigration) {
            boolean bl;
            block13: {
                UsageInfo[] $this$any$iv = usages;
                boolean $i$f$any = false;
                UsageInfo[] usageInfoArray = $this$any$iv;
                int n = usageInfoArray.length;
                for (int j = 0; j < n; ++j) {
                    UsageInfo element$iv;
                    UsageInfo it = element$iv = usageInfoArray[j];
                    boolean bl8 = false;
                    if (!(it instanceof MigrateToAppCompatUsageInfo.GradleUsageInfo)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
            if (bl) {
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                AndroidRefactoringUtil.syncBeforeFinishingRefactoring(project, GradleSyncStats.Trigger.TRIGGER_REFACTOR_MIGRATE_TO_ANDROIDX);
            }
        }
    }

    protected void performPsiSpoilingRefactoring() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (SmartPsiElementPointer<PsiElement> pointer : this.refsToShorten) {
            PsiElement element;
            if (pointer.getElement() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"pointer.element ?: continue");
            styleManager.shortenClassReferences(element);
        }
        this.refsToShorten.clear();
        this.finishFindMigration();
    }

    @NotNull
    protected String getCommandName() {
        String string = AndroidBundle.message("android.refactoring.migrateto.androidx", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AndroidBundle.message(\"a\u2026ring.migrateto.androidx\")");
        return string;
    }

    @NotNull
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        boolean bl2 = false;
        RefactoringEventData $this$apply = refactoringEventData;
        boolean bl3 = false;
        $this$apply.addElements((Collection)this.elements);
        return refactoringEventData;
    }

    @NotNull
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        RefactoringEventData refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        boolean bl2 = false;
        RefactoringEventData $this$apply = refactoringEventData;
        boolean bl3 = false;
        $this$apply.addElements((Collection)this.elements);
        return refactoringEventData;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    /*
     * WARNING - void declaration
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] filtered;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        Object object = refUsages.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"refUsages.get()");
        Object[] $this$filter$iv = (Object[])object;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            UsageInfo it = (UsageInfo)element$iv$iv;
            boolean bl = false;
            UsageInfo usageInfo = it;
            if (!(usageInfo instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo ? Intrinsics.areEqual((Object)((MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)it).mapEntry.myOldName, (Object)((MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)it).mapEntry.myNewName) ^ true : (usageInfo instanceof MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo ? Intrinsics.areEqual((Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)it).mapEntry.myOldName, (Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)it).mapEntry.myNewName) ^ true : true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        UsageInfo[] usageInfoArray2 = filtered = usageInfoArray;
        boolean bl = false;
        if (usageInfoArray2.length == 0) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                Messages.showInfoMessage((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"migration.no.usages.found.in.the.project", (Object[])new Object[0]), (String)AndroidBundle.message("android.refactoring.migrateto.androidx", new Object[0]));
            }
            return false;
        }
        refUsages.set((Object)filtered);
        this.setPreviewUsages(true);
        return true;
    }

    private final void finishFindMigration() {
        block0: {
            PsiMigrationManager psiMigrationManager = PsiMigrationManager.getInstance((Project)this.project);
            if (psiMigrationManager == null || (psiMigrationManager = psiMigrationManager.getCurrentMigration()) == null) break block0;
            psiMigrationManager.finish();
        }
    }

    private final List<MigrateToAppCompatUsageInfo> findUsagesInBuildFiles(Project project, Map<Pair<String, String>, ? extends AppCompatMigrationEntry.GradleMigrationEntry> gradleDependencyEntries) {
        boolean bl = false;
        List gradleUsages = new ArrayList();
        if (gradleDependencyEntries.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"ProjectBuildModel.get(project)");
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module module : moduleManager.getModules()) {
            ResolvedPropertyModel executionProperty;
            AndroidModel androidBlock;
            PsiElement psiElement;
            DependenciesModel dependencies2;
            GradleBuildModel gradleBuildModel;
            if (projectBuildModel3.getModuleBuildModel(module) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel, (String)"projectBuildModel.getMod\u2026Model(module) ?: continue");
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel.dependencies(), (String)"gradleBuildModel.dependencies()");
            for (DependencyModel dep : dependencies2.all()) {
                GradleCoordinate migrationEntryCoordinates;
                AppCompatMigrationEntry.GradleMigrationEntry entry;
                Pair key;
                GradleCoordinate gc;
                String compactDependencyNotation;
                if (!(dep instanceof ArtifactDependencyModel)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((ArtifactDependencyModel)dep).compactNotation(), (String)"dep.compactNotation()");
                ResolvedPropertyModel resolvedPropertyModel = ((ArtifactDependencyModel)dep).completeModel();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedPropertyModel, (String)"dep.completeModel()");
                GradlePropertyModel gradlePropertyModel = resolvedPropertyModel.getResultModel();
                Intrinsics.checkNotNullExpressionValue((Object)gradlePropertyModel, (String)"dep.completeModel().resultModel");
                if (gradlePropertyModel.getExpressionPsiElement() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"dep.completeModel().resu\u2026ionPsiElement ?: continue");
                if (GradleCoordinate.parseCoordinateString((String)compactDependencyNotation) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)Pair.create((Object)gc.getGroupId(), (Object)gc.getArtifactId()), (String)"Pair.create(gc.groupId, gc.artifactId)");
                if (gradleDependencyEntries.get(key) == null) {
                    continue;
                }
                if (GradleCoordinate.parseCoordinateString((String)entry.toCompactNotation(entry.getNewBaseVersion())) == null) {
                    continue;
                }
                if (gc.isSameArtifact(migrationEntryCoordinates) && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(migrationEntryCoordinates, gc) <= 0) continue;
                ArtifactDependencyModel artifactDependencyModel = (ArtifactDependencyModel)dep;
                Object object = this.versionProvider;
                if (object != null) {
                    Function3<String, String, String, String> function3 = object;
                    object = new MigrateToAndroidxProcessorKt$sam$org_jetbrains_android_refactoring_MigrateToAppCompatUsageInfo_TriFunction$0(function3);
                }
                gradleUsages.add(new MigrateToAppCompatUsageInfo.GradleDependencyUsageInfo(psiElement, projectBuildModel3, artifactDependencyModel, entry, (MigrateToAppCompatUsageInfo.TriFunction)object));
            }
            Function3<GradlePropertyModel, String, String, Unit> $fun$addStringUsage$1 = new Function3<GradlePropertyModel, String, String, Unit>(gradleUsages, gradleBuildModel){
                final /* synthetic */ List $gradleUsages;
                final /* synthetic */ GradleBuildModel $gradleBuildModel;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull GradlePropertyModel model2, @NotNull String oldString, @NotNull String newString) {
                    Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                    Intrinsics.checkNotNullParameter((Object)oldString, (String)"oldString");
                    Intrinsics.checkNotNullParameter((Object)newString, (String)"newString");
                    PsiElement psiElement = model2.getPsiElement();
                    if (psiElement == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"model.psiElement ?: return");
                    PsiElement psiElement2 = psiElement;
                    if (Intrinsics.areEqual((Object)((String)model2.getValue(GradlePropertyModel.STRING_TYPE)), (Object)oldString)) {
                        model2.setValue((Object)newString);
                        this.$gradleUsages.add(new MigrateToAppCompatUsageInfo.GradleStringUsageInfo(psiElement2, newString, this.$gradleBuildModel));
                    } else {
                        void $this$filterTo$iv$iv;
                        Collection collection2 = PsiTreeUtil.findChildrenOfType((PsiElement)psiElement2, PsiElement.class);
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"PsiTreeUtil.findChildren\u2026, PsiElement::class.java)");
                        Iterable $this$filter$iv = collection2;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            PsiElement it = (PsiElement)element$iv$iv;
                            boolean bl = false;
                            PsiElement psiElement3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it");
                            if (!Intrinsics.areEqual((Object)psiElement3.getText(), (Object)oldString)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        for (PsiElement literal : (List)destination$iv$iv) {
                            this.$gradleUsages.add(new MigrateToAppCompatUsageInfo.GradleStringUsageInfo(literal, newString, this.$gradleBuildModel));
                        }
                    }
                }
                {
                    this.$gradleUsages = list;
                    this.$gradleBuildModel = gradleBuildModel;
                    super(3);
                }
            };
            if (gradleBuildModel.android() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)androidBlock, (String)"gradleBuildModel.android() ?: continue");
            List list = androidBlock.productFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"androidBlock.productFlavors()");
            psiElement = CollectionsKt.plus((Collection)list, (Object)androidBlock.defaultConfig()).iterator();
            while (psiElement.hasNext()) {
                String runnerName;
                GradlePropertyModel runnerModel;
                ProductFlavorModel flavorBlock = (ProductFlavorModel)psiElement.next();
                ResolvedPropertyModel resolvedPropertyModel = flavorBlock.testInstrumentationRunner();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedPropertyModel, (String)"flavorBlock.testInstrumentationRunner()");
                Intrinsics.checkNotNullExpressionValue((Object)resolvedPropertyModel.getResultModel(), (String)"flavorBlock.testInstrume\u2026ationRunner().resultModel");
                if ((String)runnerModel.getValue(GradlePropertyModel.STRING_TYPE) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)runnerName, (String)"runnerModel.getValue(Gra\u2026.STRING_TYPE) ?: continue");
                String newRunnerName = AndroidxNameUtils.getNewName((String)runnerName);
                if (!(Intrinsics.areEqual((Object)newRunnerName, (Object)runnerName) ^ true)) continue;
                String string = newRunnerName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newRunnerName");
                $fun$addStringUsage$1.invoke(runnerModel, runnerName, string);
            }
            Intrinsics.checkNotNullExpressionValue((Object)androidBlock.testOptions().execution(), (String)"androidBlock.testOptions().execution()");
            String executionValue = (String)executionProperty.getValue(GradlePropertyModel.STRING_TYPE);
            if (!StringsKt.equals((String)executionValue, (String)TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.name(), (boolean)true)) continue;
            GradlePropertyModel gradlePropertyModel = (GradlePropertyModel)executionProperty;
            String string = executionValue;
            Intrinsics.checkNotNull((Object)string);
            $fun$addStringUsage$1.invoke(gradlePropertyModel, string, TestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR.name());
        }
        Collection collection2 = gradleUsages;
        int n = 0;
        if (!collection2.isEmpty()) {
            Function1<RepositoriesModel, Unit> function1 = new Function1<RepositoriesModel, Unit>(gradleUsages, projectBuildModel3){
                final /* synthetic */ List $gradleUsages;
                final /* synthetic */ ProjectBuildModel $projectBuildModel;

                public final void invoke(@NotNull RepositoriesModel repositoriesModel) {
                    PsiElement repositoriesModelPsiElement;
                    Intrinsics.checkNotNullParameter((Object)repositoriesModel, (String)"repositoriesModel");
                    if (!repositoriesModel.hasGoogleMavenRepository() && (repositoriesModelPsiElement = repositoriesModel.getPsiElement()) != null) {
                        this.$gradleUsages.add(new MigrateToAppCompatUsageInfo.AddGoogleRepositoryUsageInfo(this.$projectBuildModel, repositoriesModel, repositoriesModelPsiElement));
                    }
                }
                {
                    this.$gradleUsages = list;
                    this.$projectBuildModel = projectBuildModel2;
                    super(1);
                }
            };
            for (VirtualFile file : AddGoogleMavenRepositoryHyperlink.getBuildFileForPlugin(project)) {
                GradleBuildModel gradleBuildModel;
                Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel3.getModuleBuildModel(file), (String)"projectBuildModel.getModuleBuildModel(file)");
                RepositoriesModel repositoriesModel = gradleBuildModel.buildscript().repositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"gradleBuildModel.buildscript().repositories()");
                function1.invoke(repositoriesModel);
                RepositoriesModel repositoriesModel2 = gradleBuildModel.repositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel2, (String)"gradleBuildModel.repositories()");
                function1.invoke(repositoriesModel2);
            }
        }
        return gradleUsages;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public MigrateToAndroidxProcessor(@NotNull Project project, @NotNull List<? extends AppCompatMigrationEntry> migrationMap, @Nullable Function3<? super String, ? super String, ? super String, String> versionProvider2, boolean callSyncAfterMigration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(migrationMap, (String)"migrationMap");
        super(project);
        this.project = project;
        this.migrationMap = migrationMap;
        this.callSyncAfterMigration = callSyncAfterMigration;
        this.elements = new ArrayList();
        this.refsToShorten = new ArrayList();
        Function3 function3 = versionProvider2;
        if (function3 == null) {
            function3 = versionProvider.1.INSTANCE;
        }
        this.versionProvider = function3;
    }

    public /* synthetic */ MigrateToAndroidxProcessor(Project project, List list, Function3 function3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function3 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(project, list, (Function3<? super String, ? super String, ? super String, String>)function3, bl);
    }

    public static final /* synthetic */ void access$finishFindMigration(MigrateToAndroidxProcessor $this) {
        $this.finishFindMigration();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxProcessor$KotlinFileWrapper;", "Lcom/intellij/usageView/UsageInfo;", "delegate", "(Lcom/intellij/usageView/UsageInfo;)V", "getDelegate", "()Lcom/intellij/usageView/UsageInfo;", "getFile", "Lcom/intellij/psi/PsiFile;", "isKotlinOptimizerCall", "", "intellij.android.core"})
    private static final class KotlinFileWrapper
    extends UsageInfo {
        @NotNull
        private final UsageInfo delegate;

        /*
         * WARNING - void declaration
         */
        private final boolean isKotlinOptimizerCall() {
            boolean bl;
            block4: {
                void $this$mapTo$iv$iv;
                Thread thread = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
                Object[] objectArray = thread.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Thread.currentThread().stackTrace");
                Iterable $this$map$iv = ArraysKt.take((Object[])objectArray, (int)5);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    void v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    String string = v2.getClassName();
                    collection2.add(string);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(KotlinOptimizeImportsRefactoringHelper.class).getQualifiedName(), (Object)it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Nullable
        public PsiFile getFile() {
            return this.isKotlinOptimizerCall() ? null : super.getFile();
        }

        @NotNull
        public final UsageInfo getDelegate() {
            return this.delegate;
        }

        public KotlinFileWrapper(@NotNull UsageInfo delegate2) {
            Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
            super(delegate2.getSmartPointer(), delegate2.getPsiFileRange(), delegate2.isDynamicUsage(), delegate2.isNonCodeUsage);
            this.delegate = delegate2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J&\u0010\u0016\u001a\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxProcessor$UsageAccumulator;", "", "()V", "fileToRangeMap", "", "Lcom/intellij/psi/PsiFile;", "Lcom/google/common/collect/RangeMap;", "", "Lcom/intellij/usageView/UsageInfo;", "usageInfos", "", "getUsageInfos", "()Ljava/util/List;", "addAll", "", "infos", "", "checkOverlappingUsages", "", "getInfoUsageRange", "Lcom/intellij/openapi/util/Segment;", "info", "hasOverlappingUsage", "rangeMap", "segment", "intellij.android.core"})
    public static final class UsageAccumulator {
        @NotNull
        private final List<UsageInfo> usageInfos;
        private final Map<PsiFile, RangeMap<Integer, UsageInfo>> fileToRangeMap;

        @NotNull
        public final List<UsageInfo> getUsageInfos() {
            return this.usageInfos;
        }

        private final Segment getInfoUsageRange(UsageInfo info) {
            PsiElement element = info.getElement();
            if (info instanceof MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo && !(element instanceof PsiPackage)) {
                PsiElement psiElement;
                PsiElement psiElement2 = element;
                if (Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getText() : null), (Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)info).mapEntry.myOldName) ^ true && Intrinsics.areEqual((Object)((psiElement = element) != null && (psiElement = psiElement.getParent()) != null ? psiElement.getText() : null), (Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)info).mapEntry.myOldName)) {
                    PsiElement psiElement3 = element.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"element.parent");
                    return (Segment)psiElement3.getTextRange();
                }
            }
            SmartPsiElementPointer smartPsiElementPointer = info.getSmartPointer();
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"info.smartPointer");
            return smartPsiElementPointer.getPsiRange();
        }

        private final boolean hasOverlappingUsage(RangeMap<Integer, UsageInfo> rangeMap, Segment segment) {
            Segment segment2 = segment;
            if (segment2 == null) {
                return false;
            }
            int startOffset = segment2.getStartOffset();
            return rangeMap.get((Comparable)Integer.valueOf(startOffset)) != null;
        }

        public final void addAll(@NotNull List<? extends UsageInfo> infos, boolean checkOverlappingUsages) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            for (UsageInfo usageInfo : infos) {
                PsiFile containingFile;
                SmartPsiElementPointer smartPsiElementPointer = usageInfo.getSmartPointer();
                Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"info.smartPointer");
                if (smartPsiElementPointer.getContainingFile() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)containingFile, (String)"info.smartPointer.containingFile ?: continue");
                TreeRangeMap treeRangeMap = TreeRangeMap.create();
                Intrinsics.checkNotNullExpressionValue((Object)treeRangeMap, (String)"TreeRangeMap.create()");
                RangeMap<Integer, UsageInfo> rangeMap = this.fileToRangeMap.getOrDefault(containingFile, (RangeMap<Integer, UsageInfo>)treeRangeMap);
                Segment segment = this.getInfoUsageRange(usageInfo);
                if (checkOverlappingUsages && this.hasOverlappingUsage(rangeMap, segment)) continue;
                if (segment != null) {
                    Segment segment2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Segment it = segment2;
                    boolean bl3 = false;
                    rangeMap.put(Range.closed((Comparable)Integer.valueOf(it.getStartOffset()), (Comparable)Integer.valueOf(it.getEndOffset())), (Object)usageInfo);
                }
                this.fileToRangeMap.put(containingFile, rangeMap);
                this.usageInfos.add(usageInfo);
            }
        }

        public static /* synthetic */ void addAll$default(UsageAccumulator usageAccumulator, List list, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            usageAccumulator.addAll(list, bl);
        }

        public UsageAccumulator() {
            boolean bl = false;
            this.usageInfos = new ArrayList();
            bl = false;
            this.fileToRangeMap = new LinkedHashMap();
        }
    }
}

