/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.lint.detector.api.Lint;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.spellchecker.xml.XmlSpellcheckingStrategy;
import com.intellij.util.Consumer;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.converters.AndroidPackageConverter;
import org.jetbrains.android.dom.converters.AndroidPermissionConverter;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.ConstantFieldConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlSpellcheckingStrategy
extends XmlSpellcheckingStrategy {
    private final MyResourceReferenceTokenizer myResourceReferenceTokenizer = new MyResourceReferenceTokenizer();
    private final Tokenizer<XmlAttributeValue> myAttributeValueRenamingTokenizer = new Tokenizer<XmlAttributeValue>(){

        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            consumer.consumeToken((PsiElement)element, true, (Splitter)TextSplitter.getInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy$1", "tokenize"));
        }
    };
    private static final AaptXmlTextSplitter AAPT_SPLITTER = new AaptXmlTextSplitter();
    private static final Tokenizer<PsiElement> AAPT_TOKENIZER = new TokenizerBase((Splitter)AAPT_SPLITTER);

    public boolean isMyContext(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(0);
        }
        if (!((file = element.getContainingFile()) instanceof XmlFile)) {
            return false;
        }
        return AndroidFacet.getInstance((PsiElement)file) != null || AndroidXmlSpellcheckingStrategy.isLintConfig((XmlFile)file);
    }

    private static boolean isLintConfig(@NotNull XmlFile file) {
        String tagName;
        if (file == null) {
            AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(1);
        }
        if (file.getName().equals("lint.xml")) {
            return true;
        }
        XmlTag tag = file.getRootTag();
        return tag != null && ("lint".equals(tagName = tag.getName()) || "issues".equals(tagName));
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (AndroidXmlSpellcheckingStrategy.isAttributeValueContext(element)) {
            Tokenizer tokenizer = this.getAttributeValueTokenizer(element);
            if (tokenizer == null) {
                AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (AndroidXmlSpellcheckingStrategy.inEnglish(element)) {
            if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
                PsiFile file = element.getContainingFile();
                if (file == null || file.getLanguage() instanceof TemplateLanguage) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(3);
                    }
                    return tokenizer;
                }
                PsiElement injection = InjectedLanguageManager.getInstance((Project)element.getProject()).findInjectedElementAt(element.getContainingFile(), element.getTextOffset());
                if (injection != null) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(4);
                    }
                    return tokenizer;
                }
                Tokenizer<PsiElement> tokenizer = AAPT_TOKENIZER;
                if (tokenizer == null) {
                    AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(5);
                }
                return tokenizer;
            }
            Tokenizer tokenizer = super.getTokenizer(element);
            if (tokenizer == null) {
                AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(6);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(7);
        }
        return tokenizer;
    }

    @NotNull
    public Tokenizer getAttributeValueTokenizer(PsiElement element) {
        GenericAttributeValue domValue;
        String value2;
        assert (element instanceof XmlAttributeValue);
        if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element)) {
            Tokenizer<XmlAttributeValue> tokenizer = this.myAttributeValueRenamingTokenizer;
            if (tokenizer == null) {
                AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(8);
            }
            return tokenizer;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && (value2 = ((XmlAttribute)parent).getValue()) != null && (domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent)) != null) {
            Converter converter = domValue.getConverter();
            if (converter instanceof ResourceReferenceConverter) {
                MyResourceReferenceTokenizer myResourceReferenceTokenizer = this.myResourceReferenceTokenizer;
                if (myResourceReferenceTokenizer == null) {
                    AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(9);
                }
                return myResourceReferenceTokenizer;
            }
            if (converter instanceof ConstantFieldConverter || converter instanceof AndroidPermissionConverter) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(10);
                }
                return tokenizer;
            }
            if (converter instanceof ResourceNameConverter || converter instanceof AndroidPackageConverter) {
                Tokenizer<XmlAttributeValue> tokenizer = this.myAttributeValueRenamingTokenizer;
                if (tokenizer == null) {
                    AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(11);
                }
                return tokenizer;
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(12);
        }
        return tokenizer;
    }

    private static boolean isAttributeValueContext(@NotNull PsiElement element) {
        if (element == null) {
            AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(13);
        }
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        PsiElement psiElement = parent = parent != null ? parent.getParent() : null;
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement((XmlTag)parent);
        if (domElement instanceof AndroidDomElement) {
            return AndroidXmlSpellcheckingStrategy.inEnglish(element);
        }
        return false;
    }

    private static boolean inEnglish(PsiElement element) {
        XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class);
        if (file != null) {
            PsiDirectory dir;
            String name = file.getName();
            if (name.equals("AndroidManifest.xml")) {
                return true;
            }
            if (name.equals("generated.xml")) {
                AndroidModel androidModel;
                AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file);
                VirtualFile virtualFile = file.getVirtualFile();
                if (facet2 != null && AndroidModel.isRequired(facet2) && virtualFile != null && (androidModel = AndroidModel.get(facet2)) != null && androidModel.isGenerated(virtualFile)) {
                    return false;
                }
            } else if (AndroidXmlSpellcheckingStrategy.isLintConfig(file)) {
                return false;
            }
            if ((dir = file.getParent()) != null) {
                String locale = Lint.getLocaleAndRegion((String)dir.getName());
                if (locale == null) {
                    locale = AndroidXmlSpellcheckingStrategy.getToolsLocale(file);
                }
                return locale == null || locale.startsWith("en") || locale.equals("b+en") || locale.startsWith("b+en+");
            }
        }
        return false;
    }

    @Nullable
    private static String getToolsLocale(XmlFile file) {
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null) {
            return rootTag.getAttributeValue("locale", "http://schemas.android.com/tools");
        }
        return null;
    }

    private static boolean isColorString(@NotNull String s) {
        int length;
        if (s == null) {
            AndroidXmlSpellcheckingStrategy.$$$reportNull$$$0(14);
        }
        if ((length = s.length()) < 4 || length > 9) {
            return false;
        }
        int i2 = 0;
        if (s.charAt(i2++) != '#') {
            return false;
        }
        while (i2 < length) {
            if (!StringUtil.isHexDigit((char)s.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValueTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLintConfig";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAttributeValueContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isColorString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AaptXmlTextSplitter
    extends BaseSplitter {
        public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
            if (range == null) {
                AaptXmlTextSplitter.$$$reportNull$$$0(0);
            }
            if (text == null || StringUtil.isEmpty((String)text)) {
                return;
            }
            PlainTextSplitter ps = PlainTextSplitter.getInstance();
            if (text.indexOf(92) == -1) {
                ps.split(text, range, consumer);
            } else {
                int end;
                int length = range.getEndOffset();
                int start = range.getStartOffset();
                do {
                    if ((end = text.indexOf(92, start)) == -1) {
                        end = length;
                    }
                    ps.split(text, new TextRange(start, end), consumer);
                } while ((start = end + 2) < length);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy$AaptXmlTextSplitter", "split"));
        }
    }

    private static class MyResourceReferenceTokenizer
    extends SpellcheckingStrategy.XmlAttributeValueTokenizer {
        private MyResourceReferenceTokenizer() {
        }

        @Nullable
        private static AndroidResourceReferenceBase findResourceReference(PsiElement element) {
            for (PsiReference reference2 : element.getReferences()) {
                if (!(reference2 instanceof AndroidResourceReferenceBase)) continue;
                return (AndroidResourceReferenceBase)reference2;
            }
            return null;
        }

        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer) {
            AndroidResourceReferenceBase reference2;
            if (element == null) {
                MyResourceReferenceTokenizer.$$$reportNull$$$0(0);
            }
            if ((reference2 = MyResourceReferenceTokenizer.findResourceReference((PsiElement)element)) != null) {
                if (reference2.getResourceValue().getPackage() == null) {
                    consumer.consumeToken((PsiElement)element, true, (Splitter)TextSplitter.getInstance());
                }
                return;
            }
            if (AndroidXmlSpellcheckingStrategy.isColorString(element.getValue())) {
                return;
            }
            super.tokenize(element, consumer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy$MyResourceReferenceTokenizer", "tokenize"));
        }
    }
}

