/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.android.uipreview.VirtualFolderWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileWrapper
implements IAbstractFile {
    private final Project myProject;
    private final VirtualFile myFile;

    public VirtualFileWrapper(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            VirtualFileWrapper.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VirtualFileWrapper.$$$reportNull$$$0(1);
        }
        this.myFile = file;
        this.myProject = project;
    }

    public InputStream getContents() throws StreamException {
        String content2 = this.getFileContent();
        return new ByteArrayInputStream(content2.getBytes());
    }

    @NotNull
    private String getFileContent() {
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!VirtualFileWrapper.this.myFile.isValid()) {
                    return "";
                }
                PsiFile psiFile2 = PsiManager.getInstance((Project)VirtualFileWrapper.this.myProject).findFile(VirtualFileWrapper.this.myFile);
                return psiFile2 != null ? psiFile2.getText() : "";
            }
        });
        if (string == null) {
            VirtualFileWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setContents(InputStream source) throws StreamException {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() throws StreamException {
        throw new UnsupportedOperationException();
    }

    public IAbstractFile.PreferredWriteMode getPreferredWriteMode() {
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        return this.myFile.getTimeStamp();
    }

    public String getName() {
        return this.myFile.getName();
    }

    public String getOsLocation() {
        return FileUtil.toSystemDependentName((String)this.myFile.getPath());
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public boolean exists() {
        return this.myFile.exists();
    }

    @Nullable
    public IAbstractFolder getParentFolder() {
        VirtualFile parent = this.myFile.getParent();
        return parent != null ? new VirtualFolderWrapper(this.myProject, parent) : null;
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            VirtualFileWrapper.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFileWrapper wrapper = (VirtualFileWrapper)o;
        if (!this.myFile.equals(wrapper.myFile)) {
            return false;
        }
        return this.myProject.equals(wrapper.myProject);
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + this.myFile.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/VirtualFileWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/VirtualFileWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

