/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.EditorOptionsPanelKt;
import com.intellij.application.options.editor.GeneralEditorOptionsProviderEP;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.BoundCompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import java.awt.Container;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00020\u0002 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\n0\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u001b\u0012\u0017\u0012\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u00100\u000f\u00a2\u0006\u0002\b\u00110\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/application/options/editor/EditorOptionsPanel;", "Lcom/intellij/openapi/options/BoundCompositeConfigurable;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "Lcom/intellij/openapi/options/Configurable$WithEpDependencies;", "()V", "apply", "", "createConfigurables", "", "kotlin.jvm.PlatformType", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getDependencies", "", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/application/options/editor/GeneralEditorOptionsProviderEP;", "Lorg/jetbrains/annotations/NotNull;", "Companion", "intellij.platform.lang.impl"})
public final class EditorOptionsPanel
extends BoundCompositeConfigurable<UnnamedConfigurable>
implements Configurable.WithEpDependencies {
    @NotNull
    public static final String ID = "preferences.editor";
    public static final Companion Companion = new Companion(null);

    @Override
    public List<UnnamedConfigurable> createConfigurables() {
        return ConfigurableWrapper.createConfigurables(GeneralEditorOptionsProviderEP.Companion.getEP_NAME());
    }

    @NotNull
    public Set<ExtensionPointName<GeneralEditorOptionsProviderEP>> getDependencies() {
        return SetsKt.setOf(GeneralEditorOptionsProviderEP.Companion.getEP_NAME());
    }

    @NotNull
    public DialogPanel createPanel() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        String string = ApplicationBundle.message((String)"group.advanced.mouse.usages", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"group.advanced.mouse.usages\")");
        $this$panel.titledRow(string, (Function1<? super Row, Unit>)((Function1)createPanel.1.1.INSTANCE));
        String string2 = ApplicationBundle.message((String)"group.soft.wraps", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"group.soft.wraps\")");
        $this$panel.titledRow(string2, (Function1<? super Row, Unit>)((Function1)createPanel.1.2.INSTANCE));
        String string3 = ApplicationBundle.message((String)"group.virtual.space", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"group.virtual.space\")");
        $this$panel.titledRow(string3, (Function1<? super Row, Unit>)((Function1)createPanel.1.3.INSTANCE));
        String string4 = ApplicationBundle.message((String)"group.caret.movement", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"group.caret.movement\")");
        $this$panel.titledRow(string4, (Function1<? super Row, Unit>)((Function1)createPanel.1.4.INSTANCE));
        String string5 = ApplicationBundle.message((String)"editor.options.scrolling", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"editor.options.scrolling\")");
        $this$panel.titledRow(string5, (Function1<? super Row, Unit>)((Function1)createPanel.1.5.INSTANCE));
        String string6 = ApplicationBundle.message((String)"group.limits", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"group.limits\")");
        $this$panel.titledRow(string6, (Function1<? super Row, Unit>)((Function1)createPanel.1.6.INSTANCE));
        String string7 = ApplicationBundle.message((String)"group.richcopy", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"group.richcopy\")");
        $this$panel.titledRow(string7, (Function1<? super Row, Unit>)((Function1)createPanel.1.7.INSTANCE));
        String string8 = ApplicationBundle.message((String)"editor.options.save.files.group", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(\"editor.options.save.files.group\")");
        $this$panel.titledRow(string8, (Function1<? super Row, Unit>)((Function1)createPanel.1.8.INSTANCE));
        for (UnnamedConfigurable configurable2 : this.getConfigurables()) {
            this.appendDslConfigurableRow($this$panel, configurable2);
        }
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        return panel$iv;
    }

    @Override
    public void apply() {
        boolean wasModified = this.isModified();
        super.apply();
        if (wasModified) {
            EditorOptionsPanel.Companion.clearAllIdentifierHighlighters();
            Companion.reinitAllEditors();
            EditorOptionsPanelKt.access$getUiSettings$p().fireUISettingsChanged();
            Companion.restartDaemons();
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((EditorOptionsListener)application.getMessageBus().syncPublisher(EditorOptionsListener.OPTIONS_PANEL_TOPIC)).changesApplied();
        }
    }

    public EditorOptionsPanel() {
        String string = ApplicationBundle.message((String)"title.editor", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"title.editor\")");
        super(string, ID);
    }

    @JvmStatic
    public static final void reinitAllEditors() {
        Companion.reinitAllEditors();
    }

    @JvmStatic
    public static final void restartDaemons() {
        Companion.restartDaemons();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/application/options/editor/EditorOptionsPanel$Companion;", "", "()V", "ID", "", "clearAllIdentifierHighlighters", "", "reinitAllEditors", "restartDaemons", "intellij.platform.lang.impl"})
    public static final class Companion {
        private final void clearAllIdentifierHighlighters() {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            for (Project project : projectManager.getOpenProjects()) {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
                for (FileEditor fileEditor : fileEditorManager.getAllEditors()) {
                    Document document;
                    if (!(fileEditor instanceof TextEditor)) continue;
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"fileEditor.editor");
                    Intrinsics.checkNotNullExpressionValue((Object)editor.getDocument(), (String)"fileEditor.editor.document");
                    IdentifierHighlighterPass.clearMyHighlights(document, project);
                }
            }
        }

        @JvmStatic
        public final void reinitAllEditors() {
            EditorFactory.getInstance().refreshAllEditors();
        }

        @JvmStatic
        public final void restartDaemons() {
            Project[] projects;
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            for (Project project : projects = projectArray) {
                DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

