/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.IntentionsUIImpl;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="DaemonCodeAnalyzer", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(DaemonCodeAnalyzerImpl.class);
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create((String)"FILE_LEVEL_HIGHLIGHTS");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private final FileEditorManager myFileEditorManager;
    private DaemonProgressIndicator myUpdateProgress;
    private final UpdateRunnable myUpdateRunnable;
    private final ScheduledExecutorService myAlarm;
    @NotNull
    private volatile Future<?> myUpdateRunnableFuture;
    private boolean myUpdateByTimerEnabled;
    private final Collection<VirtualFile> myDisabledHintsFiles;
    private final Collection<VirtualFile> myDisabledHighlightingFiles;
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private volatile boolean myDisposed;
    private volatile boolean myInitialized;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private final PassExecutorService myPassExecutorService;
    private long myScheduledUpdateTimestamp;
    private static final int ANY_GROUP = -409423948;
    private volatile boolean mustWaitForSmartMode;
    private final AtomicInteger myDisableCount;

    public DaemonCodeAnalyzerImpl(@NotNull Project project) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(0);
        }
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myAlarm = EdtExecutorService.getScheduledExecutorInstance();
        this.myUpdateRunnableFuture = CompletableFuture.completedFuture(null);
        this.myUpdateByTimerEnabled = true;
        this.myDisabledHintsFiles = new HashSet<VirtualFile>();
        this.myDisabledHighlightingFiles = new HashSet<VirtualFile>();
        this.mustWaitForSmartMode = true;
        this.myDisableCount = new AtomicInteger();
        DependencyValidationManager.getInstance((Project)project);
        this.myProject = project;
        this.mySettings = DaemonCodeAnalyzerSettings.getInstance();
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)this.mySettings).clone();
        this.myFileStatusMap = new FileStatusMap(project);
        this.myPassExecutorService = new PassExecutorService(project);
        Disposer.register((Disposable)this, (Disposable)this.myPassExecutorService);
        Disposer.register((Disposable)this, (Disposable)this.myFileStatusMap);
        DaemonProgressIndicator.setDebug(LOG.isDebugEnabled());
        assert (!this.myInitialized) : "Double Initializing";
        Disposer.register((Disposable)this, (Disposable)new StatusBarUpdater(project));
        this.myInitialized = true;
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty("DCAI init");
        this.myUpdateRunnable = new UpdateRunnable(this.myProject);
        Disposer.register((Disposable)this, () -> {
            assert (this.myInitialized) : "Disposing not initialized component";
            assert (!this.myDisposed) : "Double dispose";
            this.myUpdateRunnable.clearFieldsOnDispose();
            this.stopProcess(false, "Dispose " + this.myProject);
            this.myDisposed = true;
            this.myLastSettings = null;
        });
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
    }

    public synchronized void dispose() {
        this.clearReferences();
    }

    private synchronized void clearReferences() {
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myUpdateRunnableFuture.cancel(true);
    }

    void clearProgressIndicator() {
        HighlightingSessionImpl.clearProgressIndicator(this.myUpdateProgress);
    }

    @NotNull
    @TestOnly
    public static List<HighlightInfo> getHighlights(@NotNull Document document, @Nullable HighlightSeverity minSeverity, @NotNull Project project) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(2);
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerImpl.processHighlights(document, project, minSeverity, 0, document.getTextLength(), (Processor<? super HighlightInfo>)Processors.cancelableCollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    @TestOnly
    public static List<HighlightInfo> getHighlights(@NotNull Editor editor, @Nullable HighlightSeverity minSeverity, @NotNull Project project) {
        if (editor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(5);
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        DaemonCodeAnalyzerImpl.processHighlights(markupModel, project, minSeverity, 0, editor.getDocument().getTextLength(), (Processor<? super HighlightInfo>)Processors.cancelableCollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    @NotNull
    @TestOnly
    public List<HighlightInfo> getFileLevelHighlights(@NotNull Project project, @NotNull PsiFile file2) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(8);
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        List<HighlightInfo> list2 = Arrays.stream(this.myFileEditorManager.getEditors(vFile)).map(fileEditor -> (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    public void cleanFileLevelHighlights(@NotNull Project project, int group2, @NotNull PsiFile psiFile) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(11);
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        for (FileEditor fileEditor : this.myFileEditorManager.getEditors(vFile)) {
            this.cleanFileLevelHighlights(fileEditor, group2);
        }
    }

    void cleanAllFileLevelHighlights() {
        for (FileEditor fileEditor : this.myFileEditorManager.getAllEditors()) {
            this.cleanFileLevelHighlights(fileEditor, -409423948);
        }
    }

    private void cleanFileLevelHighlights(FileEditor fileEditor, int group2) {
        List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
        if (infos == null) {
            return;
        }
        ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>(infos.size());
        for (HighlightInfo info : infos) {
            if (info.getGroup() != group2 && group2 != -409423948) continue;
            this.myFileEditorManager.removeTopComponent(fileEditor, info.fileLevelComponent);
            infosToRemove.add(info);
        }
        infos.removeAll(infosToRemove);
    }

    @Override
    public void addFileLevelHighlight(@NotNull Project project, int group2, @NotNull HighlightInfo info, @NotNull PsiFile psiFile) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(12);
        }
        if (info == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(14);
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        for (FileEditor fileEditor : this.myFileEditorManager.getEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            FileLevelIntentionComponent component2 = new FileLevelIntentionComponent(info.getDescription(), info.getSeverity(), info.getGutterIconRenderer(), info.quickFixActionRanges, project, psiFile, ((TextEditor)fileEditor).getEditor(), info.getToolTip());
            this.myFileEditorManager.addTopComponent(fileEditor, (JComponent)((Object)component2));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info.fileLevelComponent = component2;
            info.setGroup(group2);
            fileLevelInfos.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<HighlightInfo> runMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull ProgressIndicator progress2) {
        ArrayList<HighlightInfo> result2;
        block12: {
            if (psiFile == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(15);
            }
            if (document == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(16);
            }
            if (progress2 == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(17);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new IllegalStateException("Must not run highlighting from under EDT");
            }
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                throw new IllegalStateException("Must run highlighting from under read action");
            }
            GlobalInspectionContextBase.assertUnderDaemonProgress();
            this.myFileStatusMap.markAllFilesDirty("prepare to run main passes");
            this.stopProcess(false, "disable background daemon");
            this.myPassExecutorService.cancelAll(true);
            try {
                result2 = new ArrayList<HighlightInfo>();
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null || virtualFile.getFileType().isBinary()) break block12;
                List<TextEditorHighlightingPass> passes = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject).instantiateMainPasses(psiFile, document, HighlightInfoProcessor.getEmpty());
                passes.sort((o1, o2) -> {
                    if (o1 instanceof GeneralHighlightingPass) {
                        return -1;
                    }
                    if (o2 instanceof GeneralHighlightingPass) {
                        return 1;
                    }
                    return 0;
                });
                try {
                    for (TextEditorHighlightingPass pass : passes) {
                        pass.doCollectInformation(progress2);
                        result2.addAll(pass.getInfos());
                    }
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Canceled: " + progress2);
                    throw e;
                }
            }
            finally {
                this.stopProcess(true, "re-enable background daemon after main passes run");
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @TestOnly
    public void mustWaitForSmartMode(boolean mustWait, @NotNull Disposable parent) {
        if (parent == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(19);
        }
        boolean old = this.mustWaitForSmartMode;
        this.mustWaitForSmartMode = mustWait;
        Disposer.register((Disposable)parent, () -> {
            this.mustWaitForSmartMode = old;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TestOnly
    public void runPasses(@NotNull PsiFile file2, @NotNull Document document, @NotNull List<? extends TextEditor> textEditors, int @NotNull [] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(20);
        }
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(21);
        }
        if (textEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(22);
        }
        if (toIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(23);
        }
        assert (this.myInitialized);
        assert (!this.myDisposed);
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (application.isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Must not start highlighting from within write action, or deadlock is imminent");
        }
        DaemonProgressIndicator.setDebug(!ApplicationInfoImpl.isInStressTest());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        UIUtil.dispatchAllInvocationEvents();
        while (RefreshQueueImpl.isRefreshInProgress() || HeavyProcessLatch.INSTANCE.isRunning()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        long dstart = System.currentTimeMillis();
        while (this.mustWaitForSmartMode && DumbService.getInstance((Project)this.myProject).isDumb()) {
            if (System.currentTimeMillis() > dstart + 100000L) {
                throw new IllegalStateException("Timeout waiting for smart mode. If you absolutely want to be dumb, please use DaemonCodeAnalyzerImpl.mustWaitForSmartMode(false).");
            }
            UIUtil.dispatchAllInvocationEvents();
        }
        UIUtil.dispatchAllInvocationEvents();
        FileStatusMap fileStatusMap = this.getFileStatusMap();
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        HashMap<FileEditor, HighlightingPass[]> map2 = new HashMap<FileEditor, HighlightingPass[]>();
        for (TextEditor textEditor : textEditors) {
            TextEditorBackgroundHighlighter highlighter = (TextEditorBackgroundHighlighter)textEditor.getBackgroundHighlighter();
            if (highlighter == null) {
                Editor editor = textEditor.getEditor();
                throw new RuntimeException("Null highlighter from " + textEditor + "; loaded: " + AsyncEditorLoader.isEditorLoaded(editor));
            }
            List<TextEditorHighlightingPass> passes = highlighter.getPasses(toIgnore);
            HighlightingPass[] array2 = passes.toArray(HighlightingPass.EMPTY_ARRAY);
            assert (array2.length != 0) : "Highlighting is disabled for the file " + file2;
            map2.put((FileEditor)textEditor, array2);
        }
        for (Object ignoreId : (Object)toIgnore) {
            fileStatusMap.markFileUpToDate(document, (int)ignoreId);
        }
        this.myUpdateRunnableFuture.cancel(false);
        this.myPassExecutorService.cancelAll(false);
        fileStatusMap.allowDirt(canChangeDocument);
        DaemonProgressIndicator progress2 = this.createUpdateProgress(map2.keySet());
        this.myPassExecutorService.submitPasses(map2, progress2);
        try {
            long l = System.currentTimeMillis();
            while (progress2.isRunning() && System.currentTimeMillis() < l + 600000L) {
                progress2.checkCanceled();
                if (callbackWhileWaiting != null) {
                    callbackWhileWaiting.run();
                }
                this.waitInOtherThread(50, canChangeDocument);
                UIUtil.dispatchAllInvocationEvents();
                Throwable savedException = PassExecutorService.getSavedException(progress2);
                if (savedException == null) continue;
                throw savedException;
            }
            if (progress2.isRunning() && !progress2.isCanceled()) {
                throw new RuntimeException("Highlighting still running after " + (System.currentTimeMillis() - l) / 1000L + " seconds. Still submitted passes: " + this.myPassExecutorService.getAllSubmittedPasses() + " ForkJoinPool.commonPool(): " + ForkJoinPool.commonPool() + "\n, ForkJoinPool.commonPool() active thread count: " + ForkJoinPool.commonPool().getActiveThreadCount() + ", ForkJoinPool.commonPool() has queued submissions: " + ForkJoinPool.commonPool().hasQueuedSubmissions() + "\n" + ThreadDumper.dumpThreadsToString());
            }
            HighlightingSessionImpl session2 = (HighlightingSessionImpl)HighlightingSessionImpl.getOrCreateHighlightingSession(file2, progress2, null);
            if (!this.waitInOtherThread(60000, canChangeDocument)) {
                throw new TimeoutException("Unable to complete in 60s. Thread dump:\n" + ThreadDumper.dumpThreadsToString());
            }
            session2.waitForHighlightInfosApplied();
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            assert (progress2.isCanceled() && progress2.isDisposed());
        }
        catch (Throwable throwable) {
            void var13_17;
            if (throwable instanceof ExecutionException) {
                Throwable throwable2 = throwable.getCause();
            }
            if (progress2.isCanceled() && progress2.isRunning()) {
                var13_17.addSuppressed(new RuntimeException("Daemon progress was canceled unexpectedly: " + progress2));
            }
            ExceptionUtil.rethrow((Throwable)var13_17);
        }
        finally {
            DaemonProgressIndicator.setDebug(false);
            fileStatusMap.allowDirt(true);
            progress2.cancel();
            this.waitForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private boolean waitInOtherThread(int millis, boolean canChangeDocument) throws Throwable {
        Disposable disposable2 = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable2).subscribe(PsiModificationTracker.TOPIC, () -> {
            throw new IllegalStateException("You must not perform PSI modifications from inside highlighting");
        });
        if (!canChangeDocument) {
            this.myProject.getMessageBus().connect(disposable2).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

                public void daemonCancelEventOccurred(@NotNull String reason) {
                    if (reason == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new IllegalStateException("You must not cancel daemon inside highlighting test: " + reason);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$1", "daemonCancelEventOccurred"));
                }
            });
        }
        try {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    return this.myPassExecutorService.waitFor(millis);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
            boolean bl = (Boolean)future2.get();
            return bl;
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    @TestOnly
    public void prepareForTest() {
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
        this.clearReferences();
    }

    @TestOnly
    public void cleanupAfterTest() {
        if (this.myProject.isOpen()) {
            this.prepareForTest();
        }
    }

    @TestOnly
    public void waitForTermination() {
        this.myPassExecutorService.cancelAll(true);
    }

    public void settingsChanged() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        if (settings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)settings).clone();
    }

    public synchronized void setUpdateByTimerEnabled(boolean value2) {
        this.myUpdateByTimerEnabled = value2;
        this.stopProcess(value2, "Update by timer change");
    }

    public void disableUpdateByTimer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(24);
        }
        this.setUpdateByTimerEnabled(false);
        this.myDisableCount.incrementAndGet();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register((Disposable)parentDisposable, () -> {
            if (this.myDisableCount.decrementAndGet() == 0) {
                this.setUpdateByTimerEnabled(true);
            }
        });
    }

    synchronized boolean isUpdateByTimerEnabled() {
        return this.myUpdateByTimerEnabled;
    }

    public void setImportHintsEnabled(@NotNull PsiFile file2, boolean value2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(25);
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (value2) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true, "Import hints change");
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    public void setHighlightingEnabled(@NotNull PsiFile file2, boolean value2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(26);
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        if (value2) {
            this.myDisabledHighlightingFiles.remove(virtualFile);
        } else {
            this.myDisabledHighlightingFiles.add(virtualFile);
        }
    }

    public boolean isHighlightingAvailable(@Nullable PsiFile file2) {
        if (file2 == null || !file2.isPhysical()) {
            return false;
        }
        if (this.myDisabledHighlightingFiles.contains(PsiUtilCore.getVirtualFile((PsiElement)file2))) {
            return false;
        }
        if (file2 instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = file2.getFileType();
        return !fileType.isBinary();
    }

    public boolean isImportHintsEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(27);
        }
        return this.isAutohintsAvailable(file2) && !this.myDisabledHintsFiles.contains(file2.getVirtualFile());
    }

    public boolean isAutohintsAvailable(PsiFile file2) {
        return this.isHighlightingAvailable(file2) && !(file2 instanceof PsiCompiledElement);
    }

    public void restart() {
        this.doRestart("Global restart");
    }

    boolean doRestart(@NotNull String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(28);
        }
        this.myFileStatusMap.markAllFilesDirty(reason);
        return this.stopProcess(true, reason);
    }

    public void restart(@NotNull PsiFile file2) {
        Document document;
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(29);
        }
        if ((document = this.myPsiDocumentManager.getCachedDocument(file2)) == null) {
            return;
        }
        String reason = "Psi file restart: " + file2.getName();
        this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, document.getTextLength()), file2.getTextLength(), reason);
        this.stopProcess(true, reason);
    }

    @NotNull
    public List<ProgressableTextEditorHighlightingPass> getPassesToShowProgressFor(@NotNull Document document) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(30);
        }
        List<HighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        List<ProgressableTextEditorHighlightingPass> list2 = allPasses.stream().map(p -> p instanceof ProgressableTextEditorHighlightingPass ? (ProgressableTextEditorHighlightingPass)p : null).filter(p -> p != null && p.getDocument() == document).sorted(Comparator.comparingInt(p -> p.getId())).collect(Collectors.toList());
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    boolean isAllAnalysisFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(32);
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(file2);
        return document != null && document.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document);
    }

    @Override
    public boolean isErrorAnalyzingFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(33);
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(file2);
        return document != null && document.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document, 4) == null;
    }

    @Override
    @NotNull
    public FileStatusMap getFileStatusMap() {
        FileStatusMap fileStatusMap = this.myFileStatusMap;
        if (fileStatusMap == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(34);
        }
        return fileStatusMap;
    }

    public synchronized boolean isRunning() {
        return !this.myUpdateProgress.isCanceled();
    }

    @TestOnly
    public boolean isRunningOrPending() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.isRunning() || !this.myUpdateRunnableFuture.isDone() || GeneralHighlightingPass.isRestartPending();
    }

    synchronized boolean stopProcess(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        boolean restart;
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(35);
        }
        boolean canceled = this.cancelUpdateProgress(toRestartAlarm, reason);
        boolean bl = restart = toRestartAlarm && !this.myDisposed && this.myInitialized;
        if (restart) {
            this.myScheduledUpdateTimestamp = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.mySettings.getAutoReparseDelay());
        }
        boolean isDone = this.myUpdateRunnableFuture.isDone();
        if (restart && isDone) {
            this.scheduleUpdateRunnable(this.mySettings.getAutoReparseDelay());
        }
        return canceled;
    }

    private void scheduleUpdateRunnable(long delayNanos) {
        this.myUpdateRunnableFuture = this.myAlarm.schedule(this.myUpdateRunnable, delayNanos, TimeUnit.NANOSECONDS);
    }

    private synchronized boolean cancelUpdateProgress(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(36);
        }
        DaemonProgressIndicator updateProgress = this.myUpdateProgress;
        if (this.myDisposed) {
            return false;
        }
        boolean wasCanceled = updateProgress.isCanceled();
        if (!wasCanceled) {
            PassExecutorService.log(updateProgress, null, "Cancel", reason, toRestartAlarm);
            updateProgress.cancel();
            this.myPassExecutorService.cancelAll(false);
            return true;
        }
        return false;
    }

    static boolean processHighlightsNearOffset(@NotNull Document document, @NotNull Project project, @NotNull HighlightSeverity minSeverity, int offset, boolean includeFixRange, @NotNull Processor<? super HighlightInfo> processor2) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(37);
        }
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(38);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(39);
        }
        if (processor2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(40);
        }
        return DaemonCodeAnalyzerImpl.processHighlights(document, project, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)((Processor)info -> {
            if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, includeFixRange)) {
                return true;
            }
            int compare = info.getSeverity().compareTo(minSeverity);
            return compare < 0 || processor2.process(info);
        }));
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(41);
        }
        return this.findHighlightByOffset(document, offset, includeFixRange, HighlightSeverity.INFORMATION);
    }

    @Nullable
    HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(42);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(43);
        }
        return this.findHighlightsByOffset(document, offset, includeFixRange, true, minSeverity);
    }

    @Nullable
    public HighlightInfo findHighlightsByOffset(@NotNull Document document, int offset, boolean includeFixRange, boolean highestPriorityOnly, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(44);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(45);
        }
        HighlightByOffsetProcessor processor2 = new HighlightByOffsetProcessor(highestPriorityOnly);
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(document, this.myProject, minSeverity, offset, includeFixRange, processor2);
        return processor2.getResult();
    }

    private static boolean isOffsetInsideHighlightInfo(int offset, @NotNull HighlightInfo info, boolean includeFixRange) {
        RangeHighlighterEx highlighter;
        if (info == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(46);
        }
        if ((highlighter = info.getHighlighter()) == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        RangeMarker fixMarker = info.fixMarker;
        if (fixMarker != null) {
            if (!fixMarker.isValid()) {
                return false;
            }
            startOffset = fixMarker.getStartOffset();
            endOffset = fixMarker.getEndOffset();
            return startOffset <= offset && offset <= endOffset;
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo<?>> getLineMarkers(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(47);
        }
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(48);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList result2 = new ArrayList();
        LineMarkersUtil.processLineMarkers(project, document, (Segment)new TextRange(0, document.getTextLength()), -1, new CommonProcessors.CollectProcessor(result2));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    @Nullable
    IntentionHintComponent getLastIntentionHint() {
        return ((IntentionsUIImpl)IntentionsUI.getInstance(this.myProject)).getLastIntentionHint();
    }

    @NotNull
    public Element getState() {
        Element state = new Element("state");
        if (this.myDisabledHintsFiles.isEmpty()) {
            Element element2 = state;
            if (element2 == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(50);
            }
            return element2;
        }
        SmartList array2 = new SmartList();
        for (VirtualFile file2 : this.myDisabledHintsFiles) {
            if (!file2.isValid()) continue;
            array2.add(file2.getUrl());
        }
        if (!array2.isEmpty()) {
            Collections.sort(array2);
            Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
            state.addContent(disableHintsElement);
            for (String url : array2) {
                disableHintsElement.addContent(new Element(FILE_TAG).setAttribute(URL_ATT, url));
            }
        }
        Element element3 = state;
        if (element3 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(51);
        }
        return element3;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(52);
        }
        this.myDisabledHintsFiles.clear();
        Element element2 = state.getChild(DISABLE_HINTS_TAG);
        if (element2 != null) {
            for (Element e : element2.getChildren(FILE_TAG)) {
                VirtualFile file2;
                String url = e.getAttributeValue(URL_ATT);
                if (url == null || (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file2);
            }
        }
    }

    @NotNull
    private synchronized DaemonProgressIndicator createUpdateProgress(@NotNull Collection<? extends FileEditor> fileEditors) {
        DaemonProgressIndicator old;
        if (fileEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(53);
        }
        if (!(old = this.myUpdateProgress).isCanceled()) {
            old.cancel();
        }
        MyDaemonProgressIndicator progress2 = new MyDaemonProgressIndicator(this.myProject, fileEditors);
        progress2.setModalityProgress(null);
        progress2.start();
        ((DaemonCodeAnalyzer.DaemonListener)this.myProject.getMessageBus().syncPublisher(DAEMON_EVENT_TOPIC)).daemonStarting(fileEditors);
        this.myUpdateProgress = progress2;
        MyDaemonProgressIndicator myDaemonProgressIndicator = progress2;
        if (myDaemonProgressIndicator == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(54);
        }
        return myDaemonProgressIndicator;
    }

    public void autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2) {
        ReferenceImporter importer;
        if (editor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(55);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(56);
        }
        Iterator iterator2 = ReferenceImporter.EP_NAME.getExtensionList().iterator();
        while (!(!iterator2.hasNext() || (importer = (ReferenceImporter)iterator2.next()).isAddUnambiguousImportsOnTheFlyEnabled(file2) && importer.autoImportReferenceAtCursor(editor, file2))) {
        }
    }

    @TestOnly
    @NotNull
    public synchronized DaemonProgressIndicator getUpdateProgress() {
        DaemonProgressIndicator daemonProgressIndicator = this.myUpdateProgress;
        if (daemonProgressIndicator == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(57);
        }
        return daemonProgressIndicator;
    }

    @NotNull
    private Collection<FileEditor> getSelectedEditors() {
        FileEditorManagerEx fileEditorManager;
        List<FileEditor> activeTextEditors;
        List<Object> editors2;
        Application app = ApplicationManager.getApplication();
        app.assertIsDispatchThread();
        EditorTracker editorTracker = (EditorTracker)this.myProject.getServiceIfCreated(EditorTracker.class);
        List<Object> list2 = editors2 = editorTracker == null ? Collections.emptyList() : editorTracker.getActiveEditors();
        if (editors2.isEmpty()) {
            activeTextEditors = Collections.emptyList();
        } else {
            activeTextEditors = new HashSet(editors2.size());
            for (Editor editor : editors2) {
                if (editor.isDisposed()) continue;
                TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
                activeTextEditors.add((FileEditor)textEditor);
            }
        }
        if (app.getCurrentModalityState() != ModalityState.NON_MODAL) {
            List<FileEditor> list3 = activeTextEditors;
            if (list3 == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(58);
            }
            return list3;
        }
        HashSet<FileEditor> result2 = new HashSet<FileEditor>(activeTextEditors.size());
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(activeTextEditors.size());
        if (!app.isUnitTestMode()) {
            fileEditorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
            for (FileEditor tabEditor : fileEditorManager.getSelectedEditorWithRemotes()) {
                if (!tabEditor.isValid()) continue;
                VirtualFile file2 = fileEditorManager.getFile(tabEditor);
                if (file2 != null) {
                    hashSet.add(file2);
                }
                result2.add(tabEditor);
            }
        }
        if (!activeTextEditors.isEmpty()) {
            fileEditorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
            for (FileEditor fileEditor : activeTextEditors) {
                VirtualFile file3 = fileEditorManager.getFile(fileEditor);
                if (file3 != null && hashSet.contains(file3)) continue;
                result2.add(fileEditor);
            }
        }
        HashSet<FileEditor> hashSet2 = result2;
        if (hashSet2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(59);
        }
        return hashSet2;
    }

    @Deprecated
    @ApiStatus.Internal
    public void runLocalInspectionPassAfterCompletionOfGeneralHighlightPass(boolean flag) {
        this.serializeCodeInsightPasses(flag);
    }

    @ApiStatus.Internal
    public void serializeCodeInsightPasses(boolean flag) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setUpdateByTimerEnabled(false);
        try {
            this.cancelUpdateProgress(false, "serializeCodeInsightPasses");
            this.myPassExecutorService.cancelAll(true);
            TextEditorHighlightingPassRegistrarImpl registrar = (TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myProject);
            registrar.serializeCodeInsightPasses(flag);
        }
        finally {
            this.setUpdateByTimerEnabled(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 18: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 18: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: 
            case 21: 
            case 30: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 18: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 4: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 33: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_TAG;
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 28: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 39: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlights";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileLevelHighlights";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "runMainPasses";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassesToShowProgressFor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatusMap";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkers";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateProgress";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateProgress";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHighlights";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 18: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelHighlights";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cleanFileLevelHighlights";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelHighlight";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runMainPasses";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "mustWaitForSmartMode";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runPasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "disableUpdateByTimer";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setImportHintsEnabled";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingEnabled";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isImportHintsEnabled";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doRestart";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPassesToShowProgressFor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isAllAnalysisFinished";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isErrorAnalyzingFinished";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "stopProcess";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "cancelUpdateProgress";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processHighlightsNearOffset";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findHighlightByOffset";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findHighlightsByOffset";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetInsideHighlightInfo";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkers";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateProgress";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "autoImportReferenceAtCursor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 18: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDaemonProgressIndicator
    extends DaemonProgressIndicator {
        private final Project myProject;
        private Collection<? extends FileEditor> myFileEditors;

        MyDaemonProgressIndicator(@NotNull Project project, @NotNull Collection<? extends FileEditor> fileEditors) {
            if (project == null) {
                MyDaemonProgressIndicator.$$$reportNull$$$0(0);
            }
            if (fileEditors == null) {
                MyDaemonProgressIndicator.$$$reportNull$$$0(1);
            }
            this.myFileEditors = fileEditors;
            this.myProject = project;
        }

        @Override
        public void stopIfRunning() {
            super.stopIfRunning();
            ((DaemonCodeAnalyzer.DaemonListener)this.myProject.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC)).daemonFinished(this.myFileEditors);
            this.myFileEditors = null;
            HighlightingSessionImpl.clearProgressIndicator(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileEditors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$MyDaemonProgressIndicator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UpdateRunnable
    implements Runnable {
        private Project myProject;

        private UpdateRunnable(@NotNull Project project) {
            if (project == null) {
                UpdateRunnable.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DaemonCodeAnalyzerImpl dca;
            block17: {
                block16: {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    Project project = this.myProject;
                    if (project == null || !project.isInitialized() || project.isDisposed() || PowerSaveMode.isEnabled() || LightEdit.owns((Project)project)) break block16;
                    dca = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
                    if (!dca.myDisposed) break block17;
                }
                return;
            }
            DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = dca;
            synchronized (daemonCodeAnalyzerImpl) {
                long actualDelay = dca.myScheduledUpdateTimestamp - System.nanoTime();
                if (actualDelay > 0L) {
                    dca.scheduleUpdateRunnable(actualDelay);
                    return;
                }
            }
            Collection<FileEditor> activeEditors = dca.getSelectedEditors();
            boolean updateByTimerEnabled = dca.isUpdateByTimerEnabled();
            if (PassExecutorService.LOG.isDebugEnabled()) {
                PassExecutorService.log(dca.getUpdateProgress(), null, "Update Runnable. myUpdateByTimerEnabled:", updateByTimerEnabled, " something disposed:", PowerSaveMode.isEnabled() || !this.myProject.isInitialized(), " activeEditors:", activeEditors);
            }
            if (!updateByTimerEnabled) {
                return;
            }
            if (activeEditors.isEmpty()) {
                return;
            }
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                return;
            }
            if (dca.myPsiDocumentManager.hasUncommitedDocuments()) {
                dca.myPsiDocumentManager.performLaterWhenAllCommitted((Runnable)this);
                return;
            }
            HashMap<FileEditor, HighlightingPass[]> passes = new HashMap<FileEditor, HighlightingPass[]>(activeEditors.size());
            for (FileEditor fileEditor : activeEditors) {
                BackgroundEditorHighlighter backgroundEditorHighlighter = fileEditor.getBackgroundHighlighter();
                if (backgroundEditorHighlighter == null) continue;
                HighlightingPass[] highlightingPasses = backgroundEditorHighlighter.createPassesForEditor();
                passes.put(fileEditor, highlightingPasses);
            }
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                boolean hasPasses = false;
                for (Map.Entry entry : passes.entrySet()) {
                    HighlightingPass[] dumbAwarePasses = (HighlightingPass[])Arrays.stream((HighlightingPass[])entry.getValue()).filter(DumbService::isDumbAware).toArray(HighlightingPass[]::new);
                    entry.setValue(dumbAwarePasses);
                    hasPasses |= dumbAwarePasses.length != 0;
                }
                if (!hasPasses) {
                    HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> dca.stopProcess(true, "re-scheduled to execute after heavy processing finished"));
                    return;
                }
            }
            dca.cancelUpdateProgress(true, "Cancel by alarm");
            dca.myUpdateRunnableFuture.cancel(false);
            DaemonProgressIndicator progress2 = dca.createUpdateProgress(passes.keySet());
            dca.myPassExecutorService.submitPasses(passes, progress2);
        }

        private void clearFieldsOnDispose() {
            this.myProject = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$UpdateRunnable", "<init>"));
        }
    }

    static class HighlightByOffsetProcessor
    implements Processor<HighlightInfo> {
        private final List<HighlightInfo> foundInfoList = new SmartList();
        private final boolean highestPriorityOnly;

        HighlightByOffsetProcessor(boolean highestPriorityOnly) {
            this.highestPriorityOnly = highestPriorityOnly;
        }

        public boolean process(HighlightInfo info) {
            if (info.getSeverity() == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY || info.type == HighlightInfoType.TODO) {
                return true;
            }
            if (!this.foundInfoList.isEmpty() && this.highestPriorityOnly) {
                HighlightInfo foundInfo = this.foundInfoList.get(0);
                int compare = foundInfo.getSeverity().compareTo(info.getSeverity());
                if (compare < 0) {
                    this.foundInfoList.clear();
                } else if (compare > 0) {
                    return true;
                }
            }
            this.foundInfoList.add(info);
            return true;
        }

        @Nullable
        HighlightInfo getResult() {
            if (this.foundInfoList.isEmpty()) {
                return null;
            }
            if (this.foundInfoList.size() == 1) {
                return this.foundInfoList.get(0);
            }
            this.foundInfoList.sort(Comparator.comparing(HighlightInfo::getSeverity).reversed());
            return HighlightInfoComposite.create(this.foundInfoList);
        }
    }
}

