/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.InputEvent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\b\u0010\u0010\u001a\u00020\rH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"runActionCustomShortcutSet", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "getRunActionCustomShortcutSet", "()Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "createActionLabel", "Lcom/intellij/ui/HyperlinkLabel;", "text", "", "action", "Lkotlin/Function1;", "Ljava/awt/event/InputEvent;", "", "background", "Ljava/awt/Color;", "getActionFont", "Ljava/awt/Font;", "getKeymapColor", "intellij.platform.lang.impl"})
public final class DaemonTooltipWithActionRendererKt {
    @NotNull
    private static final CustomShortcutSet runActionCustomShortcutSet = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 576));

    @NotNull
    public static final CustomShortcutSet getRunActionCustomShortcutSet() {
        return runActionCustomShortcutSet;
    }

    @NotNull
    public static final HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel @NotNull String text2, @NotNull Function1<? super InputEvent, Unit> action2, @NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        HyperlinkLabel label2 = new HyperlinkLabel(text2, background, text2, background){
            final /* synthetic */ String $text;
            final /* synthetic */ Color $background;

            protected int getTextOffset() {
                return 0;
            }
            {
                this.$text = $captured_local_variable$0;
                this.$background = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        label2.setBorder((Border)JBUI.Borders.empty());
        label2.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(action2){
            final /* synthetic */ Function1 $action;

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$action.invoke((Object)e.getInputEvent());
            }
            {
                this.$action = $captured_local_variable$0;
            }
        });
        Font toolTipFont = DaemonTooltipWithActionRendererKt.getActionFont();
        label2.setFont(toolTipFont);
        return label2;
    }

    private static final Color getKeymapColor() {
        JBColor jBColor = JBColor.namedColor((String)"ToolTip.Actions.infoForeground", (Color)((Color)new JBColor(10069165, 0x919191)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Tool\u2026olor(0x99a4ad, 0x919191))");
        return (Color)jBColor;
    }

    private static final Font getActionFont() {
        Font toolTipFont = UIUtil.getToolTipFont();
        if (toolTipFont == null || SystemInfo.isWindows) {
            return toolTipFont;
        }
        if (Intrinsics.areEqual((Object)JBFont.label(), (Object)toolTipFont) ^ true || UISettings.Companion.getInstance().getOverrideLafFonts()) {
            return toolTipFont;
        }
        if (SystemInfo.isMac) {
            return toolTipFont.deriveFont((float)toolTipFont.getSize() - 1.0f);
        }
        if (SystemInfo.isLinux) {
            return toolTipFont.deriveFont((float)toolTipFont.getSize() - 1.0f);
        }
        return toolTipFont;
    }

    public static final /* synthetic */ Color access$getKeymapColor() {
        return DaemonTooltipWithActionRendererKt.getKeymapColor();
    }

    public static final /* synthetic */ Font access$getActionFont() {
        return DaemonTooltipWithActionRendererKt.getActionFont();
    }
}

