/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplateRunLogger;
import com.intellij.codeInsight.template.impl.TemplateExpressionLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSegments;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TemplateStateProcessor;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InteractiveTemplateStateProcessor
implements TemplateStateProcessor {
    private boolean myLookupShown;

    InteractiveTemplateStateProcessor() {
    }

    @Override
    public boolean isUndoOrRedoInProgress(Project project) {
        return UndoManager.getInstance((Project)project).isUndoOrRedoInProgress();
    }

    @Override
    public void registerUndoableAction(TemplateState state, Project project, Document document) {
        MyBasicUndoableAction undoableAction = new MyBasicUndoableAction(state, project, document);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undoableAction);
        Disposer.register((Disposable)state, (Disposable)undoableAction);
    }

    @Override
    public TextRange insertNewLineIndentMarker(PsiFile file2, Document document, int offset) {
        return CodeStyleManagerImpl.insertNewLineIndentMarker(file2, document, offset);
    }

    @Override
    public PsiElement findWhiteSpaceNode(PsiFile file2, int offset) {
        return CodeStyleManagerImpl.findWhiteSpaceNode(file2, offset);
    }

    @Override
    public void logTemplate(Project project, TemplateImpl template, Language language) {
        LiveTemplateRunLogger.log(project, template, language);
    }

    @Override
    public void runLookup(TemplateState state, Project project, Editor editor, LookupElement @NotNull [] elements2, Expression expressionNode) {
        if (elements2 == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(0);
        }
        ArrayList<TemplateExpressionLookupElement> lookupItems = new ArrayList<TemplateExpressionLookupElement>();
        for (int i2 = 0; i2 < elements2.length; ++i2) {
            lookupItems.add(new TemplateExpressionLookupElement(state, elements2[i2], i2));
        }
        if (((TemplateManagerImpl)TemplateManager.getInstance(project)).shouldSkipInTests()) {
            InteractiveTemplateStateProcessor.insertSingleItem(editor, lookupItems);
        } else {
            for (LookupElement lookupElement : lookupItems) {
                assert (lookupElement != null) : expressionNode;
            }
            AsyncEditorLoader.performWhenLoaded(editor, () -> this.runLookup(state, lookupItems, project, editor, expressionNode.getAdvertisingText(), expressionNode.getLookupFocusDegree()));
        }
    }

    private void runLookup(final TemplateState state, final List<TemplateExpressionLookupElement> lookupItems, Project project, Editor editor, @Nullable @NlsContexts.PopupAdvertisement String advertisingText, @NotNull LookupFocusDegree lookupFocusDegree) {
        if (lookupFocusDegree == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(1);
        }
        if (state.isDisposed()) {
            return;
        }
        LookupManager lookupManager = LookupManager.getInstance(project);
        final LookupImpl lookup2 = (LookupImpl)lookupManager.showLookup(editor, lookupItems.toArray(LookupElement.EMPTY_ARRAY));
        if (lookup2 == null) {
            return;
        }
        if (CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && editor.getUserData(InplaceRefactoring.INPLACE_RENAMER) == null) {
            lookup2.setStartCompletionWhenNothingMatches(true);
        }
        if (advertisingText != null) {
            lookup2.addAdvertisement(advertisingText, null);
        } else {
            ActionManager am = ActionManager.getInstance();
            String enterShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)am.getAction("EditorChooseLookupItem"));
            String tabShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)am.getAction("EditorChooseLookupItemReplace"));
            lookup2.addAdvertisement(LangBundle.message((String)"popup.advertisement.press.or.to.replace", (Object[])new Object[]{enterShortcut, tabShortcut}), null);
        }
        lookup2.setLookupFocusDegree(lookupFocusDegree);
        lookup2.refreshUi(true, true);
        this.myLookupShown = true;
        lookup2.addLookupListener(new LookupListener(){

            public void lookupCanceled(@NotNull LookupEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                lookup2.removeLookupListener(this);
                InteractiveTemplateStateProcessor.this.myLookupShown = false;
            }

            public void itemSelected(@NotNull LookupEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                lookup2.removeLookupListener(this);
                if (state.isFinished()) {
                    return;
                }
                InteractiveTemplateStateProcessor.this.myLookupShown = false;
                LookupElement item = event.getItem();
                if (item instanceof TemplateExpressionLookupElement) {
                    ((TemplateExpressionLookupElement)item).handleTemplateInsert(lookupItems, event.getCompletionChar());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/InteractiveTemplateStateProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupCanceled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "itemSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void insertSingleItem(Editor editor, List<TemplateExpressionLookupElement> lookupItems) {
        TemplateExpressionLookupElement first = lookupItems.get(0);
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)first.getLookupString());
        first.handleTemplateInsert(lookupItems, '\u0000');
    }

    @Override
    public boolean isLookupShown() {
        return this.myLookupShown;
    }

    @Override
    public boolean skipSettingFinalEditorState(Project project) {
        return !((TemplateManagerImpl)TemplateManager.getInstance(project)).shouldSkipInTests();
    }

    @Override
    public boolean isCaretOutsideCurrentSegment(Editor editor, TemplateSegments segments, int currentSegmentNumber, String commandName2) {
        if (editor != null && currentSegmentNumber >= 0) {
            int offset = editor.getCaretModel().getOffset();
            boolean hasSelection = editor.getSelectionModel().hasSelection();
            int segmentStart = segments.getSegmentStart(currentSegmentNumber);
            if (offset < segmentStart || !hasSelection && offset == segmentStart && ActionsBundle.actionText((String)"EditorBackSpace").equals(commandName2)) {
                return true;
            }
            int segmentEnd = segments.getSegmentEnd(currentSegmentNumber);
            if (offset > segmentEnd || !hasSelection && offset == segmentEnd && ActionsBundle.actionText((String)"EditorDelete").equals(commandName2)) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lookupFocusDegree";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/impl/InteractiveTemplateStateProcessor";
        objectArray[2] = "runLookup";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyBasicUndoableAction
    extends BasicUndoableAction
    implements Disposable {
        private final Project myProject;
        @Nullable
        private TemplateState myTemplateState;

        private MyBasicUndoableAction(@NotNull TemplateState templateState, Project project, @Nullable Document document) {
            DocumentReference[] documentReferenceArray;
            if (templateState == null) {
                MyBasicUndoableAction.$$$reportNull$$$0(0);
            }
            if (document != null) {
                DocumentReference[] documentReferenceArray2 = new DocumentReference[1];
                documentReferenceArray = documentReferenceArray2;
                documentReferenceArray2[0] = DocumentReferenceManager.getInstance().create(document);
            } else {
                documentReferenceArray = null;
            }
            super(documentReferenceArray);
            this.myTemplateState = templateState;
            this.myProject = project;
        }

        public void undo() {
            if (this.myTemplateState != null) {
                LookupManager.getInstance(this.myProject).hideActiveLookup();
                this.myTemplateState.cancelTemplate();
            }
        }

        public void redo() {
        }

        public void dispose() {
            this.myTemplateState = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/intellij/codeInsight/template/impl/InteractiveTemplateStateProcessor$MyBasicUndoableAction", "<init>"));
        }
    }
}

