/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.CommonBundle;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestProcessor<T>
extends DiffRequestProcessor {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestProcessor.class);
    @NotNull
    private final SoftHardCacheMap<T, DiffRequest> myRequestCache;
    @NotNull
    private final DiffTaskQueue myQueue;

    public CacheDiffRequestProcessor(@Nullable Project project) {
        super(project);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    public CacheDiffRequestProcessor(@Nullable Project project, @NotNull String place) {
        if (place == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        super(project, place);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    public CacheDiffRequestProcessor(@Nullable Project project, @NotNull UserDataHolder context) {
        if (context == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        super(project, context);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    @Nls
    @Nullable
    protected abstract String getRequestName(@NotNull T var1);

    protected abstract T getCurrentRequestProvider();

    @NotNull
    @RequiresBackgroundThread
    protected abstract DiffRequest loadRequest(@NotNull T var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException, DiffRequestProducerException;

    @Override
    protected void reloadRequest() {
        this.updateRequest(true, false, null);
    }

    @Override
    @RequiresEdt
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.updateRequest(force, true, scrollToChangePolicy);
    }

    @RequiresEdt
    public void updateRequest(boolean force, boolean useCache, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        DiffRequest cachedRequest;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.myQueue.abort();
        T requestProvider = this.getCurrentRequestProvider();
        if (requestProvider == null) {
            this.applyRequest((DiffRequest)NoDiffRequest.INSTANCE, force, scrollToChangePolicy);
            return;
        }
        DiffRequest diffRequest = cachedRequest = useCache ? this.loadRequestFast(requestProvider) : null;
        if (cachedRequest != null) {
            this.applyRequest(cachedRequest, force, scrollToChangePolicy);
            return;
        }
        this.myQueue.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> {
            DiffRequest request = this.doLoadRequest(requestProvider, (ProgressIndicator)indicator);
            return () -> {
                this.myRequestCache.put(requestProvider, request);
                this.applyRequest(request, force, scrollToChangePolicy);
            };
        }), () -> this.applyRequest((DiffRequest)new LoadingDiffRequest(this.getRequestName(requestProvider)), force, scrollToChangePolicy), this.getFastLoadingTimeMillis());
    }

    protected int getFastLoadingTimeMillis() {
        return 300;
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull T provider2) {
        if (provider2 == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return this.myRequestCache.get(provider2);
    }

    @NotNull
    private DiffRequest doLoadRequest(@NotNull T provider2, @NotNull ProgressIndicator indicator) {
        DiffRequest diffRequest;
        if (provider2 == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        String name = this.getRequestName(provider2);
        try {
            diffRequest = this.loadRequest(provider2, indicator);
        }
        catch (ProcessCanceledException e) {
            OperationCanceledDiffRequest request = new OperationCanceledDiffRequest(name);
            request.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new ReloadRequestAction(provider2)));
            OperationCanceledDiffRequest operationCanceledDiffRequest = request;
            if (operationCanceledDiffRequest == null) {
                CacheDiffRequestProcessor.$$$reportNull$$$0(6);
            }
            return operationCanceledDiffRequest;
        }
        catch (DiffRequestProducerException e) {
            return new ErrorDiffRequest(name, (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return new ErrorDiffRequest(name, (Throwable)e);
        }
        if (diffRequest == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        return diffRequest;
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        super.onDispose();
        this.myQueue.abort();
        this.myRequestCache.clear();
    }

    protected void dropCaches() {
        this.myRequestCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/CacheDiffRequestProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestFast";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doLoadRequest";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Simple
    extends CacheDiffRequestProcessor<DiffRequestProducer> {
        protected Simple(@Nullable Project project) {
            super(project);
        }

        protected Simple(@Nullable Project project, @NotNull String place) {
            if (place == null) {
                Simple.$$$reportNull$$$0(0);
            }
            super(project, place);
        }

        protected Simple(@Nullable Project project, @NotNull UserDataHolder context) {
            if (context == null) {
                Simple.$$$reportNull$$$0(1);
            }
            super(project, context);
        }

        @Override
        @Nullable
        protected String getRequestName(@NotNull DiffRequestProducer provider2) {
            if (provider2 == null) {
                Simple.$$$reportNull$$$0(2);
            }
            return provider2.getName();
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull DiffRequestProducer provider2, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            if (provider2 == null) {
                Simple.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                Simple.$$$reportNull$$$0(4);
            }
            DiffRequest diffRequest = provider2.process((UserDataHolder)this.getContext(), indicator);
            if (diffRequest == null) {
                Simple.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/CacheDiffRequestProcessor$Simple";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestProcessor$Simple";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRequestName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRequest";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class ReloadRequestAction
    extends DumbAwareAction {
        @NotNull
        private final T myProducer;

        public ReloadRequestAction(T provider2) {
            if (provider2 == null) {
                ReloadRequestAction.$$$reportNull$$$0(0);
            }
            super(CommonBundle.message((String)"action.text.reload", (Object[])new Object[0]), null, AllIcons.Actions.Refresh);
            this.myProducer = provider2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadRequestAction.$$$reportNull$$$0(1);
            }
            CacheDiffRequestProcessor.this.myRequestCache.remove(this.myProducer);
            CacheDiffRequestProcessor.this.updateRequest(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestProcessor$ReloadRequestAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

