/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAutoTestManager
implements PersistentStateComponent<State> {
    protected static final String AUTO_TEST_MANAGER_DELAY = "auto.test.manager.delay";
    protected static final int AUTO_TEST_MANAGER_DELAY_DEFAULT = 3000;
    private static final Key<ProcessListener> ON_TERMINATION_RESTARTER_KEY = Key.create((String)"auto.test.manager.on.termination.restarter");
    private final Project myProject;
    private final Set<RunProfile> myEnabledRunProfiles;
    protected int myDelayMillis;
    private AutoTestWatcher myWatcher;

    public AbstractAutoTestManager(@NotNull Project project) {
        if (project == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(0);
        }
        this.myEnabledRunProfiles = new HashSet<RunProfile>();
        this.myProject = project;
        this.myDelayMillis = PropertiesComponent.getInstance((Project)project).getInt(AUTO_TEST_MANAGER_DELAY, 3000);
        this.myWatcher = this.createWatcher(project);
    }

    @Nullable
    private static ExecutionEnvironment getCurrentEnvironment(@NotNull Content content2) {
        JComponent component2;
        if (content2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(1);
        }
        if ((component2 = content2.getComponent()) == null) {
            return null;
        }
        return (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component2));
    }

    private static void clearRestarterListener(@NotNull ProcessHandler processHandler2) {
        ProcessListener restarterListener;
        if (processHandler2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(2);
        }
        if ((restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2, null)) != null) {
            processHandler2.removeProcessListener(restarterListener);
            ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, null);
        }
    }

    private static void restart(@NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(3);
        }
        descriptor2.setActivateToolWindowWhenAdded(false);
        descriptor2.setReuseToolWindowActivation(true);
        ExecutionUtil.restart((RunContentDescriptor)descriptor2);
    }

    public static void saveConfigurationState(State state, RunProfile profile) {
        RunConfiguration runConfiguration = (RunConfiguration)ObjectUtils.tryCast((Object)profile, RunConfiguration.class);
        if (runConfiguration != null) {
            RunConfigurationDescriptor descriptor2 = new RunConfigurationDescriptor();
            descriptor2.myType = runConfiguration.getType().getId();
            descriptor2.myName = runConfiguration.getName();
            state.myEnabledRunConfigurations.add(descriptor2);
        }
    }

    public static List<RunConfiguration> loadConfigurations(State state, Project project) {
        ArrayList<RunConfiguration> configurations = new ArrayList<RunConfiguration>();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        List descriptors2 = ContainerUtil.notNullize(state.myEnabledRunConfigurations);
        for (RunConfigurationDescriptor descriptor2 : descriptors2) {
            RunnerAndConfigurationSettings settings;
            RunConfiguration configuration;
            if (descriptor2.myType == null || descriptor2.myName == null || (configuration = (settings = runManager.findConfigurationByTypeAndName(descriptor2.myType, descriptor2.myName)) != null ? settings.getConfiguration() : null) == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    @NotNull
    protected abstract AutoTestWatcher createWatcher(@NotNull Project var1);

    public void setAutoTestEnabled(@NotNull RunContentDescriptor descriptor2, @NotNull ExecutionEnvironment environment, boolean enabled) {
        Content content2;
        if (descriptor2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(5);
        }
        if ((content2 = descriptor2.getAttachedContent()) != null) {
            if (enabled) {
                this.myEnabledRunProfiles.add(environment.getRunProfile());
                this.myWatcher.activate();
            } else {
                ProcessHandler processHandler2;
                this.myEnabledRunProfiles.remove(environment.getRunProfile());
                if (!this.hasEnabledAutoTests()) {
                    this.myWatcher.deactivate();
                }
                if ((processHandler2 = descriptor2.getProcessHandler()) != null) {
                    AbstractAutoTestManager.clearRestarterListener(processHandler2);
                }
            }
        }
    }

    private boolean hasEnabledAutoTests() {
        RunContentManager contentManager2 = RunContentManager.getInstance((Project)this.myProject);
        for (RunContentDescriptor descriptor2 : contentManager2.getAllDescriptors()) {
            if (!this.isAutoTestEnabledForDescriptor(descriptor2)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoTestEnabled(@NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(6);
        }
        return this.isAutoTestEnabledForDescriptor(descriptor2);
    }

    private boolean isAutoTestEnabledForDescriptor(@NotNull RunContentDescriptor descriptor2) {
        Content content2;
        if (descriptor2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(7);
        }
        if ((content2 = descriptor2.getAttachedContent()) != null) {
            ExecutionEnvironment environment = AbstractAutoTestManager.getCurrentEnvironment(content2);
            return environment != null && this.myEnabledRunProfiles.contains(environment.getRunProfile());
        }
        return false;
    }

    protected void restartAllAutoTests(int modificationStamp) {
        RunContentManager contentManager2 = RunContentManager.getInstance((Project)this.myProject);
        boolean active = false;
        for (RunContentDescriptor descriptor2 : contentManager2.getAllDescriptors()) {
            if (!this.isAutoTestEnabledForDescriptor(descriptor2)) continue;
            this.restartAutoTest(descriptor2, modificationStamp, this.myWatcher);
            active = true;
        }
        if (!active) {
            this.myWatcher.deactivate();
        }
    }

    private void restartAutoTest(@NotNull RunContentDescriptor descriptor2, int modificationStamp, @NotNull AutoTestWatcher documentWatcher) {
        ProcessHandler processHandler2;
        if (descriptor2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(8);
        }
        if (documentWatcher == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(9);
        }
        if ((processHandler2 = descriptor2.getProcessHandler()) != null && !processHandler2.isProcessTerminated()) {
            this.scheduleRestartOnTermination(descriptor2, processHandler2, modificationStamp, documentWatcher);
        } else {
            AbstractAutoTestManager.restart(descriptor2);
        }
    }

    private void scheduleRestartOnTermination(final @NotNull RunContentDescriptor descriptor2, final @NotNull ProcessHandler processHandler2, final int modificationStamp, final @NotNull AutoTestWatcher watcher) {
        Object restarterListener;
        if (descriptor2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(10);
        }
        if (processHandler2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(11);
        }
        if (watcher == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(12);
        }
        if ((restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2)) != null) {
            AbstractAutoTestManager.clearRestarterListener(processHandler2);
        }
        restarterListener = new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractAutoTestManager.clearRestarterListener(processHandler2);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (AbstractAutoTestManager.this.isAutoTestEnabledForDescriptor(descriptor2) && watcher.isUpToDate(modificationStamp)) {
                        AbstractAutoTestManager.restart(descriptor2);
                    }
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/testframework/autotest/AbstractAutoTestManager$1", "processTerminated"));
            }
        };
        ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, restarterListener);
        processHandler2.addProcessListener(restarterListener);
    }

    int getDelay() {
        return this.myDelayMillis;
    }

    void setDelay(int delay) {
        this.myDelayMillis = delay;
        this.myWatcher.deactivate();
        this.myWatcher = this.createWatcher(this.myProject);
        if (this.hasEnabledAutoTests()) {
            this.myWatcher.activate();
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(AUTO_TEST_MANAGER_DELAY, this.myDelayMillis, 3000);
    }

    @Nullable
    public State getState() {
        State state = new State();
        for (RunProfile profile : this.myEnabledRunProfiles) {
            AbstractAutoTestManager.saveConfigurationState(state, profile);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(13);
        }
        List<RunConfiguration> configurations = AbstractAutoTestManager.loadConfigurations(state, this.myProject);
        this.myEnabledRunProfiles.clear();
        this.myEnabledRunProfiles.addAll(configurations);
        if (!configurations.isEmpty()) {
            this.myWatcher.activate();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWatcher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/autotest/AbstractAutoTestManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearRestarterListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "restart";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setAutoTestEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAutoTestEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAutoTestEnabledForDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "restartAutoTest";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleRestartOnTermination";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="run-configuration")
    static class RunConfigurationDescriptor {
        @Attribute(value="type")
        String myType;
        @Attribute(value="name")
        String myName;

        RunConfigurationDescriptor() {
        }
    }

    public static class State {
        @Tag(value="enabled-run-configurations")
        @XCollection
        List<RunConfigurationDescriptor> myEnabledRunConfigurations = new ArrayList<RunConfigurationDescriptor>();
    }
}

