/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.diagnostic.VMOptions;
import com.intellij.featureStatistics.fusCollectors.EventsIdentityThrottle;
import com.intellij.featureStatistics.fusCollectors.EventsRateThrottle;
import com.intellij.featureStatistics.fusCollectors.ThrowableDescription;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LifecycleUsageTriggerCollector
extends CounterUsagesCollector {
    private static final Logger LOG = Logger.getInstance(LifecycleUsageTriggerCollector.class);
    private static final EventLogGroup LIFECYCLE = new EventLogGroup("lifecycle", 58);
    private static final EventField<Boolean> eapField = EventFields.Boolean((String)"eap");
    private static final EventField<Boolean> testField = EventFields.Boolean((String)"test");
    private static final EventField<Boolean> commandLineField = EventFields.Boolean((String)"command_line");
    private static final EventField<Boolean> internalField = EventFields.Boolean((String)"internal");
    private static final EventField<Boolean> headlessField = EventFields.Boolean((String)"headless");
    private static final EventField<Boolean> debugAgentField = EventFields.Boolean((String)"debug_agent");
    private static final VarargEventId IDE_EVENT_START = LIFECYCLE.registerVarargEvent("ide.start", new EventField[]{eapField, testField, commandLineField, internalField, headlessField, debugAgentField});
    private static final EventId1<Boolean> IDE_CLOSE = LIFECYCLE.registerEvent("ide.close", (EventField)EventFields.Boolean((String)"restart"));
    private static final EventId1<Long> PROJECT_OPENING_FINISHED = LIFECYCLE.registerEvent("project.opening.finished", (EventField)EventFields.Long((String)"duration_ms"));
    private static final EventId PROJECT_OPENED = LIFECYCLE.registerEvent("project.opened");
    private static final EventId PROJECT_CLOSED = LIFECYCLE.registerEvent("project.closed");
    private static final EventId PROJECT_MODULE_ATTACHED = LIFECYCLE.registerEvent("project.module.attached");
    private static final EventId FRAME_ACTIVATED = LIFECYCLE.registerEvent("frame.activated");
    private static final EventId FRAME_DEACTIVATED = LIFECYCLE.registerEvent("frame.deactivated");
    private static final EventField<String> DURATION_GROUPED = new DurationEventField();
    private static final EventId2<Long, String> IDE_FREEZE = LIFECYCLE.registerEvent("ide.freeze", (EventField)EventFields.Long((String)"duration_ms"), DURATION_GROUPED);
    private static final EventField<String> errorField = EventFields.StringValidatedByCustomRule((String)"error", (String)"class_name");
    private static final EventField<VMOptions.MemoryKind> memoryErrorKindField = EventFields.Enum((String)"memory_error_kind", VMOptions.MemoryKind.class, kind -> StringUtil.toLowerCase((String)kind.name()));
    private static final EventField<Integer> errorHashField = EventFields.Int((String)"error_hash");
    private static final StringListEventField errorFramesField = EventFields.StringListValidatedByCustomRule((String)"error_frames", (String)"method_name");
    private static final EventField<Integer> errorSizeField = EventFields.Int((String)"error_size");
    private static final EventField<Boolean> tooManyErrorsField = EventFields.Boolean((String)"too_many_errors");
    private static final VarargEventId IDE_ERROR = LIFECYCLE.registerVarargEvent("ide.error", new EventField[]{EventFields.PluginInfo, errorField, memoryErrorKindField, errorHashField, errorFramesField, errorSizeField, tooManyErrorsField});
    private static final EventId IDE_CRASH_DETECTED = LIFECYCLE.registerEvent("ide.crash.detected");
    private static final EventField<ProjectOpenMode> projectOpenModeField = EventFields.Enum((String)"mode", ProjectOpenMode.class, mode -> StringUtil.toLowerCase((String)mode.name()));
    private static final EventId1<ProjectOpenMode> PROJECT_FRAME_SELECTED = LIFECYCLE.registerEvent("project.frame.selected", projectOpenModeField);
    private static final EventsRateThrottle ourErrorsRateThrottle = new EventsRateThrottle(100, 300000L);
    private static final EventsIdentityThrottle ourErrorsIdentityThrottle = new EventsIdentityThrottle(50, 3600000L);

    public EventLogGroup getGroup() {
        return LIFECYCLE;
    }

    public static void onIdeStart() {
        Application app = ApplicationManager.getApplication();
        IDE_EVENT_START.log(new EventPair[]{eapField.with((Object)app.isEAP()), testField.with((Object)StatisticsUploadAssistant.isTestStatisticsEnabled()), commandLineField.with((Object)app.isCommandLine()), internalField.with((Object)app.isInternal()), headlessField.with((Object)app.isHeadlessEnvironment()), debugAgentField.with((Object)DebugAttachDetector.isDebugEnabled())});
    }

    public static void onIdeClose(boolean restart) {
        IDE_CLOSE.log((Object)restart);
    }

    public static void onProjectOpenFinished(@NotNull Project project, long time) {
        if (project == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        PROJECT_OPENING_FINISHED.log(project, (Object)time);
    }

    public static void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        PROJECT_OPENED.log(project);
    }

    public static void onProjectClosed(@NotNull Project project) {
        if (project == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        PROJECT_CLOSED.log(project);
    }

    public static void onProjectModuleAttached(@NotNull Project project) {
        if (project == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        PROJECT_MODULE_ATTACHED.log(project);
    }

    public static void onFrameActivated(@Nullable Project project) {
        FRAME_ACTIVATED.log(project);
    }

    public static void onFrameDeactivated(@Nullable Project project) {
        FRAME_DEACTIVATED.log(project);
    }

    public static void onFreeze(long durationMs) {
        IDE_FREEZE.log((Object)durationMs, (Object)LifecycleUsageTriggerCollector.toLengthGroup((int)(durationMs / 1000L)));
    }

    public static void onError(@Nullable PluginId pluginId, @Nullable Throwable throwable, @Nullable VMOptions.MemoryKind memoryErrorKind) {
        try {
            ThrowableDescription description = new ThrowableDescription(throwable);
            ArrayList<EventPair> data2 = new ArrayList<EventPair>();
            data2.add(EventFields.PluginInfo.with((Object)(pluginId == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId))));
            data2.add(errorField.with((Object)description.getClassName()));
            if (memoryErrorKind != null) {
                data2.add(memoryErrorKindField.with((Object)memoryErrorKind));
            }
            if (ourErrorsRateThrottle.tryPass(System.currentTimeMillis())) {
                List<String> frames = description.getLastFrames(50);
                int framesHash = frames.hashCode();
                data2.add(errorHashField.with((Object)framesHash));
                if (ourErrorsIdentityThrottle.tryPass(framesHash, System.currentTimeMillis())) {
                    data2.add(errorFramesField.with(frames));
                    data2.add(errorSizeField.with((Object)description.getSize()));
                }
            } else {
                data2.add(tooManyErrorsField.with((Object)true));
            }
            IDE_ERROR.log(data2.toArray(new EventPair[0]));
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void onCrashDetected() {
        IDE_CRASH_DETECTED.log();
    }

    @NotNull
    private static String toLengthGroup(int seconds) {
        if (seconds >= 60) {
            return "60s+";
        }
        if (seconds > 10) {
            seconds -= seconds % 10;
            String string = seconds + "s+";
            if (string == null) {
                LifecycleUsageTriggerCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = seconds + "s";
        if (string == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void onProjectFrameSelected(int option2) {
        ProjectOpenMode optionValue;
        switch (option2) {
            case 0: {
                optionValue = ProjectOpenMode.New;
                break;
            }
            case 1: {
                optionValue = ProjectOpenMode.Same;
                break;
            }
            case 2: {
                optionValue = ProjectOpenMode.Attach;
                break;
            }
            default: {
                return;
            }
        }
        PROJECT_FRAME_SELECTED.log((Object)optionValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toLengthGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpenFinished";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onProjectClosed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onProjectModuleAttached";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DurationEventField
    extends PrimitiveEventField<String> {
        private DurationEventField() {
        }

        @NotNull
        public List<String> getValidationRule() {
            List<String> list2 = Arrays.asList("{regexp#integer}s", "-{regexp#integer}s", "{regexp#integer}s+");
            if (list2 == null) {
                DurationEventField.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void addData(@NotNull FeatureUsageData fuData, String value2) {
            if (fuData == null) {
                DurationEventField.$$$reportNull$$$0(1);
            }
            if (value2 != null) {
                fuData.addData(this.getName(), value2);
            }
        }

        @NotNull
        public String getName() {
            return "duration_grouped";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector$DurationEventField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fuData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidationRule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector$DurationEventField";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum ProjectOpenMode {
        New,
        Same,
        Attach;

    }
}

