/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actionMacro.ActionMacro;
import com.intellij.ide.actionMacro.ActionMacroManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ActionMacroConfigurationPanel
implements Disposable {
    private static final String SPLITTER_PROPORTION = "ActionMacroConfigurationPanel.SPLITTER_PROPORTION";
    private Splitter mySplitter;
    private final JList myMacrosList;
    private final JList myMacroActionsList;
    final DefaultListModel myMacrosModel = new DefaultListModel();
    private List<Couple<String>> myRenamingList;

    public ActionMacroConfigurationPanel() {
        this.myMacrosList = new JBList();
        this.myMacroActionsList = new JBList();
        this.myMacrosList.setSelectionMode(0);
        this.myMacroActionsList.setSelectionMode(0);
        this.myMacrosList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                if (selIndex == -1) {
                    ((DefaultListModel)ActionMacroConfigurationPanel.this.myMacroActionsList.getModel()).removeAllElements();
                } else {
                    ActionMacroConfigurationPanel.this.initActionList((ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(selIndex));
                }
            }
        });
    }

    public void reset() {
        ActionMacro[] allMacros;
        for (ActionMacro macro : allMacros = ActionMacroManager.getInstance().getAllMacros()) {
            this.myMacrosModel.addElement(macro.clone());
        }
        this.myMacrosList.setModel(this.myMacrosModel);
        ScrollingUtil.ensureSelectionExists((JList)this.myMacrosList);
    }

    public void apply() {
        if (this.myRenamingList != null) {
            for (Couple<String> pair : this.myRenamingList) {
                Keymap[] allKeymaps = KeymapManagerEx.getInstanceEx().getAllKeymaps();
                for (ActionMacro actionMacro : allKeymaps) {
                    actionMacro.removeAllActionShortcuts("Macro." + (String)pair.getSecond());
                    for (Shortcut shortcut : actionMacro.getShortcuts("Macro." + (String)pair.getFirst())) {
                        actionMacro.addShortcut("Macro." + (String)pair.getSecond(), shortcut);
                    }
                    actionMacro.removeAllActionShortcuts("Macro." + (String)pair.getFirst());
                }
            }
        }
        ActionMacroManager manager2 = ActionMacroManager.getInstance();
        ActionMacro[] macros = manager2.getAllMacros();
        HashSet<String> removedIds = new HashSet<String>();
        for (ActionMacro actionMacro : macros) {
            removedIds.add(actionMacro.getActionId());
        }
        manager2.removeAllMacros();
        Enumeration newMacros = this.myMacrosModel.elements();
        while (newMacros.hasMoreElements()) {
            ActionMacro macro = (ActionMacro)newMacros.nextElement();
            manager2.addMacro(macro);
            removedIds.remove(macro.getActionId());
        }
        manager2.registerActions(ActionManager.getInstance());
        for (String id2 : removedIds) {
            Keymap[] keymapArray = KeymapManagerEx.getInstanceEx().getAllKeymaps();
            for (Shortcut shortcut : keymapArray) {
                shortcut.removeAllActionShortcuts(id2);
            }
        }
    }

    public boolean isModified() {
        ActionMacro[] allMacros = ActionMacroManager.getInstance().getAllMacros();
        if (allMacros.length != this.myMacrosModel.getSize()) {
            return true;
        }
        for (int i2 = 0; i2 < allMacros.length; ++i2) {
            ActionMacro macro = allMacros[i2];
            ActionMacro newMacro = (ActionMacro)this.myMacrosModel.get(i2);
            if (macro.equals(newMacro)) continue;
            return true;
        }
        return false;
    }

    private void initActionList(ActionMacro macro) {
        ActionMacro.ActionDescriptor[] actions;
        DefaultListModel<ActionMacro.ActionDescriptor> actionModel = new DefaultListModel<ActionMacro.ActionDescriptor>();
        for (ActionMacro.ActionDescriptor action2 : actions = macro.getActions()) {
            actionModel.addElement(action2);
        }
        this.myMacroActionsList.setModel(actionModel);
        ScrollingUtil.ensureSelectionExists((JList)this.myMacroActionsList);
    }

    public JPanel getPanel() {
        if (this.mySplitter == null) {
            this.mySplitter = new Splitter(false, 0.5f);
            String value2 = PropertiesComponent.getInstance().getValue(SPLITTER_PROPORTION);
            if (value2 != null) {
                this.mySplitter.setProportion(Float.parseFloat(value2));
            }
            this.mySplitter.setFirstComponent((JComponent)ToolbarDecorator.createDecorator((JList)this.myMacrosList).setEditAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button2) {
                    String newName2;
                    int selIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                    if (selIndex == -1) {
                        return;
                    }
                    ActionMacro macro = (ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(selIndex);
                    do {
                        if ((newName2 = Messages.showInputDialog((Component)ActionMacroConfigurationPanel.this.mySplitter, (String)IdeBundle.message((String)"prompt.enter.new.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.macro", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)macro.getName(), null)) != null && !macro.getName().equals(newName2)) continue;
                        return;
                    } while (!this.canRenameMacro(newName2));
                    if (ActionMacroConfigurationPanel.this.myRenamingList == null) {
                        ActionMacroConfigurationPanel.this.myRenamingList = new ArrayList<Couple<String>>();
                    }
                    ActionMacroConfigurationPanel.this.myRenamingList.add((Couple<String>)Couple.of((Object)macro.getName(), (Object)newName2));
                    macro.setName(newName2);
                    ActionMacroConfigurationPanel.this.myMacrosList.repaint();
                }

                private boolean canRenameMacro(String name) {
                    Enumeration elements2 = ActionMacroConfigurationPanel.this.myMacrosModel.elements();
                    while (elements2.hasMoreElements()) {
                        ActionMacro macro = (ActionMacro)elements2.nextElement();
                        if (!macro.getName().equals(name)) continue;
                        if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"title.macro.name.already.used", (Object[])new Object[0]), (String)IdeBundle.message((String)"message.macro.exists", (Object[])new Object[]{name})).icon(Messages.getWarningIcon())).ask((Component)ActionMacroConfigurationPanel.this.mySplitter)) {
                            return false;
                        }
                        ActionMacroConfigurationPanel.this.myMacrosModel.removeElement(macro);
                        break;
                    }
                    return true;
                }
            }).disableAddAction().disableUpDownActions().createPanel());
            this.mySplitter.setSecondComponent((JComponent)ToolbarDecorator.createDecorator((JList)this.myMacroActionsList).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button2) {
                    int macrosSelectedIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                    if (macrosSelectedIndex != -1) {
                        ActionMacro macro = (ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(macrosSelectedIndex);
                        macro.deleteAction(ActionMacroConfigurationPanel.this.myMacroActionsList.getSelectedIndex());
                    }
                    ListUtil.removeSelectedItems((JList)ActionMacroConfigurationPanel.this.myMacroActionsList);
                }
            }).disableAddAction().disableUpDownActions().createPanel());
        }
        return this.mySplitter;
    }

    public void dispose() {
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION, Float.toString(this.mySplitter.getProportion()));
    }
}

