/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import java.awt.event.InputEvent;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileAction
extends CreateElementActionBase
implements DumbAware {
    public CreateFileAction() {
        super(ActionsBundle.messagePointer((String)"action.NewFile.text", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.create.new.file.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
    }

    public CreateFileAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    public CreateFileAction(Supplier<String> dynamicText, Supplier<String> dynamicDescription, Icon icon2) {
        super(dynamicText, dynamicDescription, icon2);
    }

    public boolean isDumbAware() {
        return CreateFileAction.class.equals(((Object)((Object)this)).getClass());
    }

    protected PsiElement @NotNull [] invokeDialog(Project project, PsiDirectory directory) {
        if (PsiElement.EMPTY_ARRAY == null) {
            CreateFileAction.$$$reportNull$$$0(0);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected void invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull java.util.function.Consumer<PsiElement[]> elementsConsumer) {
        if (project == null) {
            CreateFileAction.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            CreateFileAction.$$$reportNull$$$0(2);
        }
        if (elementsConsumer == null) {
            CreateFileAction.$$$reportNull$$$0(3);
        }
        MyValidator validator = new MyValidator(project, directory);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                elementsConsumer.accept(validator.create("test"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
            this.createLightWeightPopup(validator, elementsConsumer, directory).showCenteredInCurrentWindow(project);
        } else {
            Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.file.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), null, null, (InputValidator)validator);
            elementsConsumer.accept(validator.getCreatedElements());
        }
    }

    private JBPopup createLightWeightPopup(CreateElementActionBase.MyInputValidator validator, java.util.function.Consumer<PsiElement[]> consumer2, @NotNull PsiDirectory directory) {
        if (directory == null) {
            CreateFileAction.$$$reportNull$$$0(4);
        }
        Project project = directory.getProject();
        NewItemSimplePopupPanel contentPanel2 = new NewItemSimplePopupPanel();
        JTextField nameField = contentPanel2.getTextField();
        JBPopup popup2 = NewItemPopupUtil.createNewItemPopup(IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), (JComponent)((Object)contentPanel2), nameField);
        contentPanel2.setApplyAction((Consumer<? super InputEvent>)((Consumer)event -> {
            String name = nameField.getText();
            if (validator.checkInput(name) && validator.canClose(name)) {
                popup2.closeOk(event);
                consumer2.accept(validator.getCreatedElements());
                if (StringUtil.isNotEmpty((String)name)) {
                    FileTypeChooser.getKnownFileTypeOrAssociate(directory.getVirtualFile(), this.getFileName(name), project);
                }
            } else {
                String errorMessage = validator instanceof InputValidatorEx ? ((InputValidatorEx)validator).getErrorText(name) : LangBundle.message((String)"incorrect.name", (Object[])new Object[0]);
                contentPanel2.setError(errorMessage);
            }
        }));
        return popup2;
    }

    protected PsiElement @NotNull [] create(@NotNull String newName2, PsiDirectory directory) throws Exception {
        if (newName2 == null) {
            CreateFileAction.$$$reportNull$$$0(5);
        }
        MkDirs mkdirs = new MkDirs(newName2, directory);
        PsiElement[] psiElementArray = new PsiElement[]{(PsiElement)WriteAction.compute(() -> mkdirs.directory.createFile(this.getFileName(mkdirs.newName)))};
        if (psiElementArray == null) {
            CreateFileAction.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    public static PsiDirectory findOrCreateSubdirectory(@NotNull PsiDirectory parent, @NotNull String subdirName) {
        PsiDirectory sub;
        if (parent == null) {
            CreateFileAction.$$$reportNull$$$0(7);
        }
        if (subdirName == null) {
            CreateFileAction.$$$reportNull$$$0(8);
        }
        return (sub = parent.findSubdirectory(subdirName)) == null ? (PsiDirectory)WriteAction.compute(() -> parent.createSubdirectory(subdirName)) : sub;
    }

    protected String getActionName(PsiDirectory directory, String newName2) {
        return IdeBundle.message((String)"progress.creating.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), File.separator, newName2});
    }

    protected String getErrorTitle() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    protected String getFileName(String newName2) {
        if (this.getDefaultExtension() == null || !FileUtilRt.getExtension((String)newName2).isEmpty()) {
            return newName2;
        }
        return newName2 + "." + this.getDefaultExtension();
    }

    @Nullable
    protected String getDefaultExtension() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateFileAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateFileAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLightWeightPopup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSubdirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyValidator
    extends CreateElementActionBase.MyInputValidator
    implements InputValidatorEx {
        private @NlsContexts.DetailedDescription String myErrorText;

        public MyValidator(Project project, PsiDirectory directory) {
            super((CreateElementActionBase)CreateFileAction.this, project, directory);
        }

        public boolean checkInput(String inputString) {
            StringTokenizer tokenizer = new StringTokenizer(inputString, "\\/");
            VirtualFile vFile = this.getDirectory().getVirtualFile();
            boolean firstToken = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((token.equals(".") || token.equals("..")) && !tokenizer.hasMoreTokens()) {
                    this.myErrorText = IdeBundle.message((String)"error.invalid.file.name", (Object[])new Object[]{token});
                    return false;
                }
                if (vFile != null) {
                    if (firstToken && "~".equals(token)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            this.myErrorText = IdeBundle.message((String)"error.user.home.directory.not.found", (Object[])new Object[0]);
                            return false;
                        }
                        vFile = userHomeDir;
                    } else if ("..".equals(token)) {
                        VirtualFile parent = vFile.getParent();
                        if (parent == null) {
                            this.myErrorText = IdeBundle.message((String)"error.invalid.directory", (Object[])new Object[]{vFile.getPresentableUrl() + File.separatorChar + ".."});
                            return false;
                        }
                        vFile = parent;
                    } else if (!".".equals(token)) {
                        VirtualFile child2 = vFile.findChild(token);
                        if (child2 != null) {
                            if (!child2.isDirectory()) {
                                this.myErrorText = IdeBundle.message((String)"error.file.with.name.already.exists", (Object[])new Object[]{token});
                                return false;
                            }
                            if (!tokenizer.hasMoreTokens()) {
                                this.myErrorText = IdeBundle.message((String)"error.directory.with.name.already.exists", (Object[])new Object[]{token});
                                return false;
                            }
                        }
                        vFile = child2;
                    }
                }
                if (FileTypeManager.getInstance().isFileIgnored(CreateFileAction.this.getFileName(token))) {
                    this.myErrorText = IdeBundle.message((String)"warning.create.directory.with.ignored.name", (Object[])new Object[]{token});
                    return true;
                }
                firstToken = false;
            }
            this.myErrorText = null;
            return true;
        }

        public String getErrorText(String inputString) {
            return this.myErrorText;
        }

        public boolean canClose(String inputString) {
            if (inputString.isEmpty()) {
                return super.canClose(inputString);
            }
            return super.canClose(CreateFileAction.this.getFileName(inputString));
        }
    }

    public static class MkDirs {
        public final String newName;
        public final PsiDirectory directory;

        public MkDirs(@NotNull String newName2, @NotNull PsiDirectory directory) {
            if (newName2 == null) {
                MkDirs.$$$reportNull$$$0(0);
            }
            if (directory == null) {
                MkDirs.$$$reportNull$$$0(1);
            }
            if (SystemInfo.isWindows) {
                newName2 = newName2.replace('\\', '/');
            }
            if (newName2.contains("/")) {
                List subDirs = StringUtil.split((String)newName2, (String)"/");
                newName2 = (String)subDirs.remove(subDirs.size() - 1);
                boolean firstToken = true;
                for (String dir : subDirs) {
                    if (firstToken && "~".equals(dir)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        PsiDirectory directory1 = directory.getManager().findDirectory(userHomeDir);
                        if (directory1 == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        directory = directory1;
                    } else if ("..".equals(dir)) {
                        PsiDirectory parentDirectory = directory.getParentDirectory();
                        if (parentDirectory == null) {
                            throw new IncorrectOperationException("Not a valid directory");
                        }
                        directory = parentDirectory;
                    } else if (!".".equals(dir)) {
                        directory = CreateFileAction.findOrCreateSubdirectory(directory, dir);
                    }
                    firstToken = false;
                }
            }
            this.newName = newName2;
            this.directory = directory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/CreateFileAction$MkDirs";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

