/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.OpenUntrustedProjectChoice;
import com.intellij.ide.impl.TrustChangeNotifier;
import com.intellij.ide.impl.TrustedCheckResult;
import com.intellij.ide.impl.TrustedPathsSettings;
import com.intellij.ide.impl.TrustedProjectSettings;
import com.intellij.ide.impl.TrustedProjectsStatistics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000e0\b\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\b\u0010\u0017\u001a\u00020\u0004H\u0002\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0006\u001a\n\u0010\u001a\u001a\u00020\u0019*\u00020\u0006\u001a\n\u0010\u001b\u001a\u00020\u0004*\u00020\u0006\u001a\u0012\u0010\u001c\u001a\u00020\u001d*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0004\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "confirmLoadingUntrustedProject", "", "project", "Lcom/intellij/openapi/project/Project;", "createDialog", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/MessageDialogBuilder$YesNo;", "confirmOpeningUntrustedProject", "Lcom/intellij/ide/impl/OpenUntrustedProjectChoice;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/ui/MessageDialogBuilder$YesNoCancel;", "createDoNotAskOptionForLocation", "Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "projectLocationPath", "", "isProjectImplicitlyTrusted", "Lcom/intellij/ide/impl/TrustedCheckResult;", "projectDir", "Ljava/nio/file/Path;", "isTrustedCheckDisabled", "getExplicitTrustedStateOrByHostAndLocation", "Lcom/intellij/util/ThreeState;", "getTrustedState", "isTrusted", "setTrusted", "", "value", "intellij.platform.ide.impl"})
@JvmName(name="TrustedProjects")
public final class TrustedProjects {
    private static final Logger LOG;

    @NotNull
    public static final OpenUntrustedProjectChoice confirmOpeningUntrustedProject(@NotNull VirtualFile virtualFile, @NotNull Function0<MessageDialogBuilder.YesNoCancel> createDialog2) {
        OpenUntrustedProjectChoice openUntrustedProjectChoice;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(createDialog2, (String)"createDialog");
        VirtualFile projectDir = virtualFile.isDirectory() ? virtualFile : virtualFile.getParent();
        TrustedCheckResult trustedCheckResult = TrustedProjects.isProjectImplicitlyTrusted(projectDir.toNioPath());
        if (trustedCheckResult instanceof TrustedCheckResult.Trusted) {
            return OpenUntrustedProjectChoice.IMPORT;
        }
        MessageDialogBuilder.YesNoCancel yesNoCancel = (MessageDialogBuilder.YesNoCancel)createDialog2.invoke();
        VirtualFile virtualFile2 = projectDir;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"projectDir");
        VirtualFile virtualFile3 = virtualFile2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"projectDir.parent");
        String string = virtualFile3.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectDir.parent.path");
        int choice = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel.doNotAsk(TrustedProjects.createDoNotAskOptionForLocation(string))).asWarning()).show(null);
        switch (choice) {
            case 0: {
                openUntrustedProjectChoice = OpenUntrustedProjectChoice.IMPORT;
                break;
            }
            case 1: {
                openUntrustedProjectChoice = OpenUntrustedProjectChoice.OPEN_WITHOUT_IMPORTING;
                break;
            }
            case 2: {
                openUntrustedProjectChoice = OpenUntrustedProjectChoice.CANCEL;
                break;
            }
            default: {
                LOG.error("Illegal choice " + choice);
                return OpenUntrustedProjectChoice.CANCEL;
            }
        }
        OpenUntrustedProjectChoice openChoice = openUntrustedProjectChoice;
        TrustedProjectsStatistics.Companion.getNEW_PROJECT_OPEN_OR_IMPORT_CHOICE().log((Object)openChoice);
        return openChoice;
    }

    public static final boolean confirmLoadingUntrustedProject(@NotNull Project project, @NotNull Function0<MessageDialogBuilder.YesNo> createDialog2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(createDialog2, (String)"createDialog");
        TrustedCheckResult trustedCheckResult = TrustedProjects.isProjectImplicitlyTrusted(project);
        if (trustedCheckResult instanceof TrustedCheckResult.Trusted) {
            TrustedProjects.setTrusted(project, true);
            return true;
        }
        boolean answer = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)createDialog2.invoke()).asWarning()).ask(project);
        TrustedProjects.setTrusted(project, answer);
        TrustedProjectsStatistics.Companion.getLOAD_UNTRUSTED_PROJECT_CONFIRMATION_CHOICE().log((Object)answer);
        return answer;
    }

    public static final boolean isTrusted(@NotNull Project $this$isTrusted) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrusted, (String)"$this$isTrusted");
        Project $this$service$iv = $this$isTrusted;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return ((TrustedProjectSettings)((Object)object)).getTrustedState() == ThreeState.YES;
    }

    @NotNull
    public static final ThreeState getTrustedState(@NotNull Project $this$getTrustedState) {
        Intrinsics.checkNotNullParameter((Object)$this$getTrustedState, (String)"$this$getTrustedState");
        Project $this$service$iv = $this$getTrustedState;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return ((TrustedProjectSettings)((Object)object)).getTrustedState();
    }

    @NotNull
    public static final ThreeState getExplicitTrustedStateOrByHostAndLocation(@NotNull Project $this$getExplicitTrustedStateOrByHostAndLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$getExplicitTrustedStateOrByHostAndLocation, (String)"$this$getExplicitTrustedStateOrByHostAndLocation");
        ThreeState explicit = TrustedProjects.getTrustedState($this$getExplicitTrustedStateOrByHostAndLocation);
        if (explicit != ThreeState.UNSURE) {
            return explicit;
        }
        return TrustedProjects.isProjectImplicitlyTrusted($this$getExplicitTrustedStateOrByHostAndLocation) instanceof TrustedCheckResult.Trusted ? ThreeState.YES : ThreeState.UNSURE;
    }

    public static final void setTrusted(@NotNull Project $this$setTrusted, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)$this$setTrusted, (String)"$this$setTrusted");
        Project $this$service$iv = $this$setTrusted;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        TrustedProjectSettings trustedProjectSettings = (TrustedProjectSettings)((Object)object);
        ThreeState threeState = ThreeState.fromBoolean((boolean)value2);
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"ThreeState.fromBoolean(value)");
        trustedProjectSettings.setTrustedState(threeState);
        if (value2) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((TrustChangeNotifier)application.getMessageBus().syncPublisher(TrustChangeNotifier.TOPIC)).projectTrusted($this$setTrusted);
        }
    }

    @NotNull
    public static final DialogWrapper.DoNotAskOption createDoNotAskOptionForLocation(@NotNull String projectLocationPath) {
        Intrinsics.checkNotNullParameter((Object)projectLocationPath, (String)"projectLocationPath");
        return (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(projectLocationPath){
            final /* synthetic */ String $projectLocationPath;

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode == 0) {
                    TrustedProjectsStatistics.Companion.getTRUST_LOCATION_CHECKBOX_SELECTED().log();
                    boolean $i$f$service = false;
                    Object object = ApplicationManager.getApplication().getService(TrustedPathsSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
                    ((TrustedPathsSettings)((Object)object)).addTrustedPath(this.$projectLocationPath);
                }
            }

            @NotNull
            public String getDoNotShowMessage() {
                String path = FileUtil.getLocationRelativeToUserHome((String)this.$projectLocationPath, (boolean)false);
                String string = IdeBundle.message((String)"untrusted.project.warning.trust.location.checkbox", (Object[])new Object[]{path});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"untru\u2026location.checkbox\", path)");
                return string;
            }
            {
                this.$projectLocationPath = $captured_local_variable$0;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTrustedCheckDisabled() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) return true;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isHeadlessEnvironment()) return true;
        if (!SystemProperties.is((String)"idea.is.integration.test")) return false;
        return true;
    }

    private static final TrustedCheckResult isProjectImplicitlyTrusted(Project project) {
        Path path;
        String string = project.getBasePath();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        return TrustedProjects.isProjectImplicitlyTrusted(path);
    }

    private static final TrustedCheckResult isProjectImplicitlyTrusted(Path projectDir) {
        if (TrustedProjects.isTrustedCheckDisabled()) {
            return TrustedCheckResult.Trusted.INSTANCE;
        }
        if (projectDir != null) {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(TrustedPathsSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            if (((TrustedPathsSettings)((Object)object)).isPathTrusted(projectDir)) {
                TrustedProjectsStatistics.Companion.getPROJECT_IMPLICITLY_TRUSTED_BY_PATH().log();
                return TrustedCheckResult.Trusted.INSTANCE;
            }
        }
        return new TrustedCheckResult.NotTrusted(null);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.intellij.ide.impl.TrustedProjects");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"com.\u2026de.impl.TrustedProjects\")");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isTrustedCheckDisabled() {
        return TrustedProjects.isTrustedCheckDisabled();
    }
}

