/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProjectViewSettings
extends ViewSettings {
    default public boolean isShowExcludedFiles() {
        return true;
    }

    default public boolean isShowVisibilityIcons() {
        return false;
    }

    default public boolean isUseFileNestingRules() {
        return true;
    }

    public static final class Delegate
    implements ProjectViewSettings {
        private final Project project;
        private final String id;

        public Delegate(@NotNull Project project, @Nullable String id2) {
            if (project == null) {
                Delegate.$$$reportNull$$$0(0);
            }
            this.project = project;
            this.id = id2;
        }

        @Override
        public boolean isShowExcludedFiles() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowExcludedFiles(this.getPaneID(view));
        }

        @Override
        public boolean isShowVisibilityIcons() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowVisibilityIcons(this.getPaneID(view));
        }

        @Override
        public boolean isUseFileNestingRules() {
            ProjectViewSettings settings = this.getProjectViewSettings();
            return settings != null && settings.isUseFileNestingRules();
        }

        public boolean isFoldersAlwaysOnTop() {
            ProjectView view = this.getProjectView();
            return view != null && view.isFoldersAlwaysOnTop(this.getPaneID(view));
        }

        public boolean isShowMembers() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowMembers(this.getPaneID(view));
        }

        public boolean isShowModules() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowModules(this.getPaneID(view));
        }

        public boolean isFlattenModules() {
            ProjectView view = this.getProjectView();
            return view != null && view.isFlattenModules(this.getPaneID(view));
        }

        public boolean isShowURL() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowURL(this.getPaneID(view));
        }

        public boolean isFlattenPackages() {
            ProjectViewDirectoryHelper helper = this.getProjectViewDirectoryHelper();
            if (helper == null || !helper.supportsFlattenPackages()) {
                return false;
            }
            ProjectView view = this.getProjectView();
            return view != null && view.isFlattenPackages(this.getPaneID(view));
        }

        public boolean isAbbreviatePackageNames() {
            ProjectView view = this.getProjectView();
            return view != null && view.isAbbreviatePackageNames(this.getPaneID(view));
        }

        public boolean isHideEmptyMiddlePackages() {
            ProjectViewDirectoryHelper helper = this.getProjectViewDirectoryHelper();
            if (helper == null || !helper.supportsHideEmptyMiddlePackages()) {
                return false;
            }
            ProjectView view = this.getProjectView();
            return view != null && view.isHideEmptyMiddlePackages(this.getPaneID(view));
        }

        public boolean isCompactDirectories() {
            ProjectView view = this.getProjectView();
            return view != null && view.isCompactDirectories(this.getPaneID(view));
        }

        public boolean isShowLibraryContents() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowLibraryContents(this.getPaneID(view));
        }

        @Nullable
        private ProjectViewDirectoryHelper getProjectViewDirectoryHelper() {
            return this.project.isDisposed() ? null : ProjectViewDirectoryHelper.getInstance(this.project);
        }

        @Nullable
        private ProjectView getProjectView() {
            return this.project.isDisposed() ? null : ProjectView.getInstance(this.project);
        }

        @Nullable
        private String getPaneID(@NotNull ProjectView view) {
            if (view == null) {
                Delegate.$$$reportNull$$$0(1);
            }
            return this.id != null ? this.id : view.getCurrentViewId();
        }

        @Nullable
        private AbstractTreeStructure getStructure(@NotNull ProjectView view) {
            if (view == null) {
                Delegate.$$$reportNull$$$0(2);
            }
            AbstractProjectViewPane pane2 = this.id == null ? view.getCurrentProjectViewPane() : view.getProjectViewPaneById(this.id);
            return pane2 == null ? null : pane2.getTreeStructure();
        }

        @Nullable
        private ProjectViewSettings getProjectViewSettings() {
            ProjectView view = this.getProjectView();
            AbstractTreeStructure structure = view == null ? null : this.getStructure(view);
            return structure instanceof ProjectViewSettings ? (ProjectViewSettings)structure : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/ProjectViewSettings$Delegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPaneID";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStructure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Immutable
    extends ViewSettings.Immutable
    implements ProjectViewSettings {
        public static final ProjectViewSettings DEFAULT = new Immutable(null);
        private final boolean myShowExcludedFiles;
        private final boolean myShowVisibilityIcons;
        private final boolean myUseFileNestingRules;

        public Immutable(ProjectViewSettings settings) {
            super((ViewSettings)settings);
            this.myShowExcludedFiles = settings == null || settings.isShowExcludedFiles();
            this.myShowVisibilityIcons = settings != null && settings.isShowVisibilityIcons();
            this.myUseFileNestingRules = settings == null || settings.isUseFileNestingRules();
        }

        @Override
        public boolean isShowExcludedFiles() {
            return this.myShowExcludedFiles;
        }

        @Override
        public boolean isShowVisibilityIcons() {
            return this.myShowVisibilityIcons;
        }

        @Override
        public boolean isUseFileNestingRules() {
            return this.myUseFileNestingRules;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            ProjectViewSettings settings = (ProjectViewSettings)object;
            return settings.isShowExcludedFiles() == this.isShowExcludedFiles() && settings.isShowVisibilityIcons() == this.isShowVisibilityIcons() && settings.isUseFileNestingRules() == this.isUseFileNestingRules();
        }

        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + Boolean.hashCode(this.isShowExcludedFiles());
            result2 = 31 * result2 + Boolean.hashCode(this.isShowVisibilityIcons());
            result2 = 31 * result2 + Boolean.hashCode(this.isUseFileNestingRules());
            return result2;
        }
    }
}

