/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.actions.QuickChangeLookAndFeel;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.LafProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.IntelliJLookAndFeelInfo;
import com.intellij.ide.ui.laf.MenuArrowIcon;
import com.intellij.ide.ui.laf.PluggableLafInfo;
import com.intellij.ide.ui.laf.SystemDarkThemeDetector;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.DefaultLinkButtonUI;
import com.intellij.ui.popup.OurHeavyWeightPopup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FontUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SVGLoader;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import kotlin.Lazy;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.TestOnly;

@State(name="LafManager", storages={@Storage(value="laf.xml", roamingType=RoamingType.PER_OS)})
public final class LafManagerImpl
extends LafManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(LafManager.class);
    @NonNls
    private static final String ELEMENT_LAF = "laf";
    @NonNls
    private static final String ELEMENT_PREFERRED_LIGHT_LAF = "preferred-light-laf";
    @NonNls
    private static final String ELEMENT_PREFERRED_DARK_LAF = "preferred-dark-laf";
    @NonNls
    private static final String ATTRIBUTE_AUTODETECT = "autodetect";
    @NonNls
    private static final String ATTRIBUTE_CLASS_NAME = "class-name";
    @NonNls
    private static final String ATTRIBUTE_THEME_NAME = "themeId";
    private static final String DEFAULT_LIGHT_THEME_ID = "JetBrainsLightTheme";
    private static final String DARCULA_EDITOR_THEME_KEY = "Darcula.SavedEditorTheme";
    private static final String DEFAULT_EDITOR_THEME_KEY = "Default.SavedEditorTheme";
    @NonNls
    private static final String[] ourPatchableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
    @PropertyKey(resourceBundle="messages.IdeBundle")
    @NonNls
    private static final @PropertyKey(resourceBundle="messages.IdeBundle") @NonNls String[] ourFileChooserTextKeys = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
    private final EventDispatcher<LafManagerListener> myEventDispatcher = EventDispatcher.create(LafManagerListener.class);
    private final SynchronizedClearableLazy<List<UIManager.LookAndFeelInfo>> myLaFs = new SynchronizedClearableLazy(() -> {
        Activity activity = StartUpMeasurer.startActivity((String)"compute LaF list");
        List<UIManager.LookAndFeelInfo> infos = this.computeLafList();
        activity.end();
        return infos;
    });
    private final UIManager.LookAndFeelInfo myDefaultLightLaf = LafManagerImpl.getDefaultLightTheme();
    private final UIManager.LookAndFeelInfo myDefaultDarkLaf = new DarculaLookAndFeelInfo();
    private final Map<Object, Object> ourDefaults = (UIDefaults)UIManager.getDefaults().clone();
    private UIManager.LookAndFeelInfo myCurrentLaf;
    private UIManager.LookAndFeelInfo myPreferredLightLaf;
    private UIManager.LookAndFeelInfo myPreferredDarkLaf;
    private final Map<LafManager.LafReference, Map<String, Object>> myStoredDefaults = new HashMap<LafManager.LafReference, Map<String, Object>>();
    private static final String WINDOW_ALPHA = "Window.alpha";
    private static final Map<String, String> ourLafClassesAliases = Map.of("idea.dark.laf.classname", DarculaLookAndFeelInfo.CLASS_NAME);
    private static final Map<String, Integer> lafNameOrder = Map.of("IntelliJ Light", 0, "macOS Light", 1, "Windows 10 Light", 1, "Darcula", 2, "High contrast", 3);
    private static final int maxNameOrder = Collections.max(lafNameOrder.values());
    private final SynchronizedClearableLazy<CollectionComboBoxModel<LafManager.LafReference>> myLafComboBoxModel = new SynchronizedClearableLazy(() -> new LafComboBoxModel());
    private final Lazy<ActionToolbar> settingsToolbar = new SynchronizedClearableLazy(() -> {
        DefaultActionGroup group2 = new DefaultActionGroup(new AnAction[]{new PreferredLafsAction()});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)group2, true);
        toolbar.getComponent().setOpaque(false);
        return toolbar;
    });
    private final SystemDarkThemeDetector lafDetector = SystemDarkThemeDetector.createDetector(this::syncLaf);
    private static final LafManager.LafReference SEPARATOR = new LafManager.LafReference("", null, null);
    private boolean myFirstSetup = true;
    private boolean myUpdatingPlugin = false;
    @Nullable
    private String myThemeIdBeforePluginUpdate = null;
    private boolean autodetect;
    private static LafManagerImpl ourTestInstance;

    private static UIManager.LookAndFeelInfo getDefaultLightTheme() {
        for (UIThemeProvider provider2 : UIThemeProvider.EP_NAME.getIterable()) {
            UITheme theme2;
            if (!DEFAULT_LIGHT_THEME_ID.equals(provider2.id) || (theme2 = provider2.createTheme()) == null) continue;
            return new UIThemeBasedLookAndFeelInfo(theme2);
        }
        LOG.error("Can't load JetBrainsLightTheme");
        return new IntelliJLookAndFeelInfo();
    }

    @NotNull
    private List<UIManager.LookAndFeelInfo> computeLafList() {
        ArrayList<UIManager.LookAndFeelInfo> lafList = new ArrayList<UIManager.LookAndFeelInfo>();
        lafList.add(this.myDefaultLightLaf);
        lafList.add(this.myDefaultDarkLaf);
        if (!SystemInfoRt.isMac) {
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                String name = laf.getName();
                if ("Metal".equalsIgnoreCase(name) || "CDE/Motif".equalsIgnoreCase(name) || "Nimbus".equalsIgnoreCase(name) || name.startsWith("Windows") || "GTK+".equalsIgnoreCase(name) || name.startsWith("JGoodies")) continue;
                lafList.add(laf);
            }
        }
        LafProvider.EP_NAME.forEachExtensionSafe(provider2 -> lafList.add(provider2.getLookAndFeelInfo()));
        UIThemeProvider.EP_NAME.forEachExtensionSafe(provider2 -> {
            UITheme theme2;
            if (!DEFAULT_LIGHT_THEME_ID.equals(provider2.id) && (theme2 = provider2.createTheme()) != null) {
                lafList.add(new UIThemeBasedLookAndFeelInfo(theme2));
            }
        });
        LafManagerImpl.sortThemes(lafList);
        ArrayList<UIManager.LookAndFeelInfo> arrayList = lafList;
        if (arrayList == null) {
            LafManagerImpl.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void sortThemes(@NotNull List<UIManager.LookAndFeelInfo> list2) {
        if (list2 == null) {
            LafManagerImpl.$$$reportNull$$$0(1);
        }
        list2.sort((t1, t2) -> {
            String n2;
            String n1 = t1.getName();
            if (Objects.equals(n1, n2 = t2.getName())) {
                return 0;
            }
            Integer o1 = lafNameOrder.get(n1);
            Integer o2 = lafNameOrder.get(n2);
            if (o1 != null && o2 != null) {
                return o1 - o2;
            }
            if (o1 != null) {
                return -1;
            }
            if (o2 != null) {
                return 1;
            }
            return n1.compareToIgnoreCase(n2);
        });
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(3);
        }
        if (disposable2 == null) {
            LafManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().getMessageBus().connect(disposable2).subscribe(LafManagerListener.TOPIC, (Object)listener2);
    }

    public void removeLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(5);
        }
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    public void initializeComponent() {
        UIManager.LookAndFeelInfo laf;
        if (this.myCurrentLaf != null && !(this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo) && (laf = this.findLaf(this.myCurrentLaf.getClassName())) != null) {
            boolean needUninstall = StartupUiUtil.isUnderDarcula();
            this.setCurrentLookAndFeel(laf);
            this.updateWizardLAF(needUninstall);
        }
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && !((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).isInitialised()) {
            this.setCurrentLookAndFeel(this.myCurrentLaf);
        }
        this.updateUI();
        UIThemeProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new UIThemeEPListener(), (Disposable)this);
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        bus.connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                LafManagerImpl.this.myUpdatingPlugin = isUpdate;
                LafManagerImpl.this.myThemeIdBeforePluginUpdate = LafManagerImpl.this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo ? ((UIThemeBasedLookAndFeelInfo)LafManagerImpl.this.myCurrentLaf).getTheme().getId() : null;
            }

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                LafManagerImpl.this.myUpdatingPlugin = false;
                LafManagerImpl.this.myThemeIdBeforePluginUpdate = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.detectAndSyncLaf();
    }

    private void detectAndSyncLaf() {
        if (this.lafDetector.getDetectionSupported() && this.autodetect) {
            this.lafDetector.check();
        }
    }

    private void syncLaf(boolean systemDark) {
        if (this.autodetect) {
            UIManager.LookAndFeelInfo expectedLaf;
            boolean currentDark = this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).getTheme().isDark() || StartupUiUtil.isUnderDarcula();
            UIManager.LookAndFeelInfo lookAndFeelInfo = expectedLaf = systemDark ? this.myPreferredDarkLaf : this.myPreferredLightLaf;
            if (currentDark != systemDark || this.myCurrentLaf != expectedLaf) {
                QuickChangeLookAndFeel.switchLafAndUpdateUI(this, expectedLaf, true);
            }
        }
    }

    public void updateWizardLAF(boolean wasUnderDarcula) {
        if (WelcomeWizardUtil.getWizardLAF() == null) {
            return;
        }
        if (StartupUiUtil.isUnderDarcula()) {
            DarculaInstaller.install();
        } else if (wasUnderDarcula) {
            DarculaInstaller.uninstall();
        }
        WelcomeWizardUtil.setWizardLAF(null);
    }

    public void dispose() {
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            LafManagerImpl.$$$reportNull$$$0(6);
        }
        this.myCurrentLaf = this.loadLafState(element2, ELEMENT_LAF);
        if (this.myCurrentLaf == null) {
            this.myCurrentLaf = this.getDefaultLaf();
        }
        this.autodetect = Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_AUTODETECT));
        this.myPreferredLightLaf = Objects.requireNonNullElse(this.loadLafState(element2, ELEMENT_PREFERRED_LIGHT_LAF), this.myDefaultLightLaf);
        this.myPreferredDarkLaf = Objects.requireNonNullElse(this.loadLafState(element2, ELEMENT_PREFERRED_DARK_LAF), this.myDefaultDarkLaf);
    }

    @Nullable
    private UIManager.LookAndFeelInfo loadLafState(@NotNull Element element2, @NonNls String attrName) {
        Element lafElement;
        if (element2 == null) {
            LafManagerImpl.$$$reportNull$$$0(7);
        }
        if ((lafElement = element2.getChild(attrName)) == null) {
            return null;
        }
        return this.findLaf(lafElement.getAttributeValue(ATTRIBUTE_CLASS_NAME), lafElement.getAttributeValue(ATTRIBUTE_THEME_NAME));
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(String lafClassName, String themeId) {
        if (lafClassName != null && ourLafClassesAliases.containsKey(lafClassName)) {
            lafClassName = ourLafClassesAliases.get(lafClassName);
        }
        if (themeId != null) {
            for (UIManager.LookAndFeelInfo l : (List)this.myLaFs.getValue()) {
                if (!(l instanceof UIThemeBasedLookAndFeelInfo) || !((UIThemeBasedLookAndFeelInfo)l).getTheme().getId().equals(themeId)) continue;
                return l;
            }
        }
        if (lafClassName != null) {
            return this.findLaf(lafClassName);
        }
        return null;
    }

    public void noStateLoaded() {
        this.myCurrentLaf = this.getDefaultLaf();
        this.myPreferredLightLaf = this.myDefaultLightLaf;
        this.myPreferredDarkLaf = this.myDefaultDarkLaf;
    }

    public Element getState() {
        Element element2 = new Element("state");
        element2.setAttribute(ATTRIBUTE_AUTODETECT, Boolean.toString(this.autodetect));
        LafManagerImpl.getLafState(element2, ELEMENT_LAF, this.getCurrentLookAndFeel());
        if (this.myPreferredLightLaf != this.myDefaultLightLaf) {
            LafManagerImpl.getLafState(element2, ELEMENT_PREFERRED_LIGHT_LAF, this.myPreferredLightLaf);
        }
        if (this.myPreferredDarkLaf != this.myDefaultDarkLaf) {
            LafManagerImpl.getLafState(element2, ELEMENT_PREFERRED_DARK_LAF, this.myPreferredDarkLaf);
        }
        return element2;
    }

    private static void getLafState(@NotNull Element element2, @NonNls String attrName, UIManager.LookAndFeelInfo laf) {
        String className;
        if (element2 == null) {
            LafManagerImpl.$$$reportNull$$$0(8);
        }
        if (laf instanceof TempUIThemeBasedLookAndFeelInfo) {
            laf = ((TempUIThemeBasedLookAndFeelInfo)laf).getPreviousLaf();
        }
        if (laf != null && (className = laf.getClassName()) != null) {
            Element child2 = new Element(attrName);
            child2.setAttribute(ATTRIBUTE_CLASS_NAME, className);
            if (laf instanceof UIThemeBasedLookAndFeelInfo) {
                child2.setAttribute(ATTRIBUTE_THEME_NAME, ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getId());
            }
            element2.addContent(child2);
        }
    }

    public UIManager.LookAndFeelInfo @NotNull [] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = ((List)this.myLaFs.getValue()).toArray(new UIManager.LookAndFeelInfo[0]);
        if (lookAndFeelInfoArray == null) {
            LafManagerImpl.$$$reportNull$$$0(9);
        }
        return lookAndFeelInfoArray;
    }

    public CollectionComboBoxModel<LafManager.LafReference> getLafComboBoxModel() {
        return (CollectionComboBoxModel)this.myLafComboBoxModel.getValue();
    }

    private List<LafManager.LafReference> getAllReferences() {
        ArrayList<LafManager.LafReference> result2 = new ArrayList<LafManager.LafReference>();
        boolean addSeparator = false;
        for (UIManager.LookAndFeelInfo info : (List)this.myLaFs.getValue()) {
            if (addSeparator) {
                result2.add(SEPARATOR);
                addSeparator = false;
            }
            result2.add(LafManagerImpl.createLafReference(info));
            if (!Objects.equals(lafNameOrder.get(info.getName()), maxNameOrder)) continue;
            addSeparator = true;
        }
        return result2;
    }

    private void updateLafComboboxModel() {
        this.myLafComboBoxModel.drop();
    }

    private void selectComboboxModel() {
        if (this.myLafComboBoxModel.isInitialized()) {
            ((CollectionComboBoxModel)this.myLafComboBoxModel.getValue()).setSelectedItem((Object)LafManagerImpl.createLafReference(this.myCurrentLaf));
        }
    }

    @NotNull
    private static LafManager.LafReference createLafReference(UIManager.LookAndFeelInfo laf) {
        String themeId = null;
        if (laf instanceof UIThemeBasedLookAndFeelInfo) {
            themeId = ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getId();
        }
        return new LafManager.LafReference(laf.getName(), laf.getClassName(), themeId);
    }

    public UIManager.LookAndFeelInfo findLaf(LafManager.LafReference reference2) {
        return this.findLaf(reference2.getClassName(), reference2.getThemeId());
    }

    @Nullable
    public UIManager.LookAndFeelInfo getCurrentLookAndFeel() {
        return this.myCurrentLaf;
    }

    public LafManager.LafReference getLookAndFeelReference() {
        return LafManagerImpl.createLafReference(this.getCurrentLookAndFeel());
    }

    public ListCellRenderer<LafManager.LafReference> getLookAndFeelCellRenderer() {
        return new LafCellRenderer();
    }

    @NotNull
    public JComponent getSettingsToolbar() {
        JComponent jComponent = ((ActionToolbar)this.settingsToolbar.getValue()).getComponent();
        if (jComponent == null) {
            LafManagerImpl.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    @NotNull
    public UIManager.LookAndFeelInfo getDefaultLaf() {
        String defaultLafName;
        UIManager.LookAndFeelInfo laf;
        String appLafName;
        UIManager.LookAndFeelInfo laf2;
        String wizardLafName = WelcomeWizardUtil.getWizardLAF();
        if (wizardLafName != null) {
            UIManager.LookAndFeelInfo laf3 = this.findLaf(wizardLafName);
            if (laf3 != null) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = laf3;
                if (lookAndFeelInfo == null) {
                    LafManagerImpl.$$$reportNull$$$0(11);
                }
                return lookAndFeelInfo;
            }
            LOG.error("Could not find wizard L&F: " + wizardLafName);
        }
        if (SystemInfoRt.isMac) {
            String className = DarculaLaf.class.getName();
            laf2 = this.findLaf(className);
            if (laf2 != null) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = laf2;
                if (lookAndFeelInfo == null) {
                    LafManagerImpl.$$$reportNull$$$0(12);
                }
                return lookAndFeelInfo;
            }
            LOG.error("Could not find OS X L&F: " + className);
        }
        if ((appLafName = WelcomeWizardUtil.getDefaultLAF()) != null) {
            laf2 = this.findLaf(appLafName);
            if (laf2 != null) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = laf2;
                if (lookAndFeelInfo == null) {
                    LafManagerImpl.$$$reportNull$$$0(13);
                }
                return lookAndFeelInfo;
            }
            LOG.error("Could not find app L&F: " + appLafName);
        }
        if ((laf = this.findLaf(defaultLafName = DarculaLaf.class.getName())) != null) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = laf;
            if (lookAndFeelInfo == null) {
                LafManagerImpl.$$$reportNull$$$0(14);
            }
            return lookAndFeelInfo;
        }
        throw new IllegalStateException("No default L&F found: " + defaultLafName);
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(@NotNull String className) {
        if (className == null) {
            LafManagerImpl.$$$reportNull$$$0(15);
        }
        if (this.myDefaultLightLaf.getClassName().equals(className)) {
            return this.myDefaultLightLaf;
        }
        if (this.myDefaultDarkLaf.getClassName().equals(className)) {
            return this.myDefaultDarkLaf;
        }
        for (UIManager.LookAndFeelInfo l : (List)this.myLaFs.getValue()) {
            if (l instanceof UIThemeBasedLookAndFeelInfo || !Objects.equals(l.getClassName(), className)) continue;
            return l;
        }
        return null;
    }

    public void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo, boolean lockEditorScheme) {
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(16);
        }
        this.setLookAndFeelImpl(lookAndFeelInfo, lockEditorScheme, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void setLookAndFeelImpl(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo, boolean lockEditorScheme, boolean processChangeSynchronously) {
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(17);
        }
        oldLaf = this.myCurrentLaf;
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo) {
            ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).dispose();
        }
        if (this.findLaf(lookAndFeelInfo.getClassName()) == null) {
            LafManagerImpl.LOG.error("unknown LookAndFeel : " + lookAndFeelInfo);
            return;
        }
        UIManager.getDefaults().clear();
        UIManager.getDefaults().putAll(this.ourDefaults);
        SVGLoader.setColorPatcherForSelection(null);
        if ("idea.laf.classname".equals(lookAndFeelInfo.getClassName())) {
            laf /* !! */  = new IdeaLaf();
            MetalLookAndFeel.setCurrentTheme(new IdeaBlueMetalTheme());
            try {
                UIManager.setLookAndFeel(laf /* !! */ );
                LafManagerImpl.updateIconsUnderSelection(false);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                LafManagerImpl.LOG.error((Throwable)e);
                return;
            }
        }
        if (DarculaLookAndFeelInfo.CLASS_NAME.equals(lookAndFeelInfo.getClassName())) {
            laf /* !! */  = new DarculaLaf();
            try {
                UIManager.setLookAndFeel(laf /* !! */ );
                AppUIUtil.updateForDarcula(true);
                if (!LafManagerImpl.lafNameOrder.containsKey(lookAndFeelInfo.getName())) ** GOTO lbl55
                LafManagerImpl.updateIconsUnderSelection(true);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                LafManagerImpl.LOG.error((Throwable)e);
                return;
            }
        } else {
            try {
                if (lookAndFeelInfo instanceof PluggableLafInfo) {
                    laf /* !! */  = ((PluggableLafInfo)lookAndFeelInfo).createLookAndFeel();
                } else {
                    laf /* !! */  = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (laf /* !! */  instanceof MetalLookAndFeel) {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    } else if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
                        if (laf /* !! */  instanceof UserDataHolder) {
                            userDataHolder = (UserDataHolder)laf /* !! */ ;
                            userDataHolder.putUserData(UIUtil.LAF_WITH_THEME_KEY, (Object)Boolean.TRUE);
                        }
                        if (LafManagerImpl.lafNameOrder.containsKey(lookAndFeelInfo.getName()) && lookAndFeelInfo.getName().endsWith("Light")) {
                            LafManagerImpl.updateIconsUnderSelection(false);
                        }
                    }
                }
                UIManager.setLookAndFeel(laf /* !! */ );
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                LafManagerImpl.LOG.error((Throwable)e);
                return;
            }
        }
lbl55:
        // 4 sources

        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
            try {
                ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).installTheme(UIManager.getLookAndFeelDefaults(), lockEditorScheme);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                LafManagerImpl.LOG.error((Throwable)e);
                return;
            }
        }
        if (SystemInfoRt.isMac) {
            LafManagerImpl.installMacOSXFonts(UIManager.getLookAndFeelDefaults());
        }
        this.myCurrentLaf = (UIManager.LookAndFeelInfo)ObjectUtils.chooseNotNull((Object)lookAndFeelInfo, (Object)this.findLaf(lookAndFeelInfo.getClassName()));
        this.selectComboboxModel();
        if (!this.myFirstSetup && !lockEditorScheme) {
            if (processChangeSynchronously) {
                this.updateEditorSchemeIfNecessary(oldLaf, true);
            } else {
                ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$setLookAndFeelImpl$6(javax.swing.UIManager$LookAndFeelInfo ), ()V)((LafManagerImpl)this, (UIManager.LookAndFeelInfo)oldLaf));
            }
        }
        this.myFirstSetup = false;
    }

    private static void updateIconsUnderSelection(boolean darcula) {
        final HashMap<String, String> map2 = new HashMap<String, String>();
        if (darcula) {
            map2.put("#5e5e5e", "#5778ad");
            map2.put("#c75450", "#a95768");
            map2.put("#6e6e6e", "#afb1b3");
            map2.put("#f26522b3", "#bc6b43");
            map2.put("#f2652299", "#bc6b43");
            map2.put("#62b54399", "#579b41");
            map2.put("#f98b9e99", "#ba7481");
            map2.put("#f4af3d99", "#aa823f");
            map2.put("#b99bf899", "#977fca");
            map2.put("#9aa7b0cc", "#97acc6");
            map2.put("#9aa7b099", "#97acc6");
        } else {
            map2.put("#6e6e6e", "#afb1b3");
            map2.put("#db5860", "#b75e73");
            map2.put("#f26522b3", "#d38369");
            map2.put("#f2652299", "#d38369");
            map2.put("#40b6e099", "#5eb6d4");
            map2.put("#62b54399", "#7ebe65");
            map2.put("#f98b9e99", "#f1a4b2");
            map2.put("#f4af3d99", "#ecc27d");
            map2.put("#b99bf899", "#b49ee2");
            map2.put("#9aa7b0cc", "#aebdc6");
            map2.put("#9aa7b099", "#aebdc6");
            map2.put("#40b6e0b3", "#5eb6d4");
            map2.put("#62b543b3", "#7ebe65");
            map2.put("#f98b9eb3", "#f1a4b2");
            map2.put("#f4af3db3", "#ecc27d");
            map2.put("#b99bf8b3", "#b49ee2");
        }
        final HashMap alpha = new HashMap(map2.size());
        map2.forEach((key, value2) -> alpha.put(value2, 255));
        SVGLoader.setColorPatcherForSelection((SVGLoader.SvgElementColorPatcherProvider)new SVGLoader.SvgElementColorPatcherProvider(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable SVGLoader.SvgElementColorPatcher forPath(@Nullable String path) {
                return SVGLoader.newPatcher(null, (Map)map2, (Map)alpha);
            }
        });
    }

    private void updateEditorSchemeIfNecessary(UIManager.LookAndFeelInfo oldLaf, boolean processChangeSynchronously) {
        if (oldLaf instanceof TempUIThemeBasedLookAndFeelInfo || this.myCurrentLaf instanceof TempUIThemeBasedLookAndFeelInfo) {
            return;
        }
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).getTheme().getEditorSchemeName() != null) {
            return;
        }
        boolean dark = StartupUiUtil.isUnderDarcula();
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme current2 = colorsManager.getGlobalScheme();
        boolean wasUITheme = oldLaf instanceof UIThemeBasedLookAndFeelInfo;
        if (dark != ColorUtil.isDark((Color)current2.getDefaultBackground()) || wasUITheme) {
            EditorColorsScheme scheme;
            String targetScheme = dark ? "Darcula" : "Default";
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String savedEditorThemeKey = dark ? DARCULA_EDITOR_THEME_KEY : DEFAULT_EDITOR_THEME_KEY;
            String toSavedEditorThemeKey = dark ? DEFAULT_EDITOR_THEME_KEY : DARCULA_EDITOR_THEME_KEY;
            String themeName = properties.getValue(savedEditorThemeKey);
            if (themeName != null && colorsManager.getScheme(themeName) != null) {
                targetScheme = themeName;
            }
            if (!wasUITheme) {
                properties.setValue(toSavedEditorThemeKey, current2.getName(), dark ? "Default" : "Darcula");
            }
            if ((scheme = colorsManager.getScheme(targetScheme)) != null) {
                ((EditorColorsManagerImpl)colorsManager).setGlobalScheme(scheme, processChangeSynchronously);
            }
        }
        UISettings.getShadowInstance().fireUISettingsChanged();
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    public void updateUI() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        uiDefaults.put("LinkButtonUI", DefaultLinkButtonUI.class.getName());
        LafManagerImpl.fixPopupWeight();
        LafManagerImpl.fixMenuIssues(uiDefaults);
        LafManagerImpl.initInputMapDefaults(uiDefaults);
        uiDefaults.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
        uiDefaults.put("Balloon.error.textInsets", new JBInsets(3, 8, 3, 8).asUIResource());
        LafManagerImpl.patchFileChooserStrings(uiDefaults);
        this.patchLafFonts(uiDefaults);
        LafManagerImpl.patchListUI(uiDefaults);
        LafManagerImpl.patchTreeUI(uiDefaults);
        LafManagerImpl.patchHiDPI(uiDefaults);
        this.fixMacOSDarkThemeDecorations();
        uiDefaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
        uiDefaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, (Object)UIUtil.getLcdContrastValue());
        uiDefaults.put(RenderingHints.KEY_FRACTIONALMETRICS, AppUIUtil.adjustFractionalMetrics(UISettings.getPREFERRED_FRACTIONAL_METRICS_VALUE()));
        for (Frame frame : Frame.getFrames()) {
            LafManagerImpl.updateUI(frame);
        }
        ((LafManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LafManagerListener.TOPIC)).lookAndFeelChanged((LafManager)this);
        ((LafManagerListener)this.myEventDispatcher.getMulticaster()).lookAndFeelChanged((LafManager)this);
    }

    private void fixMacOSDarkThemeDecorations() {
        if (!SystemInfo.isMacOSMojave) {
            return;
        }
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, int size, @JdkConstants.FontStyle int style) {
        Font font;
        if (SystemInfoRt.isMac && !StartupUiUtil.isDialogFont((Font)(font = FontUtil.enableKerning((Font)new Font(SystemInfo.isMacOSCatalina ? ".AppleSystemUIFont" : ".SF NS Text", style, size))))) {
            return new FontUIResource(font);
        }
        return new FontUIResource(yosemite, style, size);
    }

    public static void installMacOSXFonts(UIDefaults defaults) {
        String face = "Helvetica Neue";
        FontUIResource uiFont = LafManagerImpl.getFont("Helvetica Neue", 13, 0);
        LafManagerImpl.initFontDefaults(defaults, uiFont);
        for (Object key : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value2;
            if (!(key instanceof String) || !Strings.endsWithIgnoreCase((CharSequence)((String)key), (String)"font") || !((value2 = defaults.get(key)) instanceof FontUIResource) || !(font = (FontUIResource)value2).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, LafManagerImpl.getFont("Helvetica Neue", font.getSize(), font.getStyle()));
        }
        FontUIResource uiFont11 = LafManagerImpl.getFont("Helvetica Neue", 11, 0);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = LafManagerImpl.getFont("Helvetica Neue", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = LafManagerImpl.getFont("Lucida Grande", 14, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    private static void patchBorder(UIDefaults defaults, String key) {
        if (defaults.getBorder(key) == null) {
            defaults.put(key, JBUI.Borders.empty((int)1, (int)0).asUIResource());
        }
    }

    private static void patchListUI(UIDefaults defaults) {
        LafManagerImpl.patchBorder(defaults, "List.border");
    }

    private static void patchTreeUI(UIDefaults defaults) {
        LafManagerImpl.patchBorder(defaults, "Tree.border");
        defaults.put("TreeUI", DefaultTreeUI.class.getName());
        defaults.put("Tree.repaintWholeRow", (Object)true);
        if (LafManagerImpl.isUnsupported(defaults.getIcon("Tree.collapsedIcon"))) {
            defaults.put("Tree.collapsedIcon", LafIconLookup.getIcon((String)"treeCollapsed"));
            defaults.put("Tree.collapsedSelectedIcon", LafIconLookup.getSelectedIcon((String)"treeCollapsed"));
        }
        if (LafManagerImpl.isUnsupported(defaults.getIcon("Tree.expandedIcon"))) {
            defaults.put("Tree.expandedIcon", LafIconLookup.getIcon((String)"treeExpanded"));
            defaults.put("Tree.expandedSelectedIcon", LafIconLookup.getSelectedIcon((String)"treeExpanded"));
        }
    }

    private static boolean isUnsupported(@Nullable Icon icon2) {
        String name = icon2 == null ? null : icon2.getClass().getName();
        return name == null || name.startsWith("javax.swing.plaf.") || name.startsWith("com.sun.java.swing.plaf.");
    }

    private static void patchHiDPI(UIDefaults defaults) {
        Object prevScaleVal = defaults.get("hidpi.scaleFactor");
        float prevScale = prevScaleVal != null ? ((Float)prevScaleVal).floatValue() : 1.0f;
        float prevRowHeightScale = prevScaleVal != null || SystemInfo.isMac || SystemInfo.isWindows ? prevScale : JBUIScale.getFontScale((float)12.0f);
        LafManagerImpl.patchRowHeight(defaults, "List.rowHeight", prevRowHeightScale);
        LafManagerImpl.patchRowHeight(defaults, "Table.rowHeight", prevRowHeightScale);
        LafManagerImpl.patchRowHeight(defaults, "Tree.rowHeight", prevRowHeightScale);
        if (prevScale == JBUIScale.scale((float)1.0f) && prevScaleVal != null) {
            return;
        }
        List<String> myIntKeys = Arrays.asList("Tree.leftChildIndent", "Tree.rightChildIndent", "SettingsTree.rowHeight");
        List<String> myDimensionKeys = Arrays.asList("Slider.horizontalSize", "Slider.verticalSize", "Slider.minimumHorizontalSize", "Slider.minimumVerticalSize");
        for (Map.Entry entry : defaults.entrySet()) {
            Object value2 = entry.getValue();
            String key = entry.getKey().toString();
            if (value2 instanceof Dimension) {
                if (!(value2 instanceof UIResource) && !myDimensionKeys.contains(key)) continue;
                entry.setValue(JBUI.size((Dimension)((Dimension)value2)).asUIResource());
                continue;
            }
            if (value2 instanceof Insets) {
                if (!(value2 instanceof UIResource)) continue;
                entry.setValue(JBUI.insets((Insets)((Insets)value2)).asUIResource());
                continue;
            }
            if (!(value2 instanceof Integer) || !key.endsWith(".maxGutterIconWidth") && !myIntKeys.contains(key)) continue;
            int normValue = (int)((float)((Integer)value2).intValue() / prevScale);
            entry.setValue(JBUIScale.scale((int)normValue));
        }
        defaults.put("hidpi.scaleFactor", Float.valueOf(JBUIScale.scale((float)1.0f)));
    }

    private static void patchRowHeight(UIDefaults defaults, String key, float prevScale) {
        int rowHeight;
        Object value2 = defaults.get(key);
        int n = rowHeight = value2 instanceof Integer ? (Integer)value2 : 0;
        if (!SystemInfoRt.isMac && !SystemInfoRt.isWindows && Registry.is((String)"linux.row.height.disabled", (boolean)true)) {
            rowHeight = 0;
        } else if (rowHeight <= 0) {
            LOG.warn(key + " = " + value2 + " in " + UIManager.getLookAndFeel().getName() + "; it may lead to performance degradation");
        }
        defaults.put(key, (Object)(rowHeight <= 0 ? 0 : JBUIScale.scale((int)((int)((float)rowHeight / prevScale)))));
    }

    private static void fixMenuIssues(@NotNull UIDefaults uiDefaults) {
        if (uiDefaults == null) {
            LafManagerImpl.$$$reportNull$$$0(18);
        }
        uiDefaults.put("Menu.arrowIcon", new DefaultMenuArrowIcon());
        uiDefaults.put("MenuItem.background", UIManager.getColor("Menu.background"));
    }

    private static void fixPopupWeight() {
        int popupWeight = 1;
        String property = System.getProperty("idea.popup.weight");
        if (property != null) {
            property = Strings.toLowerCase((String)property).trim();
        }
        if (SystemInfoRt.isMac) {
            popupWeight = 2;
        } else if (property == null) {
            if (SystemInfoRt.isWindows) {
                popupWeight = 2;
            }
        } else if ("light".equals(property)) {
            popupWeight = 0;
        } else if ("heavy".equals(property)) {
            popupWeight = 2;
        } else if (!"medium".equals(property)) {
            LOG.error("Illegal value of property \"idea.popup.weight\": " + property);
        }
        PopupFactory factory2 = PopupFactory.getSharedInstance();
        if (!(factory2 instanceof OurPopupFactory)) {
            factory2 = new OurPopupFactory(factory2);
            PopupFactory.setSharedInstance(factory2);
        }
        PopupUtil.setPopupType((PopupFactory)factory2, (int)popupWeight);
    }

    private static void patchFileChooserStrings(UIDefaults defaults) {
        if (!defaults.containsKey(ourFileChooserTextKeys[0])) {
            for (String key : ourFileChooserTextKeys) {
                defaults.put(key, IdeBundle.message((String)key, (Object[])new Object[0]));
            }
        }
    }

    private void patchLafFonts(UIDefaults uiDefaults) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            this.storeOriginalFontDefaults(uiDefaults);
            LafManagerImpl.initFontDefaults(uiDefaults, UIUtil.getFontWithFallback((String)uiSettings.getFontFace(), (int)0, (int)uiSettings.getFontSize()));
            JBUIScale.setUserScaleFactor((float)JBUIScale.getFontScale((float)uiSettings.getFontSize()));
        } else {
            this.restoreOriginalFontDefaults(uiDefaults);
        }
    }

    private void restoreOriginalFontDefaults(UIDefaults defaults) {
        LafManager.LafReference lf = this.myCurrentLaf == null ? null : this.getLookAndFeelReference();
        Map<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults != null) {
            for (String resource : ourPatchableFontResources) {
                defaults.put(resource, lfDefaults.get(resource));
            }
        }
        JBUIScale.setUserScaleFactor((float)JBUIScale.getFontScale((float)JBFont.label().getSize()));
    }

    private void storeOriginalFontDefaults(UIDefaults defaults) {
        LafManager.LafReference lf = this.myCurrentLaf == null ? null : this.getLookAndFeelReference();
        Map<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults == null) {
            lfDefaults = new HashMap<String, Object>();
            for (String resource : ourPatchableFontResources) {
                lfDefaults.put(resource, defaults.get(resource));
            }
            this.myStoredDefaults.put(lf, lfDefaults);
        }
    }

    private static void updateUI(Window window) {
        Window[] children2;
        IJSwingUtilities.updateComponentTreeUI(window);
        for (Window w : children2 = window.getOwnedWindows()) {
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }

    public void repaintUI() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.repaintUI(frame);
        }
    }

    public boolean getAutodetect() {
        return this.autodetect;
    }

    public void setAutodetect(boolean value2) {
        this.autodetect = value2;
        if (this.autodetect) {
            this.detectAndSyncLaf();
        }
    }

    public boolean getAutodetectSupported() {
        return this.lafDetector.getDetectionSupported();
    }

    private static void repaintUI(Window window) {
        Window[] children2;
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        for (Window aChildren : children2 = window.getOwnedWindows()) {
            LafManagerImpl.repaintUI(aChildren);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 64), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 64), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 128), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "cut-to-clipboard");
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    public static void initFontDefaults(@NotNull UIDefaults defaults, @NotNull FontUIResource uiFont) {
        if (defaults == null) {
            LafManagerImpl.$$$reportNull$$$0(19);
        }
        if (uiFont == null) {
            LafManagerImpl.$$$reportNull$$$0(20);
        }
        defaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource textFont = new FontUIResource(uiFont);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, uiFont.getSize());
        for (String fontResource : ourPatchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        if (!SystemInfoRt.isMac) {
            defaults.put("PasswordField.font", monoFont);
        }
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    @TestOnly
    public static LafManagerImpl getTestInstance() {
        if (ourTestInstance == null) {
            ourTestInstance = new LafManagerImpl();
        }
        return ourTestInstance;
    }

    private /* synthetic */ void lambda$setLookAndFeelImpl$6(UIManager.LookAndFeelInfo oldLaf) {
        this.updateEditorSchemeIfNecessary(oldLaf, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookAndFeelInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiDefaults";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLafList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledLookAndFeels";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsToolbar";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLaf";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sortThemes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLafManagerListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeLafManagerListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadLafState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLafState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findLaf";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLookAndFeel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setLookAndFeelImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixMenuIssues";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initFontDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class LafToggleAction
    extends ToggleAction {
        private final UIManager.LookAndFeelInfo lafInfo;
        private final boolean isDark;

        private LafToggleAction(String name, UIManager.LookAndFeelInfo lafInfo, boolean isDark) {
            super(name);
            this.lafInfo = lafInfo;
            this.isDark = isDark;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                LafToggleAction.$$$reportNull$$$0(0);
            }
            return this.isDark ? this.lafInfo == LafManagerImpl.this.myPreferredDarkLaf : this.lafInfo == LafManagerImpl.this.myPreferredLightLaf;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                LafToggleAction.$$$reportNull$$$0(1);
            }
            if (this.isDark) {
                if (LafManagerImpl.this.myPreferredDarkLaf != this.lafInfo) {
                    LafManagerImpl.this.myPreferredDarkLaf = this.lafInfo;
                    LafManagerImpl.this.detectAndSyncLaf();
                }
            } else if (LafManagerImpl.this.myPreferredLightLaf != this.lafInfo) {
                LafManagerImpl.this.myPreferredLightLaf = this.lafInfo;
                LafManagerImpl.this.detectAndSyncLaf();
            }
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$LafToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class PreferredLafsAction
    extends DefaultActionGroup {
        private PreferredLafsAction() {
            this.setPopup(true);
            this.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
            this.getTemplatePresentation().setText(IdeBundle.message((String)"preferred.theme.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setDescription(IdeBundle.message((String)"preferred.theme.description", (Object[])new Object[0]));
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                PreferredLafsAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PreferredLafsAction.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"preferred.theme.text", (Object[])new Object[0]), this.getLafGroups(), e.getDataContext(), true, null, Integer.MAX_VALUE);
            HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)popup2);
            Component component2 = e.getInputEvent().getComponent();
            if (component2 instanceof ActionButtonComponent) {
                popup2.showUnderneathOf(component2);
            } else {
                popup2.showInCenterOf(component2);
            }
        }

        private ActionGroup getLafGroups() {
            ArrayList<UIManager.LookAndFeelInfo> lightLafs = new ArrayList<UIManager.LookAndFeelInfo>();
            ArrayList<UIManager.LookAndFeelInfo> darkLafs = new ArrayList<UIManager.LookAndFeelInfo>();
            for (UIManager.LookAndFeelInfo lafInfo : (List)LafManagerImpl.this.myLaFs.getValue()) {
                if (lafInfo instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)lafInfo).getTheme().isDark() || lafInfo.getName().equals("Darcula")) {
                    darkLafs.add(lafInfo);
                    continue;
                }
                lightLafs.add(lafInfo);
            }
            DefaultActionGroup myGroup = new DefaultActionGroup();
            myGroup.addAll(this.createThemeActions(IdeBundle.message((String)"preferred.theme.light.header", (Object[])new Object[0]), lightLafs, false));
            myGroup.addAll(this.createThemeActions(IdeBundle.message((String)"preferred.theme.dark.header", (Object[])new Object[0]), darkLafs, true));
            return myGroup;
        }

        private Collection<AnAction> createThemeActions(@NotNull @NlsContexts.Separator String separatorText, List<UIManager.LookAndFeelInfo> lafs, boolean isDark) {
            if (separatorText == null) {
                PreferredLafsAction.$$$reportNull$$$0(2);
            }
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            if (!lafs.isEmpty()) {
                result2.add((AnAction)Separator.create((String)separatorText));
                lafs.stream().map(l -> {
                    @NlsSafe String name = l.getName();
                    return new LafToggleAction(name, (UIManager.LookAndFeelInfo)l, isDark);
                }).forEach(a -> result2.add((AnAction)a));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separatorText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$PreferredLafsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBePerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createThemeActions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class LafComboBoxModel
    extends CollectionComboBoxModel<LafManager.LafReference> {
        private LafComboBoxModel() {
            super(LafManagerImpl.this.getAllReferences());
        }

        public void setSelectedItem(@Nullable Object item) {
            if (item == SEPARATOR) {
                return;
            }
            super.setSelectedItem(item);
        }
    }

    private static class LafCellRenderer
    extends SimpleListCellRenderer<LafManager.LafReference> {
        private static final SeparatorWithText separator = new SeparatorWithText(){

            protected void paintComponent(Graphics g) {
                g.setColor(this.getForeground());
                Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds2, (Insets)this.getInsets());
                this.paintLine(g, bounds2.x, bounds2.y + bounds2.height / 2, bounds2.width);
            }
        };

        private LafCellRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends LafManager.LafReference> list2, LafManager.LafReference value2, int index, boolean isSelected, boolean cellHasFocus) {
            return value2 == SEPARATOR ? separator : super.getListCellRendererComponent(list2, (Object)value2, index, isSelected, cellHasFocus);
        }

        public void customize(@NotNull JList<? extends LafManager.LafReference> list2, LafManager.LafReference value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                LafCellRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value2.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/ui/laf/LafManagerImpl$LafCellRenderer", "customize"));
        }
    }

    private class UIThemeEPListener
    implements ExtensionPointListener<UIThemeProvider> {
        private UIThemeEPListener() {
        }

        public void extensionAdded(@NotNull UIThemeProvider provider2, @NotNull PluginDescriptor pluginDescriptor) {
            if (provider2 == null) {
                UIThemeEPListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                UIThemeEPListener.$$$reportNull$$$0(1);
            }
            for (UIManager.LookAndFeelInfo feel : LafManagerImpl.this.getInstalledLookAndFeels()) {
                if (!(feel instanceof UIThemeBasedLookAndFeelInfo) || !((UIThemeBasedLookAndFeelInfo)feel).getTheme().getId().equals(provider2.id)) continue;
                return;
            }
            UITheme theme2 = provider2.createTheme();
            if (theme2 == null) {
                return;
            }
            ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).handleThemeAdded(theme2);
            List lafList = (List)LafManagerImpl.this.myLaFs.getValue();
            ArrayList<UIManager.LookAndFeelInfo> newLaFs = new ArrayList<UIManager.LookAndFeelInfo>(lafList.size() + 1);
            newLaFs.addAll(lafList);
            UIThemeBasedLookAndFeelInfo newTheme = new UIThemeBasedLookAndFeelInfo(theme2);
            newLaFs.add(newTheme);
            LafManagerImpl.sortThemes(newLaFs);
            LafManagerImpl.this.myLaFs.setValue(newLaFs);
            LafManagerImpl.this.updateLafComboboxModel();
            if (!(LafManagerImpl.this.autodetect || LafManagerImpl.this.myUpdatingPlugin && !newTheme.getTheme().getId().equals(LafManagerImpl.this.myThemeIdBeforePluginUpdate))) {
                LafManagerImpl.this.setLookAndFeelImpl(newTheme, false, false);
                JBColor.setDark((boolean)newTheme.getTheme().isDark());
                LafManagerImpl.this.updateUI();
            }
        }

        public void extensionRemoved(@NotNull UIThemeProvider provider2, @NotNull PluginDescriptor pluginDescriptor) {
            if (provider2 == null) {
                UIThemeEPListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                UIThemeEPListener.$$$reportNull$$$0(3);
            }
            UIManager.LookAndFeelInfo switchLafTo = null;
            ArrayList<UIManager.LookAndFeelInfo> list2 = new ArrayList<UIManager.LookAndFeelInfo>();
            for (UIManager.LookAndFeelInfo lookAndFeel : LafManagerImpl.this.getInstalledLookAndFeels()) {
                UITheme theme2;
                if (lookAndFeel instanceof UIThemeBasedLookAndFeelInfo && (theme2 = ((UIThemeBasedLookAndFeelInfo)lookAndFeel).getTheme()).getId().equals(provider2.id)) {
                    if (lookAndFeel == LafManagerImpl.this.getCurrentLookAndFeel()) {
                        switchLafTo = theme2.isDark() ? LafManagerImpl.this.myDefaultDarkLaf : LafManagerImpl.this.myDefaultLightLaf;
                    }
                    ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).handleThemeRemoved(theme2);
                    continue;
                }
                list2.add(lookAndFeel);
            }
            LafManagerImpl.this.myLaFs.setValue(list2);
            LafManagerImpl.this.updateLafComboboxModel();
            if (switchLafTo != null) {
                LafManagerImpl.this.setLookAndFeelImpl(switchLafTo, false, true);
                JBColor.setDark((switchLafTo == LafManagerImpl.this.myDefaultDarkLaf ? 1 : 0) != 0);
                LafManagerImpl.this.updateUI();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$UIThemeEPListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultMenuArrowIcon
    extends MenuArrowIcon {
        private static final BooleanSupplier dark = () -> ColorUtil.isDark((Color)UIManager.getColor("MenuItem.selectionBackground"));

        private DefaultMenuArrowIcon() {
            super((Function0<? extends Icon>)((Function0)() -> AllIcons.Icons.Ide.NextStep), (Function0<? extends Icon>)((Function0)() -> dark.getAsBoolean() ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep), (Function0<? extends Icon>)((Function0)() -> IconLoader.getDisabledIcon((Icon)AllIcons.Icons.Ide.NextStep)));
        }
    }

    private static final class OurPopupFactory
    extends PopupFactory {
        public static final int WEIGHT_LIGHT = 0;
        public static final int WEIGHT_MEDIUM = 1;
        public static final int WEIGHT_HEAVY = 2;
        private final PopupFactory myDelegate;

        OurPopupFactory(PopupFactory delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int x, int y) {
            boolean isHeavyWeightPopup;
            Point point = OurPopupFactory.fixPopupLocation(contents, x, y);
            int popupType = PopupUtil.getPopupType((PopupFactory)this);
            if (popupType == 2 && OurHeavyWeightPopup.isEnabled()) {
                return new OurHeavyWeightPopup(owner, contents, point.x, point.y);
            }
            if (popupType >= 0) {
                PopupUtil.setPopupType((PopupFactory)this.myDelegate, (int)popupType);
            }
            Popup popup2 = this.myDelegate.getPopup(owner, contents, point.x, point.y);
            final Window window = ComponentUtil.getWindow((Component)contents);
            final String cleanupKey = "LafManagerImpl.rootPaneCleanup";
            boolean bl = isHeavyWeightPopup = window instanceof RootPaneContainer && window != ComponentUtil.getWindow((Component)owner);
            if (isHeavyWeightPopup) {
                UIUtil.markAsTypeAheadAware((Window)window);
                window.setMinimumSize(null);
            }
            if (isHeavyWeightPopup && ((RootPaneContainer)((Object)window)).getRootPane().getClientProperty(cleanupKey) == null) {
                final JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                rootPane.setGlassPane(new IdeGlassPaneImpl(rootPane, false));
                rootPane.putClientProperty(LafManagerImpl.WINDOW_ALPHA, Float.valueOf(1.0f));
                rootPane.putClientProperty(cleanupKey, cleanupKey);
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        if (PopupUtil.getPopupContainerFor((Component)rootPane) != null) {
                            window.removeWindowListener(this);
                            rootPane.putClientProperty(cleanupKey, null);
                        }
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        window.removeWindowListener(this);
                        rootPane.putClientProperty(cleanupKey, null);
                        DialogWrapper.cleanupRootPane((JRootPane)rootPane);
                        DialogWrapper.cleanupWindowListeners((Window)window);
                    }
                });
            }
            return popup2;
        }

        private static Point fixPopupLocation(Component contents, int x, int y) {
            PointerInfo info;
            if (!(contents instanceof JToolTip)) {
                return new Point(x, y);
            }
            try {
                info = MouseInfo.getPointerInfo();
            }
            catch (InternalError e) {
                return new Point(x, y);
            }
            int deltaY = 0;
            if (info != null) {
                Point mouse = info.getLocation();
                deltaY = mouse.y - y;
            }
            Dimension size = contents.getPreferredSize();
            Rectangle rec = new Rectangle(new Point(x, y), size);
            ScreenUtil.moveRectangleToFitTheScreen((Rectangle)rec);
            if (rec.y < y) {
                rec.y += deltaY;
            }
            return rec.getLocation();
        }
    }
}

