/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.rulerguide;

import com.intellij.internal.rulerguide.ComponentBounds;
import com.intellij.ui.Graphics2DDelegate;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

final class SneakyGraphics2D
extends Graphics2DDelegate {
    private final Collection<ComponentBounds> poi;

    SneakyGraphics2D(Graphics2D g2d) {
        super(g2d);
        this.poi = new LinkedHashSet<ComponentBounds>();
    }

    private SneakyGraphics2D(Graphics2D g2d, Collection<ComponentBounds> poi) {
        super(g2d);
        this.poi = poi;
    }

    public Collection<ComponentBounds> getPOI() {
        return Collections.unmodifiableCollection(this.poi);
    }

    public void drawChars(char[] data2, int offset, int length, int x, int y) {
        super.drawChars(data2, offset, length, x, y);
        if (data2.length > 0) {
            this.updateBaselines(x, y);
        }
    }

    public void drawString(AttributedCharacterIterator iterator2, float x, float y) {
        super.drawString(iterator2, x, y);
        this.updateBaselines(x, y);
    }

    public void drawString(AttributedCharacterIterator iterator2, int x, int y) {
        super.drawString(iterator2, x, y);
        this.updateBaselines(x, y);
    }

    public void drawString(String s, float x, float y) {
        super.drawString(s, x, y);
        if (!s.isEmpty()) {
            this.updateBaselines(x, y);
        }
    }

    public void drawString(String str, int x, int y) {
        super.drawString(str, x, y);
        if (!str.isEmpty()) {
            this.updateBaselines(x, y);
        }
    }

    private void updateBaselines(float x, float y) {
        Point text2 = (Point)this.getTransform().transform(new Point2D.Float(x, y), new Point());
        Rectangle cb = this.getClipBounds();
        Point start2 = (Point)this.getTransform().transform(new Point(cb.x, cb.y), new Point());
        Point end = (Point)this.getTransform().transform(new Point(cb.x + cb.width, cb.y + cb.height), new Point());
        int minX = Math.min(start2.x, end.x);
        int minY = Math.min(start2.y, end.y);
        int maxX = Math.max(start2.x, end.x);
        int maxY = Math.max(start2.y, end.y);
        ComponentBounds bounds2 = new ComponentBounds(minX, minY, maxX - minX, maxY - minY, -1, -1);
        bounds2.horizontalBaseline = text2.y - bounds2.y;
        bounds2.verticalBaseline = text2.x - bounds2.x;
        this.poi.add(bounds2);
    }

    @NotNull
    public Graphics create() {
        return new SneakyGraphics2D((Graphics2D)super.create(), this.poi);
    }
}

